/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassDeclaredMemberIndex$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.DeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaLoadingKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public class ClassDeclaredMemberIndex
implements DeclaredMemberIndex {
    private final JavaClass jClass;
    private final Function1<JavaMember, Boolean> memberFilter;
    private final Function1<JavaMethod, Boolean> methodFilter;
    private final Map<Name, List<JavaMethod>> methods;
    private final Map<Name, JavaField> fields;
    private final Map<Name, JavaRecordComponent> components;

    public ClassDeclaredMemberIndex(JavaClass object, Function1<? super JavaMember, Boolean> object2) {
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(object2, (String)"");
        this.jClass = object;
        this.memberFilter = object2;
        object = this;
        this.methodFilter = new ClassDeclaredMemberIndex$$Lambda$0((ClassDeclaredMemberIndex)object);
        ClassDeclaredMemberIndex classDeclaredMemberIndex = this;
        object = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)classDeclaredMemberIndex.jClass.getMethods()), this.methodFilter);
        ClassDeclaredMemberIndex classDeclaredMemberIndex2 = classDeclaredMemberIndex;
        object2 = object;
        object = new LinkedHashMap();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object v;
            object6 = object2.next();
            object5 = (JavaMethod)object6;
            object5 = object;
            object4 = object5.getName();
            object3 = object5.get(object4);
            if (object3 == null) {
                object3 = new ArrayList();
                object5.put(object4, object3);
                v = object3;
            } else {
                v = object3;
            }
            object5 = (List)v;
            object5.add(object6);
        }
        classDeclaredMemberIndex2.methods = object;
        ClassDeclaredMemberIndex classDeclaredMemberIndex3 = this;
        object = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)classDeclaredMemberIndex3.jClass.getFields()), this.memberFilter);
        classDeclaredMemberIndex2 = classDeclaredMemberIndex3;
        object2 = object;
        object = new LinkedHashMap();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object6 = object2.next();
            object5 = (JavaField)object6;
            object3 = object;
            object3.put((Name)object5.getName(), object6);
        }
        classDeclaredMemberIndex2.fields = object;
        ClassDeclaredMemberIndex classDeclaredMemberIndex4 = this;
        object = classDeclaredMemberIndex4.jClass.getRecordComponents();
        object2 = this.memberFilter;
        classDeclaredMemberIndex2 = classDeclaredMemberIndex4;
        object4 = new ArrayList();
        object6 = object.iterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!((Boolean)object2.invoke(object5)).booleanValue()) continue;
            object4.add(object5);
        }
        object = (List)object4;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10)), (int)16);
        object4 = new LinkedHashMap(n);
        object6 = object.iterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            object = (JavaRecordComponent)object5;
            object3 = object4;
            object3.put(object.getName(), object5);
        }
        classDeclaredMemberIndex2.components = object4;
    }

    @Override
    public Collection<JavaMethod> findMethodsByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        List<JavaMethod> list = this.methods.get(name);
        if (list != null) {
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public Set<Name> getMethodNames() {
        Object object = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getMethods()), this.methodFilter);
        Collection collection = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (JavaMethod)object2;
            Collection collection2 = collection;
            collection2.add(object2.getName());
        }
        return (Set)collection;
    }

    @Override
    public JavaField findFieldByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return this.fields.get(name);
    }

    @Override
    public Set<Name> getFieldNames() {
        Object object = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getFields()), this.memberFilter);
        Collection collection = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (JavaField)object2;
            Collection collection2 = collection;
            collection2.add(object2.getName());
        }
        return (Set)collection;
    }

    @Override
    public Set<Name> getRecordComponentNames() {
        return this.components.keySet();
    }

    @Override
    public JavaRecordComponent findRecordComponentByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return this.components.get(name);
    }

    private static final boolean methodFilter$lambda$0(ClassDeclaredMemberIndex classDeclaredMemberIndex, JavaMethod javaMethod) {
        Intrinsics.checkNotNullParameter((Object)javaMethod, (String)"");
        return (Boolean)classDeclaredMemberIndex.memberFilter.invoke((Object)javaMethod) != false && !JavaLoadingKt.isObjectMethodInInterface(javaMethod);
    }

    static /* synthetic */ boolean accessor$ClassDeclaredMemberIndex$lambda0(ClassDeclaredMemberIndex classDeclaredMemberIndex, JavaMethod javaMethod) {
        return ClassDeclaredMemberIndex.methodFilter$lambda$0(classDeclaredMemberIndex, javaMethod);
    }
}

