/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;

public final class NameResolverImpl
implements NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(ProtoBuf.StringTable stringTable, ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)qualifiedNameTable, (String)"");
        this.strings = stringTable;
        this.qualifiedNames = qualifiedNameTable;
    }

    @Override
    public final String getString(int n) {
        String string = this.strings.getString(n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public final String getQualifiedClassName(int n) {
        Object object = this.traverseIds(n);
        List list = (List)object.component1();
        object = (List)object.component2();
        object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        if (list.isEmpty()) {
            return object;
        }
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + object;
    }

    @Override
    public final boolean isLocalClassName(int n) {
        return (Boolean)this.traverseIds(n).getThird();
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        boolean bl = false;
        while (n != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(n);
            String string = this.strings.getString(qualifiedName.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = qualifiedName.getKind();
            Intrinsics.checkNotNull((Object)kind);
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    linkedList2.addFirst(string);
                    break;
                }
                case 2: {
                    linkedList.addFirst(string);
                    break;
                }
                case 3: {
                    linkedList2.addFirst(string);
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            n = qualifiedName.getParentQualifiedName();
        }
        return new Triple(linkedList, linkedList2, (Object)bl);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

