/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.UtfEncodingKt;

public class BitEncoding {
    private static final boolean FORCE_8TO7_ENCODING;

    private BitEncoding() {
    }

    private static void addModuloByte(byte[] byArray, int n) {
        if (byArray == null) {
            BitEncoding.$$$reportNull$$$0(4);
        }
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(byArray[i] + n & 0x7F);
        }
    }

    public static byte[] decodeBytes(String[] stringArray) {
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(7);
        }
        if (stringArray.length > 0 && !stringArray[0].isEmpty()) {
            char c = stringArray[0].charAt(0);
            if (c == '\u0000') {
                byte[] byArray = UtfEncodingKt.stringsToBytes(BitEncoding.dropMarker(stringArray));
                if (byArray == null) {
                    BitEncoding.$$$reportNull$$$0(8);
                }
                return byArray;
            }
            if (c == '\uffff') {
                stringArray = BitEncoding.dropMarker(stringArray);
            }
        }
        byte[] byArray = BitEncoding.combineStringArrayIntoBytes(stringArray);
        BitEncoding.addModuloByte(byArray, 127);
        return BitEncoding.decode7to8(byArray);
    }

    private static String[] dropMarker(String[] stringArray) {
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(9);
        }
        String[] stringArray2 = (String[])stringArray.clone();
        stringArray = stringArray2;
        stringArray2[0] = stringArray[0].substring(1);
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static byte[] combineStringArrayIntoBytes(String[] stringArray) {
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(11);
        }
        int n = 0;
        Object[] objectArray = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = objectArray[i];
            assert (string.length() <= 65535) : "String is too long: " + string.length();
            n += string.length();
        }
        objectArray = new byte[n];
        n2 = 0;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray2[i];
            int n4 = string.length();
            for (int j = 0; j < n4; ++j) {
                objectArray[n2++] = (String)((byte)string.charAt(j));
            }
        }
        return objectArray;
    }

    private static byte[] decode7to8(byte[] byArray) {
        if (byArray == null) {
            BitEncoding.$$$reportNull$$$0(13);
        }
        int n = 7 * byArray.length / 8;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = (byArray[n2] & 0xFF) >>> n3;
            int n5 = (byArray[++n2] & (1 << n3 + 1) - 1) << 7 - n3;
            byArray2[i] = (byte)(n4 + n5);
            if (n3 == 6) {
                ++n2;
                n3 = 0;
                continue;
            }
            ++n3;
        }
        return byArray2;
    }

    static {
        String string;
        try {
            string = System.getProperty("kotlin.jvm.serialization.use8to7");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        FORCE_8TO7_ENCODING = "true".equals(string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "encode8to7";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitBytesToStringArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeBytes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dropMarker";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "combineStringArrayIntoBytes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "decode7to8";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "encodeBytes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "encode8to7";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModuloByte";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitBytesToStringArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decodeBytes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dropMarker";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "combineStringArrayIntoBytes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "decode7to8";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

