/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDeserializer$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;

public final class ClassDeserializer {
    public static final Companion Companion = new Companion(null);
    private final DeserializationComponents components;
    private final Function1<ClassKey, ClassDescriptor> classes;
    private static final Set<ClassId> BLACK_LIST = SetsKt.setOf((Object)ClassId.Companion.topLevel(StandardNames.FqNames.cloneable.toSafe()));

    public ClassDeserializer(DeserializationComponents object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.components = object;
        object = this;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues(new ClassDeserializer$$Lambda$0((ClassDeserializer)object));
    }

    public final ClassDescriptor deserializeClass(ClassId classId, ClassData classData) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    private final ClassDescriptor createClass(ClassKey object) {
        DeserializationContext deserializationContext;
        Object object2;
        Object object3;
        Object object4 = ((ClassKey)object).getClassId();
        Object object5 = this.components.getFictitiousClassDescriptorFactories().iterator();
        while (object5.hasNext()) {
            object3 = object5.next();
            object2 = object3.createClass((ClassId)object4);
            if (object2 == null) continue;
            object5 = object2;
            return object5;
        }
        if (BLACK_LIST.contains(object4)) {
            return null;
        }
        ClassData classData = ((ClassKey)object).getClassData();
        if (classData == null && (classData = this.components.getClassDataFinder().findClassData((ClassId)object4)) == null) {
            return null;
        }
        object5 = classData;
        object3 = classData.component1();
        object2 = ((ClassData)object5).component2();
        object = ((ClassData)object5).component3();
        object5 = ((ClassData)object5).component4();
        Object object6 = ((ClassId)object4).getOuterClassId();
        if (object6 != null) {
            DeserializedClassDescriptor deserializedClassDescriptor = (object6 = ClassDeserializer.deserializeClass$default(this, (ClassId)object6, null, 2, null)) instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)object6 : null;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            object6 = deserializedClassDescriptor;
            if (!deserializedClassDescriptor.hasNestedClass$deserialization(((ClassId)object4).getShortClassName())) {
                return null;
            }
            deserializationContext = ((DeserializedClassDescriptor)object6).getC();
        } else {
            Object v3;
            block9: {
                object6 = PackageFragmentProviderKt.packageFragments(this.components.getPackageFragmentProvider(), ((ClassId)object4).getPackageFqName());
                object6 = (Iterable)object6;
                object6 = object6.iterator();
                while (object6.hasNext()) {
                    Object e = object6.next();
                    PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)e;
                    if (!(!(packageFragmentDescriptor instanceof DeserializedPackageFragment) || ((DeserializedPackageFragment)packageFragmentDescriptor).hasTopLevelClass(((ClassId)object4).getShortClassName()))) continue;
                    v3 = e;
                    break block9;
                }
                v3 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = v3;
            if (packageFragmentDescriptor == null) {
                return null;
            }
            object4 = packageFragmentDescriptor;
            ProtoBuf.TypeTable typeTable = ((ProtoBuf.Class)object2).getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"");
            TypeTable typeTable2 = new TypeTable(typeTable);
            ProtoBuf.VersionRequirementTable versionRequirementTable = ((ProtoBuf.Class)object2).getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue((Object)versionRequirementTable, (String)"");
            deserializationContext = this.components.createContext((PackageFragmentDescriptor)object4, (NameResolver)object3, typeTable2, VersionRequirementTable.Companion.create(versionRequirementTable), (BinaryVersion)object, null);
        }
        object4 = deserializationContext;
        return new DeserializedClassDescriptor((DeserializationContext)object4, (ProtoBuf.Class)object2, (NameResolver)object3, (BinaryVersion)object, (SourceElement)object5);
    }

    private static final ClassDescriptor classes$lambda$0(ClassDeserializer classDeserializer, ClassKey classKey) {
        Intrinsics.checkNotNullParameter((Object)classKey, (String)"");
        return classDeserializer.createClass(classKey);
    }

    static /* synthetic */ ClassDescriptor accessor$ClassDeserializer$lambda0(ClassDeserializer classDeserializer, ClassKey classKey) {
        return ClassDeserializer.classes$lambda$0(classDeserializer, classKey);
    }

    private static final class ClassKey {
        private final ClassId classId;
        private final ClassData classData;

        public ClassKey(ClassId classId, ClassData classData) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            this.classId = classId;
            this.classData = classData;
        }

        public final ClassId getClassId() {
            return this.classId;
        }

        public final ClassData getClassData() {
            return this.classData;
        }

        public final boolean equals(Object object) {
            return object instanceof ClassKey && Intrinsics.areEqual((Object)this.classId, (Object)((ClassKey)object).classId);
        }

        public final int hashCode() {
            return this.classId.hashCode();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

