/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.NotNullSimpleType;
import kotlin.reflect.jvm.internal.impl.types.NullableSimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;

final class SimpleTypeImpl
extends SimpleType {
    private final TypeConstructor constructor;
    private final List<TypeProjection> arguments;
    private final boolean isMarkedNullable;
    private final MemberScope memberScope;
    private final Function1<KotlinTypeRefiner, SimpleType> refinedTypeFactory;

    public SimpleTypeImpl(TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl, MemberScope memberScope, Function1<? super KotlinTypeRefiner, ? extends SimpleType> function1) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.constructor = typeConstructor2;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.memberScope = memberScope;
        this.refinedTypeFactory = function1;
        if (((KotlinType)this).getMemberScope() instanceof ErrorScope && !(((KotlinType)this).getMemberScope() instanceof ThrowingScope)) {
            throw new IllegalStateException("SimpleTypeImpl should not be created for error type: " + ((KotlinType)this).getMemberScope() + '\n' + ((KotlinType)this).getConstructor());
        }
    }

    @Override
    public final TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public final List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public final boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    public final MemberScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    public final TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public final SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        if (typeAttributes.isEmpty()) {
            return this;
        }
        return new SimpleTypeWithAttributes(this, typeAttributes);
    }

    @Override
    public final SimpleType makeNullableAsSpecified(boolean bl) {
        if (bl == ((KotlinType)this).isMarkedNullable()) {
            return this;
        }
        if (bl) {
            return new NullableSimpleType(this);
        }
        return new NotNullSimpleType(this);
    }

    @Override
    public final SimpleType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        SimpleType simpleType = (SimpleType)this.refinedTypeFactory.invoke((Object)kotlinTypeRefiner);
        if (simpleType == null) {
            simpleType = this;
        }
        return simpleType;
    }
}

