/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;

public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument object) {
        boolean bl = ((TypeArgument)object).isConsistent();
        if (_Assertions.ENABLED && !bl) {
            DescriptorRenderer descriptorRenderer = DescriptorRenderer.Companion.withOptions(CapturedTypeApproximationKt$$Lambda$0.INSTANCE);
            object = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer.render(((TypeArgument)object).getTypeParameter()) + ": <" + descriptorRenderer.renderType(((TypeArgument)object).getInProjection()) + ", " + descriptorRenderer.renderType(((TypeArgument)object).getOutProjection()) + ">] was found";
            throw new AssertionError(object);
        }
        if (Intrinsics.areEqual((Object)((TypeArgument)object).getInProjection(), (Object)((TypeArgument)object).getOutProjection()) || ((TypeArgument)object).getTypeParameter().getVariance() == Variance.IN_VARIANCE) {
            return new TypeProjectionImpl(((TypeArgument)object).getInProjection());
        }
        if (KotlinBuiltIns.isNothing(((TypeArgument)object).getInProjection()) && ((TypeArgument)object).getTypeParameter().getVariance() != Variance.IN_VARIANCE) {
            return new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object, Variance.OUT_VARIANCE), ((TypeArgument)object).getOutProjection());
        }
        if (KotlinBuiltIns.isNullableAny(((TypeArgument)object).getOutProjection())) {
            return new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object, Variance.IN_VARIANCE), ((TypeArgument)object).getInProjection());
        }
        return new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object, Variance.OUT_VARIANCE), ((TypeArgument)object).getOutProjection());
    }

    private static final TypeArgument toTypeArgument(TypeProjection typeProjection, TypeParameterDescriptor typeParameterDescriptor) {
        switch (WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameterDescriptor.getVariance(), typeProjection).ordinal()]) {
            case 1: {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                KotlinType kotlinType2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
                return new TypeArgument(typeParameterDescriptor, kotlinType, kotlinType2);
            }
            case 2: {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(typeParameterDescriptor).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                return new TypeArgument(typeParameterDescriptor, kotlinType, simpleType);
            }
            case 3: {
                TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
                SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(typeParameterDescriptor2).getNothingType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                KotlinType kotlinType = simpleType;
                KotlinType kotlinType3 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
                return new TypeArgument(typeParameterDescriptor2, kotlinType, kotlinType3);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final TypeProjection approximateCapturedTypesIfNecessary(TypeProjection object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object.isStarProjection()) {
            return object;
        }
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        if (!TypeUtils.contains(kotlinType, CapturedTypeApproximationKt$$Lambda$1.INSTANCE)) {
            return object;
        }
        Variance variance = object.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
        Variance variance2 = variance;
        if (variance == Variance.OUT_VARIANCE) {
            object = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType2);
            return new TypeProjectionImpl(variance2, (KotlinType)((ApproximationBounds)object).getUpper());
        }
        if (bl) {
            object = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType2).getLower();
            return new TypeProjectionImpl(variance2, (KotlinType)object);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections((TypeProjection)object);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            public final TypeProjection get(TypeConstructor typeConstructor2) {
                Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
                CapturedTypeConstructor capturedTypeConstructor = typeConstructor2 instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)typeConstructor2 : null;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                typeConstructor2 = capturedTypeConstructor;
                if (capturedTypeConstructor.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, typeConstructor2.getProjection().getType());
                }
                return typeConstructor2.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(KotlinType kotlinType) {
        KotlinType kotlinType2;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Object object32;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (FlexibleTypesKt.isFlexible(kotlinType)) {
            ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(kotlinType));
            ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(kotlinType));
            return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(approximationBounds.getLower()), FlexibleTypesKt.upperIfFlexible(approximationBounds2.getLower())), kotlinType), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(approximationBounds.getUpper()), FlexibleTypesKt.upperIfFlexible(approximationBounds2.getUpper())), kotlinType));
        }
        TypeConstructor typeConstructor2 = kotlinType.getConstructor();
        if (CapturedTypeConstructorKt.isCaptured(kotlinType)) {
            Intrinsics.checkNotNull((Object)typeConstructor2);
            TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor2).getProjection();
            KotlinType kotlinType3 = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
            KotlinType kotlinType4 = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(kotlinType3, kotlinType);
            switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getProjectionKind().ordinal()]) {
                case 2: {
                    return new ApproximationBounds<KotlinType>(kotlinType4, TypeUtilsKt.getBuiltIns(kotlinType).getNullableAnyType());
                }
                case 3: {
                    SimpleType simpleType = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                    return new ApproximationBounds<KotlinType>(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType, kotlinType), kotlinType4);
                }
            }
            throw new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection));
        }
        if (kotlinType.getArguments().isEmpty() || kotlinType.getArguments().size() != typeConstructor2.getParameters().size()) {
            KotlinType kotlinType5 = kotlinType;
            return new ApproximationBounds<KotlinType>(kotlinType5, kotlinType5);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterable iterable = kotlinType.getArguments();
        List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        for (Object object32 : CollectionsKt.zip((Iterable)iterable, (Iterable)list)) {
            object2 = (TypeProjection)object32.component1();
            object32 = (TypeParameterDescriptor)object32.component2();
            Intrinsics.checkNotNull((Object)object32);
            object = CapturedTypeApproximationKt.toTypeArgument((TypeProjection)object2, (TypeParameterDescriptor)object32);
            if (object2.isStarProjection()) {
                arrayList.add(object);
                arrayList2.add(object);
                continue;
            }
            object2 = CapturedTypeApproximationKt.approximateProjection(object);
            object32 = ((ApproximationBounds)object2).component1();
            object2 = ((ApproximationBounds)object2).component2();
            arrayList.add(object32);
            arrayList2.add(object2);
        }
        object32 = arrayList;
        if (!((Collection)object32).isEmpty()) {
            object32 = object32.iterator();
            while (object32.hasNext()) {
                object = object32.next();
                object2 = (TypeArgument)object;
                if (!(!((TypeArgument)object2).isConsistent())) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = bl = false;
        }
        if (bl) {
            SimpleType simpleType = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            kotlinType2 = simpleType;
        } else {
            kotlinType2 = CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, (List<TypeArgument>)arrayList);
        }
        return new ApproximationBounds<KotlinType>(kotlinType2, CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, (List<TypeArgument>)arrayList2));
    }

    private static final KotlinType replaceTypeArguments(KotlinType iterator2, List<TypeArgument> collection) {
        boolean bl;
        boolean bl2 = bl = ((KotlinType)((Object)iterator2)).getArguments().size() == collection.size();
        if (_Assertions.ENABLED && !bl) {
            iterator2 = "Incorrect type arguments " + collection;
            throw new AssertionError(iterator2);
        }
        Object object = collection;
        KotlinType kotlinType = iterator2;
        iterator2 = object;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            object = (TypeArgument)object;
            Collection<TypeArgument> collection2 = collection;
            collection2.add((TypeArgument)((Object)CapturedTypeApproximationKt.toTypeProjection((TypeArgument)object)));
        }
        return TypeSubstitutionKt.replace$default(kotlinType, collection, null, null, 6, null);
    }

    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        Object object = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType kotlinType = ((ApproximationBounds)object).component1();
        object = ((ApproximationBounds)object).component2();
        Object object2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        KotlinType kotlinType2 = ((ApproximationBounds)object2).component1();
        object2 = ((ApproximationBounds)object2).component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)object, kotlinType2), new TypeArgument(typeArgument.getTypeParameter(), kotlinType, (KotlinType)object2));
    }

    private static final Unit toTypeProjection$lambda$1$lambda$0(DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        descriptorRendererOptions.setClassifierNamePolicy(ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument typeArgument, Variance variance) {
        if (variance == typeArgument.getTypeParameter().getVariance()) {
            return Variance.INVARIANT;
        }
        return variance;
    }

    private static final Boolean approximateCapturedTypesIfNecessary$lambda$2(UnwrappedType unwrappedType) {
        Intrinsics.checkNotNull((Object)unwrappedType);
        return CapturedTypeConstructorKt.isCaptured(unwrappedType);
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType kotlinType, KotlinType kotlinType2) {
        KotlinType kotlinType3 = TypeUtils.makeNullableIfNeeded(kotlinType, kotlinType2.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
        return kotlinType3;
    }

    static /* synthetic */ Unit accessor$CapturedTypeApproximationKt$lambda0(DescriptorRendererOptions descriptorRendererOptions) {
        return CapturedTypeApproximationKt.toTypeProjection$lambda$1$lambda$0(descriptorRendererOptions);
    }

    static /* synthetic */ Boolean accessor$CapturedTypeApproximationKt$lambda1(UnwrappedType unwrappedType) {
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary$lambda$2(unwrappedType);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

