/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.ScreenUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TrayPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private final JDialog hiddenDialog;
    private volatile File iconFile;

    public TrayPopup(String string) {
        this.setFocusable(true);
        this.hiddenDialog = new JDialog(null, string);
        this.hiddenDialog.setUndecorated(true);
        this.hiddenDialog.setDefaultCloseOperation(2);
        this.hiddenDialog.setAlwaysOnTop(true);
        this.hiddenDialog.getContentPane().setLayout(null);
        this.hiddenDialog.setType(Window.Type.POPUP);
        this.hiddenDialog.pack();
        this.hiddenDialog.setBounds(0, 0, 0, 0);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                TrayPopup.this.hiddenDialog.setVisible(false);
                TrayPopup.this.hiddenDialog.toBack();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public void setTitleBarImage(File object) {
        if (this.iconFile == null || !this.iconFile.equals(object)) {
            this.iconFile = object;
            try {
                if (object != null) {
                    object = new ImageIcon(ImageIO.read((File)object)).getImage();
                    ((Image)object).flush();
                    this.hiddenDialog.setIconImage((Image)object);
                }
                return;
            }
            catch (IOException iOException) {
                SystemTray.logger.error("Error setting the title-bar image for the popup menu task tray dialog");
            }
        }
    }

    void close() {
        this.hiddenDialog.setVisible(false);
        this.hiddenDialog.dispatchEvent(new WindowEvent(this.hiddenDialog, 201));
    }

    public void doShow(Point point, int n) {
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = ScreenUtil.INSTANCE.getScreenBoundsAt(point);
        int n2 = point.x;
        int n3 = point.y;
        if (n3 < rectangle.y) {
            n3 = rectangle.y;
        } else if (n3 + dimension.height > rectangle.y + rectangle.height) {
            n3 -= dimension.height;
        }
        if (n2 < rectangle.x) {
            n2 = rectangle.x;
        } else if (n2 + dimension.width > rectangle.x + rectangle.width) {
            n2 -= dimension.width;
            n = -n;
        }
        TrayPopup trayPopup = this;
        trayPopup.setInvoker(trayPopup.hiddenDialog.getContentPane());
        this.hiddenDialog.setLocation(n2 -= n, n3);
        this.hiddenDialog.setVisible(true);
        this.setLocation(n2, n3);
        this.setVisible(true);
        this.requestFocusInWindow();
    }
}

