/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.gnomeShell.AppIndicatorExtension;
import dorkbox.systemTray.gnomeShell.DummyFile;
import dorkbox.systemTray.gnomeShell.LegacyExtension;
import dorkbox.systemTray.gnomeShell.TrayIconsReloadedIndicatorExtension;
import dorkbox.systemTray.ui.awt._AwtTray;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.ui.gtk._GtkStatusIconNativeTray;
import dorkbox.systemTray.ui.osx._OsxAwtTray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class AutoDetectTrayType {
    private static final Map<String, SystemTray> traySingletons = new HashMap<String, SystemTray>();

    public static Class<? extends Tray> selectType(SystemTray.TrayType trayType) {
        if (trayType == SystemTray.TrayType.Gtk) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.WindowsNative) {
            return _WindowsNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == SystemTray.TrayType.Osx) {
            return _OsxAwtTray.class;
        }
        if (trayType == SystemTray.TrayType.Awt) {
            return _AwtTray.class;
        }
        return null;
    }

    public static SystemTray.TrayType fromClass(Class<? extends Tray> clazz) {
        if (clazz == _GtkStatusIconNativeTray.class) {
            return SystemTray.TrayType.Gtk;
        }
        if (clazz == _AppIndicatorNativeTray.class) {
            return SystemTray.TrayType.AppIndicator;
        }
        if (clazz == _WindowsNativeTray.class) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (clazz == _SwingTray.class) {
            return SystemTray.TrayType.Swing;
        }
        if (clazz == _OsxAwtTray.class) {
            return SystemTray.TrayType.Osx;
        }
        if (clazz == _AwtTray.class) {
            return SystemTray.TrayType.Awt;
        }
        return null;
    }

    public static SystemTray.TrayType get(String object) {
        if (OS.INSTANCE.isWindows()) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (OS.INSTANCE.isMacOsX()) {
            return SystemTray.TrayType.Osx;
        }
        if (OS.INSTANCE.isLinux() || OS.INSTANCE.isUnix()) {
            block52: {
                Object object2 = OS.DesktopEnv.INSTANCE.getEnv();
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Currently using the '{}' desktop environment" + OS.INSTANCE.getLINE_SEPARATOR() + OS.Linux.INSTANCE.getInfo(), object2);
                }
                switch (object2) {
                    case Gnome: {
                        object2 = System.getenv("GDMSESSION");
                        if (object2 == null) {
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("GDMSESSION value is not set by OS. Checking '/etc/os-release' for more info.");
                            }
                            if (OS.Linux.INSTANCE.isPop()) {
                                object2 = "ubuntu";
                                if (SystemTray.DEBUG) {
                                    SystemTray.logger.debug("Detected popOS! Using 'ubuntu' for that configuration.");
                                }
                            }
                        }
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Currently using the '{}' session type", object2);
                        }
                        if ("gnome".equalsIgnoreCase((String)object2) || "default".equalsIgnoreCase((String)object2)) {
                            if (OS.Linux.INSTANCE.isUbuntu()) {
                                return SystemTray.TrayType.Gtk;
                            }
                            object2 = OS.DesktopEnv.INSTANCE.getGnomeVersion();
                            if (object2 == null) {
                                SystemTray.logger.error("GNOME shell detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                                return SystemTray.TrayType.Gtk;
                            }
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("Gnome Version: {}", object2);
                            }
                            int n = 0;
                            double d = 0.0;
                            String[] stringArray = object2.split("\\.", 2);
                            try {
                                n = Integer.parseInt(stringArray[0]);
                                d = Double.parseDouble(stringArray[1]);
                            }
                            catch (Exception exception) {}
                            if (n == 2) {
                                return SystemTray.TrayType.Gtk;
                            }
                            if (n == 3) {
                                if (d < 16.0) {
                                    SystemTray.logger.warn("SystemTray works, but will only show via SUPER+M.");
                                    return SystemTray.TrayType.Gtk;
                                }
                                if (d < 26.0) {
                                    Tray.gtkGnomeWorkaround = true;
                                    LegacyExtension.install((String)object);
                                    return SystemTray.TrayType.Gtk;
                                }
                                if (!AppIndicatorExtension.isInstalled()) {
                                    AppIndicatorExtension.install();
                                    SystemTray.logger.error("You must log out and then in again for system tray settings to apply.");
                                    return null;
                                }
                                return SystemTray.TrayType.AppIndicator;
                            }
                            if (n >= 40) {
                                if (AppIndicatorExtension.isInstalled()) {
                                    AppIndicatorExtension.unInstall();
                                }
                                if (!TrayIconsReloadedIndicatorExtension.isInstalled()) {
                                    TrayIconsReloadedIndicatorExtension.install();
                                }
                                return SystemTray.TrayType.Gtk;
                            }
                            SystemTray.logger.error("GNOME shell detected, but UNSUPPORTED shell version (" + (String)object2 + "). Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("cinnamon".equalsIgnoreCase((String)object2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("gnome-classic".equalsIgnoreCase((String)object2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("gnome-fallback".equalsIgnoreCase((String)object2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("awesome".equalsIgnoreCase((String)object2)) {
                            return SystemTray.TrayType.Gtk;
                        }
                        if ("ubuntu".equalsIgnoreCase((String)object2)) {
                            int[] nArray = OS.Linux.INSTANCE.getUbuntuVersion();
                            object2 = nArray;
                            if (nArray[0] == 17 && object2[1] == 10) {
                                Tray.gtkGnomeWorkaround = true;
                                LegacyExtension.install((String)object);
                            } else if (object2[0] >= 18) {
                                DummyFile.install();
                            }
                            return SystemTray.TrayType.AppIndicator;
                        }
                        SystemTray.logger.error("GNOME shell detected, but UNKNOWN type. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                        return SystemTray.TrayType.Gtk;
                    }
                    case KDE: {
                        object2 = OS.DesktopEnv.INSTANCE.getPlasmaVersionFull();
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("KDE Plasma Version: {}", object2);
                        }
                        if (object2 == null) {
                            SystemTray.logger.error("KDE Plasma detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return SystemTray.TrayType.Gtk;
                        }
                        object2 = object2.split("\\.");
                        int n = Integer.parseInt(object2[0]);
                        int n2 = Integer.parseInt((String)object2[1]);
                        if (n < 5 || n == 5 && n2 < 5) {
                            return SystemTray.TrayType.Gtk;
                        }
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case Unity: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case Unity7: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case XFCE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case LXDE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case MATE: {
                        return SystemTray.TrayType.Gtk;
                    }
                    case Pantheon: {
                        return SystemTray.TrayType.AppIndicator;
                    }
                    case ChromeOS: {
                        return null;
                    }
                }
                try {
                    object2 = new File("/proc");
                    File[] fileArray = object2.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            object = fileArray2[i];
                            object2 = ((File)object).getName();
                            if (!Character.isDigit(object2.charAt(0)) || !((File)(object = new File((File)object, "status"))).canRead() || (object = FileUtil.INSTANCE.readFirstLine((File)object)) == null || !((String)object).contains("indicator-app")) continue;
                            return SystemTray.TrayType.AppIndicator;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!SystemTray.DEBUG) break block52;
                    SystemTray.logger.error("Error detecting appindicator status", throwable);
                }
            }
            if (OS.INSTANCE.isLinux()) {
                if (OS.Linux.INSTANCE.isUbuntu()) {
                    return SystemTray.TrayType.AppIndicator;
                }
                if (OS.Linux.INSTANCE.isFedora()) {
                    return SystemTray.TrayType.Gtk;
                }
                return SystemTray.TrayType.AppIndicator;
            }
        }
        throw new RuntimeException("This OS is not supported. Please create an issue with the details from `SystemTray.DEBUG=true;`");
    }

    public static Runnable getShutdownHook(String string) {
        return () -> {
            Map<String, SystemTray> map = traySingletons;
            synchronized (map) {
                if (traySingletons.containsKey(string)) {
                    EventDispatch.runLater(() -> {
                        Map<String, SystemTray> map = traySingletons;
                        synchronized (map) {
                            string = traySingletons.remove(string);
                            if (string != null) {
                                ((SystemTray)((Object)string)).shutdown();
                            }
                            return;
                        }
                    });
                }
                return;
            }
        };
    }

    public static void setInstance(String string, SystemTray systemTray) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.put(string, systemTray);
            return;
        }
    }

    public static void removeSystemTrayHook(String string) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.remove(string);
            return;
        }
    }

    public static boolean hasOtherTrays() {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return !traySingletons.isEmpty();
        }
    }

    public static SystemTray getInstance(String string) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return traySingletons.get(string);
        }
    }
}

