/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.CacheUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class HeavyCheckMark {
    private static final double SVG_ORIG_SIZE_Y = 222.0;
    private static final double SVG_ORIG_SIZE_X = 226.0;
    private static final int VERSION = 1;
    private static final CacheUtil cache = new CacheUtil("SystemTrayCheckMarks_" + System.getProperty("user.name"));

    public static String get(Color transparency, int n, int n2) {
        Object object = n + "-" + n2 + "_checkMark_1" + "_" + transparency.getRGB() + ".png";
        if (n2 < n) {
            n2 = n;
        }
        if (((File)(object = cache.create((String)object))).canRead() || ((File)object).length() == 0L) {
            try {
                transparency = HeavyCheckMark.draw(transparency, n, n2);
                ImageIO.write((RenderedImage)((Object)transparency), "png", (File)object);
            }
            catch (Exception exception) {
                SystemTray.logger.error("Error creating check-mark image.", (Throwable)exception);
            }
        }
        return ((File)object).getAbsolutePath();
    }

    private static BufferedImage draw(Color color, int n, int n2) {
        int n3 = n2;
        BufferedImage bufferedImage = new BufferedImage(n3, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d = (double)n / 226.0;
        double d2 = (double)n / 222.0;
        n = (n2 - n) / 2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((double)n * 1.018018018018018, n);
        affineTransform.scale(d, d2);
        graphics2D.setTransform(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(70.98225, 156.26561);
        generalPath.quadTo(81.24785, 134.75002, 95.45094, 109.01561);
        generalPath.quadTo(109.654144, 83.28121, 127.58374, 57.68751);
        generalPath.quadTo(145.51344, 32.09381, 153.74004, 23.726612);
        generalPath.quadTo(161.96654, 15.359412, 167.66194, 10.437512);
        generalPath.quadTo(173.35724, 5.5156126, 187.84154, 3.2656126);
        generalPath.quadTo(202.32594, 1.0156126, 209.77914, 1.0156126);
        generalPath.quadTo(214.70094, 1.0156126, 217.86505, 4.0391126);
        generalPath.quadTo(221.02914, 7.0625124, 221.02914, 11.984413);
        generalPath.quadTo(221.02914, 15.781213, 219.20094, 18.523413);
        generalPath.quadTo(217.37285, 21.265614, 211.60724, 26.750011);
        generalPath.quadTo(183.90414, 52.20311, 153.95094, 99.312515);
        generalPath.quadTo(123.99784, 146.42192, 106.41974, 190.57812);
        generalPath.quadTo(98.12284, 210.82812, 95.73224, 214.34383);
        generalPath.quadTo(93.34154, 217.85942, 88.41974, 220.88283);
        generalPath.quadTo(83.49784, 223.90623, 68.16974, 223.90623);
        generalPath.quadTo(56.07594, 223.90623, 52.70094, 222.42973);
        generalPath.quadTo(49.32594, 220.95314, 47.49784, 219.26564);
        generalPath.quadTo(45.669743, 217.57814, 37.09154, 204.64064);
        generalPath.quadTo(28.232243, 191.00005, 11.357241, 172.43755);
        generalPath.quadTo(1.6541405, 161.75005, 1.6541405, 154.57814);
        generalPath.quadTo(1.6541405, 144.17194, 12.69314, 136.43755);
        generalPath.quadTo(23.732239, 128.70314, 32.16974, 128.70314);
        generalPath.quadTo(41.45094, 128.70314, 51.99784, 136.22664);
        generalPath.quadTo(62.54474, 143.75005, 70.98224, 156.26564);
        generalPath.closePath();
        generalPath.closePath();
        graphics2D.setPaint(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }
}

