/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import dorkbox.jna.windows.ShCore;
import dorkbox.jna.windows.User32;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;

public class SizeAndScalingWindows {
    public static final int SYSTEM_DPI = SizeAndScalingWindows.systemDPI();
    public static final double SYSTEM_SCALE = (double)SYSTEM_DPI / 96.0;
    public static final boolean SCALE_MENU_FOR_JAVA_8 = SystemTray.AUTO_FIX_INCONSISTENCIES && OS.INSTANCE.getJavaVersion() <= 8 && SYSTEM_SCALE != 1.0;
    public static volatile int OVERRIDE_MENU_SIZE = 0;
    public static volatile int OVERRIDE_TRAY_SIZE = 0;

    public static void setDpiAware() {
        if (SCALE_MENU_FOR_JAVA_8) {
            SystemTray.logger.warn("Java version " + OS.INSTANCE.getJavaVersion() + " is not DPI aware, scaling scaling at " + SYSTEM_SCALE + " will look very tiny so we are adjusting the UI accordingly. NOT ALL ELEMENTS CAN BE ADJUSTED!");
            return;
        }
        try {
            ShCore.SetProcessDpiAwareness((int)1);
        }
        catch (Throwable throwable) {}
        try {
            User32.User32.SetThreadDpiAwarenessContext(User32.DPI_AWARENESS_CONTEXT_SYSTEM_AWARE);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static double getDpiScaleForMouseClick(int n, int n2) {
        if (SCALE_MENU_FOR_JAVA_8) {
            return 1.0;
        }
        WinDef.POINT.ByValue byValue = new WinDef.POINT.ByValue(n, n2);
        byValue = User32.User32.MonitorFromPoint(byValue, 2);
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        ShCore.GetDpiForMonitor((WinUser.HMONITOR)byValue, (int)0, (IntByReference)intByReference, (IntByReference)intByReference2);
        return 96.0 / (double)intByReference.getValue();
    }

    public static int getMenuImageSize() {
        if (OVERRIDE_MENU_SIZE > 0) {
            return OVERRIDE_MENU_SIZE;
        }
        double d = SYSTEM_SCALE;
        if (SCALE_MENU_FOR_JAVA_8) {
            d = 1.0;
        }
        int n = (int)((double)User32.User32.GetSystemMetrics(72) / d);
        n -= n % 2;
        return n;
    }

    public static int getTrayImageSize(SystemTray.TrayType trayType) {
        if (OVERRIDE_TRAY_SIZE > 0) {
            return OVERRIDE_TRAY_SIZE;
        }
        int n = User32.User32.GetSystemMetrics(50);
        if (trayType == SystemTray.TrayType.Swing && SystemTray.AUTO_FIX_INCONSISTENCIES && SystemTray.AUTO_SIZE) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("When using the SystemTray on Windows as the SWING type, it will not properly scale to fit the menubar. Because AUTO_SIZE is enabled, the size will be adjusted based on the system scale");
            }
            return (int)((double)n / SYSTEM_SCALE);
        }
        return n;
    }

    private static int systemDPI() {
        try {
            return User32.User32.GetDpiForSystem();
        }
        catch (Throwable throwable) {
            return 96;
        }
    }
}

