/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Bias;
import dorkbox.collections.StateException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004\u0019\u001a\u001b\u001cB#\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldorkbox/collections/BinarySearch;", "T", "", "eval", "Ldorkbox/collections/BinarySearch$Evaluator;", "l", "", "(Ldorkbox/collections/BinarySearch$Evaluator;Ljava/util/List;)V", "indexed", "Ldorkbox/collections/BinarySearch$Indexed;", "(Ldorkbox/collections/BinarySearch$Evaluator;Ldorkbox/collections/BinarySearch$Indexed;)V", "checkSorted", "", "match", "prototype", "bias", "Ldorkbox/collections/Bias;", "(Ljava/lang/Object;Ldorkbox/collections/Bias;)Ljava/lang/Object;", "search", "", "value", "start", "end", "searchFor", "(JLdorkbox/collections/Bias;)Ljava/lang/Object;", "Companion", "Evaluator", "Indexed", "ListWrap", "Collections"})
public final class BinarySearch<T> {
    public static final Companion Companion = new Companion(null);
    private final Evaluator<T> eval;
    private final Indexed<T> indexed;
    public static final String version = "2.8";

    public BinarySearch(Evaluator<T> evaluator, Indexed<T> indexed) {
        Intrinsics.checkNotNullParameter(evaluator, (String)"");
        Intrinsics.checkNotNullParameter(indexed, (String)"");
        this.eval = evaluator;
        this.indexed = indexed;
        boolean bl = this.checkSorted();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public BinarySearch(Evaluator<T> evaluator, List<? extends T> list) {
        Intrinsics.checkNotNullParameter(evaluator, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this(evaluator, new ListWrap<T>(list));
    }

    private final boolean checkSorted() {
        long l = Long.MIN_VALUE;
        long l2 = this.indexed.size();
        for (long i = 0L; i < l2; ++i) {
            T t = this.indexed.get(i);
            long l3 = this.eval.getValue(t);
            if (l != Long.MIN_VALUE && l3 < l) {
                throw new StateException("Collection is not sorted at " + i + " - " + this.indexed);
            }
            l = l3;
        }
        return true;
    }

    public final long search(long l, Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"");
        return this.search(0L, this.indexed.size() - 1L, l, bias);
    }

    public final T match(T t, Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"");
        long l = this.eval.getValue(t);
        long l2 = this.search(l, bias);
        if (l2 == -1L) {
            return null;
        }
        return this.indexed.get(l2);
    }

    public final T searchFor(long l, Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"");
        long l2 = this.search(l, bias);
        if (l2 == -1L) {
            return null;
        }
        return this.indexed.get(l2);
    }

    private final long search(long l, long l2, long l3, Bias bias) {
        long l4;
        while ((l4 = l2 - l) != 0L) {
            long l5;
            if (l4 == 1L) {
                T t = this.indexed.get(l2);
                T t2 = this.indexed.get(l);
                l5 = this.eval.getValue(t2);
                long l6 = this.eval.getValue(t);
                switch (WhenMappings.$EnumSwitchMapping$0[bias.ordinal()]) {
                    case 1: {
                        return l;
                    }
                    case 2: {
                        return l2;
                    }
                    case 3: {
                        if (l5 == l3) {
                            return l;
                        }
                        if (l6 == l3) {
                            return l2;
                        }
                        if (Math.abs((double)(l5 - l3)) < Math.abs((double)(l6 - l3))) {
                            return l;
                        }
                        return l2;
                    }
                    case 4: {
                        if (l5 == l3) {
                            return l;
                        }
                        if (l6 == l3) {
                            return l2;
                        }
                        return -1L;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            long l7 = l + l4 / 2L;
            l5 = this.eval.getValue(this.indexed.get(l7));
            if (l3 >= l5) {
                return this.search(l7, l2, l3, bias);
            }
            l2 = l7;
        }
        return l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/BinarySearch$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldorkbox/collections/BinarySearch$Evaluator;", "T", "", "getValue", "", "obj", "(Ljava/lang/Object;)J", "Collections"})
    public static interface Evaluator<T> {
        public long getValue(T var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0016\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Ldorkbox/collections/BinarySearch$Indexed;", "T", "", "get", "index", "", "(J)Ljava/lang/Object;", "size", "Collections"})
    public static interface Indexed<T> {
        public T get(long var1);

        public long size();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldorkbox/collections/BinarySearch$ListWrap;", "T", "Ldorkbox/collections/BinarySearch$Indexed;", "l", "", "(Ljava/util/List;)V", "get", "index", "", "(J)Ljava/lang/Object;", "size", "toString", "", "Collections"})
    private static final class ListWrap<T>
    implements Indexed<T> {
        private final List<T> l;

        public ListWrap(List<? extends T> list) {
            Intrinsics.checkNotNullParameter(list, (String)"");
            this.l = list;
        }

        @Override
        public final T get(long l) {
            return this.l.get((int)l);
        }

        @Override
        public final long size() {
            return this.l.size();
        }

        public final String toString() {
            return super.toString() + '{' + this.l + '}';
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bias.values().length];
            try {
                nArray[Bias.BACKWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Bias.FORWARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Bias.NEAREST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Bias.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

