/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ConcurrentEntry;
import dorkbox.collections.IdentityMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\"B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0015\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J \u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u001aH\u0086\b\u00f8\u0001\u0000J1\u0010\u001b\u001a\u00020\u000e2#\u0010\u0019\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u001c\u00a2\u0006\u0002\b\u001dH\u0086\b\u00f8\u0001\u0000J\b\u0010\u001e\u001a\u00020\bH\u0016J\u0013\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u0006\u0010!\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"Ldorkbox/collections/ConcurrentIterator;", "T", "", "()V", "loadFactor", "", "(F)V", "ID", "", "entries", "Ldorkbox/collections/IdentityMap;", "Ldorkbox/collections/ConcurrentEntry;", "head", "add", "", "listener", "(Ljava/lang/Object;)V", "clear", "contains", "", "entry", "(Ljava/lang/Object;)Z", "equals", "other", "forEach", "action", "Lkotlin/Function1;", "forEachRemovable", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "hashCode", "remove", "concurrentEntry", "size", "Companion", "Collections"})
public final class ConcurrentIterator<T> {
    public static final Companion Companion = new Companion(null);
    private float loadFactor = 0.8f;
    private final int ID = ID_COUNTER.getAndIncrement();
    private final IdentityMap<T, ConcurrentEntry<T>> entries = new IdentityMap(32, this.loadFactor);
    private volatile ConcurrentEntry<T> head;
    public static final String version = "2.8";
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private static final AtomicReferenceFieldUpdater<ConcurrentIterator<?>, ConcurrentEntry<?>> headREF;

    public ConcurrentIterator() {
    }

    public ConcurrentIterator(float f) {
        this.loadFactor = f;
    }

    public final synchronized boolean contains(T t) {
        return ((Map)this.entries).containsKey(t);
    }

    public final synchronized void clear() {
        this.entries.clear();
        this.head = null;
    }

    public final void forEach(Function1<? super T, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        for (ConcurrentEntry<?> concurrentEntry = Companion.getHeadREF().get(this); concurrentEntry != null; concurrentEntry = concurrentEntry.next()) {
            Object obj = concurrentEntry.getValue();
            function1.invoke(obj);
        }
    }

    public final void forEachRemovable(Function2<? super ConcurrentEntry<T>, ? super T, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"");
        for (ConcurrentEntry<?> concurrentEntry = Companion.getHeadREF().get(this); concurrentEntry != null; concurrentEntry = concurrentEntry.next()) {
            Object obj = concurrentEntry.getValue();
            function2.invoke(concurrentEntry, obj);
        }
    }

    public final synchronized void add(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (!this.entries.containsKey(t)) {
            this.head = new ConcurrentEntry<T>(t, this.head);
            this.entries.put(t, this.head);
            ConcurrentIterator concurrentIterator = this;
            headREF.lazySet(concurrentIterator, concurrentIterator.head);
        }
    }

    public final synchronized boolean remove(T object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        object = (ConcurrentEntry)this.entries.get(object);
        if (object != null) {
            return this.remove((ConcurrentEntry<T>)object);
        }
        return false;
    }

    public final synchronized boolean remove(ConcurrentEntry<T> concurrentEntry) {
        Intrinsics.checkNotNullParameter(concurrentEntry, (String)"");
        if (Intrinsics.areEqual(concurrentEntry, this.head)) {
            ConcurrentEntry<T> concurrentEntry2 = this.head;
            Intrinsics.checkNotNull(concurrentEntry2);
            this.head = concurrentEntry2.next();
        } else {
            concurrentEntry.remove();
        }
        ConcurrentIterator concurrentIterator = this;
        headREF.lazySet(concurrentIterator, concurrentIterator.head);
        this.entries.remove(concurrentEntry.getValue());
        return true;
    }

    public final synchronized int size() {
        return this.entries.size();
    }

    public final int hashCode() {
        return this.ID;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), object.getClass())) {
            return false;
        }
        ConcurrentIterator cfr_ignored_0 = (ConcurrentIterator)object;
        return this.ID == ((ConcurrentIterator)object).ID;
    }

    static {
        AtomicReferenceFieldUpdater<ConcurrentIterator, ConcurrentEntry> atomicReferenceFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentIterator.class, ConcurrentEntry.class, "head");
        Intrinsics.checkNotNullExpressionValue(atomicReferenceFieldUpdater, (String)"");
        headREF = atomicReferenceFieldUpdater;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldorkbox/collections/ConcurrentIterator$Companion;", "", "()V", "ID_COUNTER", "Ljava/util/concurrent/atomic/AtomicInteger;", "headREF", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Ldorkbox/collections/ConcurrentIterator;", "Ldorkbox/collections/ConcurrentEntry;", "getHeadREF", "()Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final AtomicReferenceFieldUpdater<ConcurrentIterator<?>, ConcurrentEntry<?>> getHeadREF() {
            return headREF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

