/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u001e\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 \u0085\u0001*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\f\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u0007H\u0016J\u0015\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010^J\u0010\u0010_\u001a\u00020\r2\u0006\u0010`\u001a\u00020\u0004H\u0016J\u000e\u0010a\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0013\u0010c\u001a\u00020\r2\b\u0010d\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u001f\u0010e\u001a\u0004\u0018\u00018\u00002\b\u0010`\u001a\u0004\u0018\u00010\u00022\u0006\u0010f\u001a\u00020\r\u00a2\u0006\u0002\u0010gJ\u0018\u0010h\u001a\u0004\u0018\u00010\u00042\u0006\u0010]\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010iJ\"\u0010h\u001a\u0004\u0018\u00010\u00042\u0006\u0010]\u001a\u00028\u00002\b\u0010j\u001a\u0004\u0018\u00010\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010kJ#\u0010l\u001a\u00020\u00042\u0006\u0010]\u001a\u00028\u00002\u0006\u0010j\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u0004\u00a2\u0006\u0002\u0010nJ\b\u0010o\u001a\u00020\u0007H\u0016J\b\u0010p\u001a\u00020\rH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0016J\u0010\u0010q\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\u0002H\u0016J\u0006\u0010r\u001a\u00020\rJ\u0010\u0010s\u001a\u00020\u00072\u0006\u0010t\u001a\u00020\u0002H\u0014J\u001f\u0010u\u001a\u0004\u0018\u00010\u00042\u0006\u0010]\u001a\u00028\u00002\u0006\u0010`\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010vJ#\u0010u\u001a\u00020\u00042\u0006\u0010]\u001a\u00028\u00002\u0006\u0010`\u001a\u00020\u00042\u0006\u0010j\u001a\u00020\u0004\u00a2\u0006\u0002\u0010nJ\u0018\u0010w\u001a\u00020Z2\u000e\u0010x\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010w\u001a\u00020Z2\u0014\u0010x\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040yH\u0016J\u001d\u0010z\u001a\u00020Z2\u0006\u0010]\u001a\u00028\u00002\u0006\u0010`\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010{J\u0017\u0010|\u001a\u0004\u0018\u00010\u00042\u0006\u0010]\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010iJ\u001b\u0010|\u001a\u00020\u00042\u0006\u0010]\u001a\u00028\u00002\u0006\u0010j\u001a\u00020\u0004\u00a2\u0006\u0002\u0010}J\u000e\u0010~\u001a\u00020Z2\u0006\u0010\u007f\u001a\u00020\u0007J\u0011\u0010\u0080\u0001\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u0007H\u0016J\n\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\u0012\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0082\u0001J\u001d\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0084\u0001\u001a\u00020\rH\u0014J\b\u0010L\u001a\u00020QH\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR$\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000!X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\"\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00108\"\u0004\b=\u0010:R\u001a\u0010>\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00108\"\u0004\b@\u0010:R\u0014\u0010A\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u00108R\u001a\u0010C\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00108\"\u0004\bE\u0010:R\u001a\u0010F\u001a\u00020GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040M8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001c\u0010V\u001a\u0004\u0018\u00010QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010S\"\u0004\bX\u0010U\u00a8\u0006\u008b\u0001"}, d2={"Ldorkbox/collections/ObjectFloatMap;", "K", "", "", "", "()V", "initialCapacity", "", "loadFactor", "(IF)V", "map", "(Ldorkbox/collections/ObjectFloatMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ObjectFloatMap$Entries;", "getEntries1", "()Ldorkbox/collections/ObjectFloatMap$Entries;", "setEntries1", "(Ldorkbox/collections/ObjectFloatMap$Entries;)V", "entries2", "getEntries2", "setEntries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ObjectFloatMap$Keys;", "getKeys1", "()Ldorkbox/collections/ObjectFloatMap$Keys;", "setKeys1", "(Ldorkbox/collections/ObjectFloatMap$Keys;)V", "keys2", "getKeys2", "setKeys2", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mapSize", "getMapSize", "()I", "setMapSize", "(I)V", "mask", "getMask", "setMask", "shift", "getShift", "setShift", "size", "getSize", "threshold", "getThreshold", "setThreshold", "valueTable", "", "getValueTable", "()[F", "setValueTable", "([F)V", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ObjectFloatMap$Values;", "getValues1", "()Ldorkbox/collections/ObjectFloatMap$Values;", "setValues1", "(Ldorkbox/collections/ObjectFloatMap$Values;)V", "values2", "getValues2", "setValues2", "clear", "", "maximumCapacity", "containsKey", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "ensureCapacity", "additionalCapacity", "equals", "other", "findKey", "identity", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Float;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Float;)Ljava/lang/Float;", "getAndIncrement", "increment", "(Ljava/lang/Object;FF)F", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "(Ljava/lang/Object;F)Ljava/lang/Float;", "putAll", "from", "", "putResize", "(Ljava/lang/Object;F)V", "remove", "(Ljava/lang/Object;F)F", "resize", "newSize", "shrink", "toString", "", "separator", "braces", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public class ObjectFloatMap<K>
implements Map<K, Float>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int mapSize;
    private K[] keyTable;
    private float[] valueTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries<K> entries1;
    private transient Entries<K> entries2;
    private transient Values values1;
    private transient Values values2;
    private transient Keys<K> keys1;
    private transient Keys<K> keys2;
    public static final String version = "2.8";
    private static final Object dummy = new Object();

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    protected final int getMapSize() {
        return this.mapSize;
    }

    protected final void setMapSize(int n) {
        this.mapSize = n;
    }

    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"");
        this.keyTable = KArray;
    }

    public final float[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this.valueTable = fArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public final Entries<K> getEntries1() {
        return this.entries1;
    }

    public final void setEntries1(Entries<K> entries) {
        this.entries1 = entries;
    }

    public final Entries<K> getEntries2() {
        return this.entries2;
    }

    public final void setEntries2(Entries<K> entries) {
        this.entries2 = entries;
    }

    public final Values getValues1() {
        return this.values1;
    }

    public final void setValues1(Values values) {
        this.values1 = values;
    }

    public final Values getValues2() {
        return this.values2;
    }

    public final void setValues2(Values values) {
        this.values2 = values;
    }

    public final Keys<K> getKeys1() {
        return this.keys1;
    }

    public final void setKeys1(Keys<K> keys) {
        this.keys1 = keys;
    }

    public final Keys<K> getKeys2() {
        return this.keys2;
    }

    public final void setKeys2(Keys<K> keys) {
        this.keys2 = keys;
    }

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        n = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n * f);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n];
        this.valueTable = new float[n];
    }

    public /* synthetic */ ObjectFloatMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectFloatMap(ObjectFloatMap<? extends K> objectFloatMap) {
        Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
        this((int)((float)objectFloatMap.keyTable.length * objectFloatMap.loadFactor), objectFloatMap.loadFactor);
        System.arraycopy(objectFloatMap.keyTable, 0, this.keyTable, 0, objectFloatMap.keyTable.length);
        System.arraycopy(objectFloatMap.valueTable, 0, this.valueTable, 0, objectFloatMap.valueTable.length);
        this.mapSize = objectFloatMap.mapSize;
    }

    public int getSize() {
        return this.mapSize;
    }

    protected int place(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        return (int)((long)object.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public int locateKey(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        K[] KArray = this.keyTable;
        int n = this.place(object);
        while (KArray[n] != null) {
            K k;
            if (Intrinsics.areEqual(k, (Object)object)) {
                return n;
            }
            n = n + 1 & this.mask;
        }
        return -(n + 1);
    }

    @Override
    public Float put(K k, float f) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n >= 0) {
            float f2 = this.valueTable[n];
            this.valueTable[n] = f;
            return Float.valueOf(f2);
        }
        n = -(n + 1);
        this.keyTable[n] = k;
        this.valueTable[n] = f;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
        return null;
    }

    public final float put(K k, float f, float f2) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n >= 0) {
            float f3 = this.valueTable[n];
            this.valueTable[n] = f;
            return f3;
        }
        n = -(n + 1);
        this.keyTable[n] = k;
        this.valueTable[n] = f;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
        return f2;
    }

    public void putAll(ObjectFloatMap<? extends K> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        this.ensureCapacity(((ObjectFloatMap)object).mapSize);
        K[] KArray = ((ObjectFloatMap)object).keyTable;
        object = ((ObjectFloatMap)object).valueTable;
        int n = KArray.length;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            this.put(k, (float)object[i]);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends Float> object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.ensureCapacity(object.size());
        for (Map.Entry entry : object.entrySet()) {
            Map.Entry entry2 = entry;
            entry2 = entry;
            Object k = entry.getKey();
            float f = ((Number)entry2.getValue()).floatValue();
            this.put(k, f);
        }
    }

    private final void putResize(K k, float f) {
        K[] KArray = this.keyTable;
        int n = this.place(k);
        while (true) {
            if (KArray[n] == null) {
                KArray[n] = k;
                this.valueTable[n] = f;
                return;
            }
            n = n + 1 & this.mask;
        }
    }

    @Override
    public Float get(K k) {
        if (k == null) {
            return null;
        }
        int n = this.locateKey(k);
        if (n < 0) {
            return null;
        }
        return Float.valueOf(this.valueTable[n]);
    }

    public final Float get(K k, Float f) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n < 0) {
            return f;
        }
        return Float.valueOf(this.valueTable[n]);
    }

    public final float getAndIncrement(K k, float f, float f2) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n >= 0) {
            float f3 = this.valueTable[n];
            float[] fArray = this.valueTable;
            this.valueTable[n] = fArray[n] + f2;
            return f3;
        }
        n = -(n + 1);
        this.keyTable[n] = k;
        this.valueTable[n] = f + f2;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
        return f;
    }

    @Override
    public Float remove(K k) {
        if (k == null) {
            return null;
        }
        int n = this.locateKey(k);
        if (n < 0) {
            return null;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        float f = this.valueTable[n];
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        while (true) {
            K k2;
            K k3 = k2 = KArray[n3];
            k3 = k2;
            if (k2 == null) break;
            K k4 = k3;
            Intrinsics.checkNotNull(k4);
            int n4 = this.place(k4);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                KArray[n] = k3;
                fArray[n] = fArray[n3];
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        KArray[n] = null;
        fArray[n] = 0.0f;
        int n5 = this.mapSize;
        this.mapSize = n5 + -1;
        return Float.valueOf(f);
    }

    public final float remove(K k, float f) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        int n = this.locateKey(k);
        if (n < 0) {
            return f;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        float f2 = this.valueTable[n];
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        while (true) {
            K k2;
            K k3 = k2 = KArray[n3];
            k3 = k2;
            if (k2 == null) break;
            K k4 = k3;
            Intrinsics.checkNotNull(k4);
            int n4 = this.place(k4);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                KArray[n] = k3;
                fArray[n] = fArray[n3];
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        KArray[n] = null;
        fArray[n] = 0.0f;
        int n5 = this.mapSize;
        this.mapSize = n5 + -1;
        return f2;
    }

    public final boolean notEmpty() {
        return this.mapSize > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.mapSize == 0;
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        if (this.keyTable.length > (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.resize(n);
        }
    }

    public void clear(int n) {
        if (this.keyTable.length <= (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.clear();
            return;
        }
        this.mapSize = 0;
        this.resize(n);
    }

    @Override
    public void clear() {
        if (this.mapSize == 0) {
            return;
        }
        this.mapSize = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, 0.0f);
    }

    public boolean containsValue(float f) {
        float[] fArray = this.valueTable;
        if (f == 0.0f) {
            K[] KArray = this.keyTable;
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n2;
                    if (KArray[n2 = n--] == null || !(fArray[n2] == 0.0f)) continue;
                    return true;
                } while (n >= 0);
            }
        } else {
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n3;
                    if (!(fArray[n3 = n--] == f)) continue;
                    return true;
                } while (n >= 0);
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        return this.locateKey(object) >= 0;
    }

    public final K findKey(Object object, boolean n) {
        float[] fArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n2 = fArray.length + -1;
            if (n2 >= 0) {
                do {
                    int n3;
                    if (KArray[n3 = n2--] == null || !(fArray[n3] == 0.0f)) continue;
                    return KArray[n3];
                } while (n2 >= 0);
            }
        } else if (n != 0) {
            n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n4;
                    if (!Intrinsics.areEqual((Object)Float.valueOf(fArray[n4 = n--]), (Object)object)) continue;
                    return this.keyTable[n4];
                } while (n >= 0);
            }
        } else {
            n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n5;
                    if (!Intrinsics.areEqual((Object)object, (Object)Float.valueOf(fArray[n5 = n--]))) continue;
                    return this.keyTable[n5];
                } while (n >= 0);
            }
        }
        return null;
    }

    public final void ensureCapacity(int n) {
        if (this.keyTable.length < (n = ObjectSet.Companion.tableSize(this.mapSize + n, this.loadFactor))) {
            this.resize(n);
        }
    }

    public final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new Object[n];
        this.valueTable = new float[n];
        if (this.mapSize > 0) {
            for (n = 0; n < n2; ++n) {
                K k = KArray[n];
                if (k == null) continue;
                this.putResize(k, fArray[n]);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.mapSize;
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = KArray.length;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            n += k.hashCode();
            float f = fArray[i];
            if (f == 0.0f) continue;
            n += Float.hashCode(f);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap cfr_ignored_0 = (ObjectFloatMap)object;
        if (((ObjectFloatMap)object).size() != this.mapSize) {
            return false;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = KArray.length;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            Float f = ((ObjectFloatMap)object).get(k, Float.valueOf(0.0f));
            if (Intrinsics.areEqual((Float)f, (float)0.0f) && !((ObjectFloatMap)object).containsKey(k)) {
                return false;
            }
            if (Intrinsics.areEqual((Float)f, (float)fArray[i])) continue;
            return false;
        }
        return true;
    }

    public final String toString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String string, boolean bl) {
        K k;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (this.mapSize == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            K k2 = KArray[n];
            if (k2 == null) continue;
            k = k2;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n]);
            break;
        }
        while (n-- > 0) {
            if (KArray[n] == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n]);
        }
        if (bl) {
            stringBuilder.append('}');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public Set<Map.Entry<K, Float>> getEntries() {
        Entries<K> entries = this.entries();
        Intrinsics.checkNotNull(entries);
        return TypeIntrinsics.asMutableSet(entries);
    }

    public Entries<K> entries() {
        if (this.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<K> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<K> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<K> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<K> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        Entries<K> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<K> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<K> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<K> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    public Collection<Float> getValues() {
        return this.values();
    }

    public Values values() {
        if (this.allocateIterators) {
            return new Values((ObjectFloatMap<?>)this);
        }
        if (this.values1 == null) {
            this.values1 = new Values((ObjectFloatMap<?>)this);
            this.values2 = new Values((ObjectFloatMap<?>)this);
        }
        Values values = this.values1;
        Intrinsics.checkNotNull((Object)values);
        if (!values.getValid()) {
            Values values2 = this.values1;
            Intrinsics.checkNotNull((Object)values2);
            values2.reset();
            Values values3 = this.values1;
            Intrinsics.checkNotNull((Object)values3);
            values3.setValid(true);
            Values values4 = this.values2;
            Intrinsics.checkNotNull((Object)values4);
            values4.setValid(false);
            Values values5 = this.values1;
            Intrinsics.checkNotNull((Object)values5);
            return values5;
        }
        Values values6 = this.values2;
        Intrinsics.checkNotNull((Object)values6);
        values6.reset();
        Values values7 = this.values2;
        Intrinsics.checkNotNull((Object)values7);
        values7.setValid(true);
        Values values8 = this.values1;
        Intrinsics.checkNotNull((Object)values8);
        values8.setValid(false);
        Values values9 = this.values2;
        Intrinsics.checkNotNull((Object)values9);
        return values9;
    }

    public Set<K> getKeys() {
        return this.keys();
    }

    public Keys<K> keys() {
        if (this.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.reset();
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.reset();
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        return this.put(object, ((Number)object2).floatValue());
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (!(object2 instanceof Float)) {
            return false;
        }
        return (int)this.remove(object, ((Number)object2).floatValue()) != 0;
    }

    @Override
    public final boolean containsValue(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        return this.containsValue(((Number)object).floatValue());
    }

    @Override
    public final Set<Map.Entry<K, Float>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Collection<Float> values() {
        return this.getValues();
    }

    @Override
    public final Set<K> keySet() {
        return this.getKeys();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/collections/ObjectFloatMap$Companion;", "", "()V", "dummy", "getDummy$Collections", "()Ljava/lang/Object;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final Object getDummy$Collections() {
            return dummy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0005B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001c\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0017\u0010\u001a\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002J\u001c\u0010\u001b\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\t\u0010\u001c\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002J\u0016\u0010 \u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001c\u0010!\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\u001c\u0010\"\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Ldorkbox/collections/ObjectFloatMap$Entries;", "K", "", "", "Ldorkbox/collections/ObjectFloatMap$Entry;", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "entry", "getEntry", "()Ldorkbox/collections/ObjectFloatMap$Entry;", "setEntry", "(Ldorkbox/collections/ObjectFloatMap$Entry;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static class Entries<K>
    extends MapIterator<K, Integer, Entry<K>>
    implements Set<Entry<K>>,
    KMutableSet {
        private Entry<K> entry;

        public Entries(ObjectFloatMap<K> objectFloatMap) {
            Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
            super(objectFloatMap);
            this.entry = new Entry<K>(objectFloatMap);
        }

        public final Entry<K> getEntry() {
            return this.entry;
        }

        public final void setEntry(Entry<K> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.entry = entry;
        }

        @Override
        public Entry<K> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.getMap().getKeyTable();
            Object k = KArray[this.getNextIndex()];
            Intrinsics.checkNotNull(k);
            this.entry.setKey(k);
            this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            Entries entries = this;
            entries.setCurrentIndex(entries.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(Entry<K> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue().floatValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Entry<K>> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                this.getMap().put(((Entry)object2).getKey(), ((Entry)object2).getValue().floatValue());
                bl = true;
            }
            return bl;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                Object k = ((Map.Entry)object2).getKey();
                float f = ((Number)((Map.Entry)object2).getValue()).floatValue();
                if (Intrinsics.areEqual((Float)((Float)this.getMap().get(k)), (float)f)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Entry<K> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            return Intrinsics.areEqual((Float)((Float)this.getMap().get((Object)entry.getKey())), (float)entry.getValue().floatValue());
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (Object k : this.getMap().getKeyTable()) {
                boolean bl2;
                Object v1;
                Object k2;
                block2: {
                    k2 = k;
                    k2 = k;
                    if (k == null) continue;
                    Object object = collection;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Entry entry = (Entry)e;
                        if (!Intrinsics.areEqual(entry.getKey(), k2)) continue;
                        v1 = e;
                        break block2;
                    }
                    v1 = null;
                }
                if (bl2 = v1 != null) continue;
                bl = this.getMap().remove(k2) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                object2 = ((Map.Entry)object2).getKey();
                bl = this.getMap().remove(object2) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Entry<K> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            boolean bl = this.getMap().remove((Object)this.entry.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010'\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\b\u001a\u00028\u0001X\u0096.\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Ldorkbox/collections/ObjectFloatMap$Entry;", "K", "", "", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "key", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ObjectFloatMap;", "value", "getValue", "()Ljava/lang/Float;", "setValue", "(F)V", "newValue", "(F)Ljava/lang/Float;", "toString", "", "Collections"})
    public static final class Entry<K>
    implements Map.Entry<K, Float>,
    KMutableMap.Entry {
        private final ObjectFloatMap<K> map;
        public K key;
        private float value;

        public Entry(ObjectFloatMap<K> objectFloatMap) {
            Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
            this.map = objectFloatMap;
        }

        public final ObjectFloatMap<K> getMap() {
            return this.map;
        }

        @Override
        public final K getKey() {
            K k = this.key;
            if (k != null) {
                return k;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            return (K)Unit.INSTANCE;
        }

        public final void setKey(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            this.key = k;
        }

        @Override
        public final Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public final void setValue(float f) {
            this.value = f;
        }

        @Override
        public final Float setValue(float f) {
            float f2 = this.getValue().floatValue();
            Float f3 = Float.valueOf(f);
            ((Map)this.map).put(this.getKey(), f3);
            this.setValue(f);
            return Float.valueOf(f2);
        }

        public final String toString() {
            return "" + this.getKey() + '=' + this.getValue().floatValue();
        }

        @Override
        public final /* synthetic */ Object setValue(Object object) {
            return this.setValue(((Number)object).floatValue());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016\u00a2\u0006\u0002\u0010!J)\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \"\b\b\u0002\u0010\"*\u00028\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectFloatMap$Keys;", "K", "", "", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    public static class Keys<K>
    extends MapIterator<K, Object, K>
    implements Set<K>,
    KMutableSet {
        public Keys(ObjectFloatMap<K> objectFloatMap) {
            Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public K next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.getMap().getKeyTable()[this.getNextIndex()];
            Keys keys = this;
            keys.setCurrentIndex(keys.getNextIndex());
            this.findNextIndex();
            Object k2 = k;
            Intrinsics.checkNotNull(k2);
            return k2;
        }

        @Override
        public boolean add(K k) {
            Intrinsics.checkNotNullParameter(k, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.getMap().containsKey(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            return this.getMap().containsKey(object);
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (Object k : this.getMap().getKeyTable()) {
                Object k2 = k;
                k2 = k;
                if (k == null || collection.contains(k2)) continue;
                this.getMap().remove(k2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.getMap().remove(e) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            boolean bl = this.getMap().remove(object) == null;
            this.reset();
            return bl;
        }

        @Override
        public K[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public final <T extends K> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                int n2 = n++;
                K k = this.next();
                Intrinsics.checkNotNull(k);
                TArray[n2] = k;
            }
            return TArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00040\u00052\b\u0012\u0004\u0012\u0002H\u00040\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015\u00a8\u0006\""}, d2={"Ldorkbox/collections/ObjectFloatMap$MapIterator;", "K", "", "V", "I", "", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/ObjectFloatMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Collections"})
    public static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        private final ObjectFloatMap<K> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public MapIterator(ObjectFloatMap<K> objectFloatMap) {
            Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
            this.map = objectFloatMap;
            this.valid = true;
            this.reset();
        }

        public final ObjectFloatMap<K> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                K[] KArray = this.map.getKeyTable();
                int n = KArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int n = this.currentIndex;
            if (!(n >= 0)) {
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            K[] KArray = this.map.getKeyTable();
            float[] fArray = this.map.getValueTable();
            int n2 = this.map.getMask();
            int n3 = n + 1 & n2;
            while (true) {
                object = KArray[n3];
                K k = object;
                k = object;
                if (object == null) break;
                K k2 = k;
                Intrinsics.checkNotNull(k2);
                int n4 = this.map.place(k2);
                if ((n3 - n4 & n2) > (n - n4 & n2)) {
                    KArray[n] = k;
                    fArray[n] = fArray[n3];
                    n = n3;
                }
                n3 = n3 + 1 & n2;
            }
            KArray[n] = null;
            fArray[n] = 0.0f;
            object = this.map;
            int n5 = ((ObjectFloatMap)object).getMapSize();
            ((ObjectFloatMap)object).setMapSize(n5 + -1);
            if (n != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\t\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Ldorkbox/collections/ObjectFloatMap$Values;", "", "", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Float;", "remove", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    public static class Values
    extends MapIterator<Object, Float, Float>
    implements Collection<Float>,
    KMutableCollection {
        public Values(ObjectFloatMap<?> objectFloatMap) {
            Intrinsics.checkNotNullParameter(objectFloatMap, (String)"");
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public Float next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            float f = this.getMap().getValueTable()[this.getNextIndex()];
            Values values = this;
            values.setCurrentIndex(values.getNextIndex());
            this.findNextIndex();
            return Float.valueOf(f);
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(Collection<? extends Float> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(float f) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                float f = ((Number)e).floatValue();
                if (this.getMap().containsValue(Float.valueOf(f))) continue;
                return false;
            }
            return true;
        }

        public boolean contains(float f) {
            return this.getMap().containsValue(Float.valueOf(f));
        }

        public Values iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (Object k : this.getMap().getKeyTable()) {
                Float f;
                Object k2 = k;
                k2 = k;
                if (k == null || CollectionsKt.contains((Iterable)collection, (Object)(f = (Float)this.getMap().get(k2)))) continue;
                this.getMap().remove(k2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                float f = ((Number)object2).floatValue();
                object2 = this.getMap().findKey(Float.valueOf(f), false);
                if (object2 == null) continue;
                bl = this.getMap().remove(object2) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(float f) {
            boolean bl = false;
            Object k = this.getMap().findKey(Float.valueOf(f), false);
            if (k != null) {
                bl = this.getMap().remove(k) != null;
            }
            this.reset();
            return bl;
        }

        public float[] toArray() {
            float[] fArray = new float[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                fArray[n++] = this.next().floatValue();
            }
            return fArray;
        }

        public final float[] toArray(float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                fArray[n++] = this.next().floatValue();
            }
            return fArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).floatValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Float)) {
                return false;
            }
            return this.contains(((Number)object).floatValue());
        }

        @Override
        public final boolean remove(Object object) {
            if (!(object instanceof Float)) {
                return false;
            }
            return this.remove(((Number)object).floatValue());
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

