/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Case;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "blobType", "booleanToStatementString", "bool", "", "booleanType", "dateTimeType", "hexToDb", "hexString", "integerAutoincType", "jsonType", "largeTextType", "longAutoincType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "textType", "timestampWithTimeZoneType", "ubyteType", "ulongAutoincType", "uuidToDB", "", "value", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public final class SQLServerDataTypeProvider
extends DataTypeProvider {
    public static final SQLServerDataTypeProvider INSTANCE = new SQLServerDataTypeProvider();

    private SQLServerDataTypeProvider() {
    }

    @Override
    public final String ubyteType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.SQLServer) {
            return "SMALLINT";
        }
        return "TINYINT";
    }

    @Override
    public final String integerAutoincType() {
        return "INT IDENTITY(1,1)";
    }

    @Override
    public final String longAutoincType() {
        return "BIGINT IDENTITY(1,1)";
    }

    @Override
    public final String ulongAutoincType() {
        return "NUMERIC(20) IDENTITY(1,1)";
    }

    @Override
    public final String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    public final String blobType() {
        return "VARBINARY(MAX)";
    }

    @Override
    public final String uuidType() {
        return "uniqueidentifier";
    }

    @Override
    public final Object uuidToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        String string = uUID.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public final String dateTimeType() {
        return "DATETIME2";
    }

    @Override
    public final String timestampWithTimeZoneType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.SQLServer) {
            return "TIMESTAMP(9) WITH TIME ZONE";
        }
        return "DATETIMEOFFSET";
    }

    @Override
    public final String booleanType() {
        return "BIT";
    }

    @Override
    public final String booleanToStatementString(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }

    @Override
    public final String textType() {
        return "VARCHAR(MAX)";
    }

    @Override
    public final String mediumTextType() {
        return ((DataTypeProvider)this).textType();
    }

    @Override
    public final String largeTextType() {
        return ((DataTypeProvider)this).textType();
    }

    @Override
    public final String jsonType() {
        return "NVARCHAR(MAX)";
    }

    @Override
    public final void precessOrderByClause(QueryBuilder queryBuilder, Expression<?> expression, SortOrder object) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, (SortOrder)((Object)object));
                return;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                return;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                return;
            }
        }
        if (object == SortOrder.ASC_NULLS_LAST) {
            object = SqlExpressionBuilder.INSTANCE;
            pair = TuplesKt.to((Object)new Case(null, 1, null).When(((SqlExpressionBuilder)object).isNull(expression), OpKt.intLiteral(1)).Else(OpKt.intLiteral(0)), (Object)((Object)SortOrder.ASC));
        } else {
            object = SqlExpressionBuilder.INSTANCE;
            pair = TuplesKt.to((Object)new Case(null, 1, null).When(((SqlExpressionBuilder)object).isNull(expression), OpKt.intLiteral(0)).Else(OpKt.intLiteral(1)), (Object)((Object)SortOrder.DESC));
        }
        object = pair;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object.getFirst();
        objectArray2[1] = ", ";
        ExpressionKt.append(queryBuilder, objectArray2);
        super.precessOrderByClause(queryBuilder, expression, (SortOrder)((Object)object.getSecond()));
    }

    @Override
    public final String hexToDb(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "0x" + string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

