/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CodecsKt;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.auth.HeaderValueEncoding;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import io.ktor.util.CryptoKt;
import io.ktor.util.Hash;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000f\u0010\u000e\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\n\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/auth/HttpAuthHeader;", "", "", "authScheme", "<init>", "(Ljava/lang/String;)V", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "toString", "Ljava/lang/String;", "getAuthScheme", "Companion", "Single", "Parameterized", "Parameters", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader$Single;", "ktor-http"})
public abstract class HttpAuthHeader {
    public static final Companion Companion = new Companion(null);
    private final String authScheme;

    private HttpAuthHeader(String charSequence) {
        this.authScheme = charSequence;
        charSequence = this.authScheme;
        if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
            throw new ParseException("Invalid authScheme value: it should be token, but instead it is " + this.authScheme, null, 2, null);
        }
    }

    public final String getAuthScheme() {
        return this.authScheme;
    }

    public abstract String render(HeaderValueEncoding var1);

    public abstract String render();

    public String toString() {
        return this.render();
    }

    public /* synthetic */ HttpAuthHeader(String string, DefaultConstructorMarker defaultConstructorMarker) {
        this(string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJQ\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Companion;", "", "<init>", "()V", "", "realm", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "basicAuthChallenge", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "scheme", "Lio/ktor/http/auth/HttpAuthHeader;", "bearerAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "nonce", "", "domain", "opaque", "", "stale", "algorithm", "digestAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public final Parameterized basicAuthChallenge(String object, Charset object2) {
            LinkedHashMap<String, String> linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap = new LinkedHashMap<String, String>();
            String string = "Basic";
            linkedHashMap2.put("realm", (String)object);
            if (object2 != null) {
                linkedHashMap2.put("charset", CharsetJVMKt.getName((Charset)object2));
            }
            object = linkedHashMap;
            object2 = string;
            return new Parameterized((String)object2, (Map)object, null, 4, null);
        }

        public final HttpAuthHeader bearerAuthChallenge(String string, String string2) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            return new Parameterized(string, string2 == null ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)"realm", (Object)string2)), null, 4, null);
        }

        public static /* synthetic */ HttpAuthHeader bearerAuthChallenge$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.bearerAuthChallenge(string, string2);
        }

        public final Parameterized digestAuthChallenge(String object, String object2, List<String> object3, String string, Boolean bl, String string2) {
            LinkedHashMap<String, String> linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"");
            Intrinsics.checkNotNullParameter(object3, (String)"");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"");
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap = new LinkedHashMap<String, String>();
            String string3 = "Digest";
            linkedHashMap2.put("realm", HeaderValueWithParametersKt.quote(object));
            linkedHashMap2.put("nonce", HeaderValueWithParametersKt.quote((String)object2));
            if (!((Collection)object3).isEmpty()) {
                linkedHashMap2.put("domain", HeaderValueWithParametersKt.quote(CollectionsKt.joinToString$default((Iterable)((Iterable)object3), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
            }
            if (string != null) {
                linkedHashMap2.put("opaque", HeaderValueWithParametersKt.quote(string));
            }
            if (bl != null) {
                linkedHashMap2.put("stale", bl.toString());
            }
            linkedHashMap2.put("algorithm", string2);
            object = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            object2 = linkedHashMap;
            object3 = string3;
            return new Parameterized((String)object3, (Map<String, String>)object2, (HeaderValueEncoding)((Object)object));
        }

        public static /* synthetic */ Parameterized digestAuthChallenge$default(Companion companion, String string, String string2, List list, String string3, Boolean bl, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = CryptoKt.generateNonce();
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                string4 = "MD5";
            }
            return companion.digestAuthChallenge(string, string2, list, string3, bl, string4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "<init>", "(Ljava/lang/String;Ljava/util/List;Lio/ktor/http/auth/HeaderValueEncoding;)V", "", "(Ljava/lang/String;Ljava/util/Map;Lio/ktor/http/auth/HeaderValueEncoding;)V", "name", "value", "withParameter", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "withReplacedParameter", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "parameter", "(Ljava/lang/String;)Ljava/lang/String;", "encode", "(Ljava/lang/String;Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/util/List;", "getParameters", "()Ljava/util/List;", "Lio/ktor/http/auth/HeaderValueEncoding;", "getEncoding", "()Lio/ktor/http/auth/HeaderValueEncoding;", "ktor-http"})
    public static final class Parameterized
    extends HttpAuthHeader {
        private final List<HeaderValueParam> parameters;
        private final HeaderValueEncoding encoding;

        public Parameterized(String iterator, List<HeaderValueParam> object, HeaderValueEncoding headerValueEncoding) {
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"");
            Intrinsics.checkNotNullParameter(object, (String)"");
            Intrinsics.checkNotNullParameter((Object)((Object)headerValueEncoding), (String)"");
            super((String)((Object)iterator), null);
            this.parameters = object;
            this.encoding = headerValueEncoding;
            iterator = this.parameters;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                object = (HeaderValueParam)object;
                object = ((HeaderValueParam)object).getName();
                if (HttpAuthHeaderKt.access$getToken68Pattern$p().matches((CharSequence)object)) continue;
                throw new ParseException("Parameter name should be a token", null, 2, null);
            }
        }

        public /* synthetic */ Parameterized(String string, List list, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, list, headerValueEncoding);
        }

        public final List<HeaderValueParam> getParameters() {
            return this.parameters;
        }

        public final HeaderValueEncoding getEncoding() {
            return this.encoding;
        }

        public Parameterized(String object, Map<String, String> iterator, HeaderValueEncoding headerValueEncoding) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter(iterator, (String)"");
            Intrinsics.checkNotNullParameter((Object)((Object)headerValueEncoding), (String)"");
            String string = object;
            object = iterator.entrySet();
            String string2 = string;
            Parameterized parameterized = this;
            iterator = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object3 = iterator.next();
                object3 = (Map.Entry)object3;
                object2 = object;
                object2.add(new HeaderValueParam((String)object3.getKey(), (String)object3.getValue()));
            }
            object2 = (List)object;
            parameterized(string2, (List<HeaderValueParam>)object2, headerValueEncoding);
        }

        public /* synthetic */ Parameterized(String string, Map map, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, map, headerValueEncoding);
        }

        public final Parameterized withParameter(String string, String string2) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"");
            return new Parameterized(this.getAuthScheme(), CollectionsKt.plus((Collection)this.parameters, (Object)new HeaderValueParam(string, string2)), this.encoding);
        }

        public final Parameterized withReplacedParameter(String object, String string) {
            int n;
            int n2;
            Object object2;
            Object object3;
            block8: {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                Object object4 = this.parameters;
                int n3 = 0;
                object4 = object4.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    object2 = (HeaderValueParam)object3;
                    if (Intrinsics.areEqual((Object)((HeaderValueParam)object2).getName(), (Object)object)) {
                        n2 = n3;
                        break block8;
                    }
                    ++n3;
                }
                n2 = n = -1;
            }
            if (n2 == -1) {
                return this.withParameter((String)object, string);
            }
            n = 0;
            Object object5 = this.parameters;
            object3 = object5;
            object2 = new ArrayList();
            object5 = object3;
            object5 = object5.iterator();
            while (object5.hasNext()) {
                Object object6;
                Object e = object5.next();
                object3 = e;
                object3 = e;
                object3 = (HeaderValueParam)e;
                if (!Intrinsics.areEqual((Object)((HeaderValueParam)object3).getName(), (Object)object)) {
                    object6 = object3;
                } else if (n == 0) {
                    n = 1;
                    object6 = new HeaderValueParam((String)object, string);
                } else {
                    object6 = null;
                }
                if (object6 == null) continue;
                object3 = object6;
                object2.add(object3);
            }
            object = (List)object2;
            return new Parameterized(this.getAuthScheme(), (List<HeaderValueParam>)object, this.encoding);
        }

        @Override
        public final String render(HeaderValueEncoding headerValueEncoding) {
            Intrinsics.checkNotNullParameter((Object)((Object)headerValueEncoding), (String)"");
            if (this.parameters.isEmpty()) {
                return this.getAuthScheme();
            }
            return CollectionsKt.joinToString$default((Iterable)this.parameters, (CharSequence)", ", (CharSequence)(this.getAuthScheme() + ' '), null, (int)0, null, arg_0 -> Parameterized.render$lambda$4(this, headerValueEncoding, arg_0), (int)28, null);
        }

        public final String parameter(String string) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                Object object = this.parameters;
                object = object.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    HeaderValueParam headerValueParam = (HeaderValueParam)e;
                    if (!Intrinsics.areEqual((Object)headerValueParam.getName(), (Object)string)) continue;
                    v0 = e;
                    break block2;
                }
                v0 = null;
            }
            HeaderValueParam headerValueParam = v0;
            if (headerValueParam != null) {
                return headerValueParam.getValue();
            }
            return null;
        }

        private final String encode(String string, HeaderValueEncoding headerValueEncoding) {
            switch (WhenMappings.$EnumSwitchMapping$0[headerValueEncoding.ordinal()]) {
                case 1: {
                    return HeaderValueWithParametersKt.escapeIfNeeded(string);
                }
                case 2: {
                    return HeaderValueWithParametersKt.quote(string);
                }
                case 3: {
                    return CodecsKt.encodeURLParameter$default(string, false, 1, null);
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public final String render() {
            Parameterized parameterized = this;
            return ((HttpAuthHeader)parameterized).render(parameterized.encoding);
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Parameterized)) {
                return false;
            }
            return StringsKt.equals((String)((Parameterized)object).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && Intrinsics.areEqual(((Parameterized)object).parameters, this.parameters);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            String string = this.getAuthScheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            objectArray[0] = string;
            objectArray2[1] = this.parameters;
            return Hash.INSTANCE.combine(objectArray2);
        }

        private static final CharSequence render$lambda$4(Parameterized parameterized, HeaderValueEncoding headerValueEncoding, HeaderValueParam headerValueParam) {
            Intrinsics.checkNotNullParameter((Object)headerValueParam, (String)"");
            return headerValueParam.getName() + '=' + parameterized.encode(headerValueParam.getValue(), headerValueEncoding);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HeaderValueEncoding.values().length];
                try {
                    nArray[HeaderValueEncoding.QUOTED_WHEN_REQUIRED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[HeaderValueEncoding.QUOTED_ALWAYS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[HeaderValueEncoding.URI_ENCODE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameters;", "", "<init>", "()V", "", "Realm", "Ljava/lang/String;", "Charset", "OAuthCallback", "OAuthConsumerKey", "OAuthNonce", "OAuthToken", "OAuthTokenSecret", "OAuthVerifier", "OAuthSignatureMethod", "OAuthTimestamp", "OAuthVersion", "OAuthSignature", "OAuthCallbackConfirmed", "ktor-http"})
    public static final class Parameters {
        public static final Parameters INSTANCE = new Parameters();
        public static final String Realm = "realm";
        public static final String Charset = "charset";
        public static final String OAuthCallback = "oauth_callback";
        public static final String OAuthConsumerKey = "oauth_consumer_key";
        public static final String OAuthNonce = "oauth_nonce";
        public static final String OAuthToken = "oauth_token";
        public static final String OAuthTokenSecret = "oauth_token_secret";
        public static final String OAuthVerifier = "oauth_verifier";
        public static final String OAuthSignatureMethod = "oauth_signature_method";
        public static final String OAuthTimestamp = "oauth_timestamp";
        public static final String OAuthVersion = "oauth_version";
        public static final String OAuthSignature = "oauth_signature";
        public static final String OAuthCallbackConfirmed = "oauth_callback_confirmed";

        private Parameters() {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Single;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "blob", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "render", "()Ljava/lang/String;", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getBlob", "ktor-http"})
    public static final class Single
    extends HttpAuthHeader {
        private final String blob;

        public Single(String charSequence, String string) {
            Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            super((String)charSequence, null);
            this.blob = string;
            charSequence = this.blob;
            if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
                throw new ParseException("Invalid blob value: it should be token68", null, 2, null);
            }
        }

        public final String getBlob() {
            return this.blob;
        }

        @Override
        public final String render() {
            return this.getAuthScheme() + ' ' + this.blob;
        }

        @Override
        public final String render(HeaderValueEncoding headerValueEncoding) {
            Intrinsics.checkNotNullParameter((Object)((Object)headerValueEncoding), (String)"");
            return ((HttpAuthHeader)this).render();
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Single)) {
                return false;
            }
            return StringsKt.equals((String)((Single)object).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && StringsKt.equals((String)((Single)object).blob, (String)this.blob, (boolean)true);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            String string = this.getAuthScheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            objectArray[0] = string;
            Intrinsics.checkNotNullExpressionValue((Object)this.blob.toLowerCase(Locale.ROOT), (String)"");
            return Hash.INSTANCE.combine(objectArray2);
        }
    }
}

