/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.material.DraggableAnchors;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material/MapDraggableAnchors;", "T", "Landroidx/compose/material/DraggableAnchors;", "anchors", "", "", "<init>", "(Ljava/util/Map;)V", "positionOf", "value", "(Ljava/lang/Object;)F", "hasAnchorFor", "", "(Ljava/lang/Object;)Z", "closestAnchor", "position", "(F)Ljava/lang/Object;", "searchUpwards", "(FZ)Ljava/lang/Object;", "minAnchor", "maxAnchor", "size", "", "getSize", "()I", "equals", "other", "", "hashCode", "toString", "", "material"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    private final Map<T, Float> anchors;

    public MapDraggableAnchors(Map<T, Float> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.anchors = map;
    }

    @Override
    public final float positionOf(T t) {
        Float f2 = this.anchors.get(t);
        if (f2 != null) {
            return f2.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final boolean hasAnchorFor(T t) {
        return this.anchors.containsKey(t);
    }

    @Override
    public final T closestAnchor(float f2) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry entry = (Map.Entry)e;
                float f3 = Math.abs(f2 - ((Number)entry.getValue()).floatValue());
                do {
                    Object e2;
                    Map.Entry entry2;
                    float f4;
                    if (Float.compare(f3, f4 = Math.abs(f2 - ((Number)(entry2 = (Map.Entry)(e2 = object.next())).getValue()).floatValue())) <= 0) continue;
                    e = e2;
                    f3 = f4;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final T closestAnchor(float f2, boolean bl) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry entry = (Map.Entry)e;
                float f3 = ((Number)entry.getValue()).floatValue();
                float f4 = bl ? f3 - f2 : f2 - f3;
                f4 = f4 < 0.0f ? Float.POSITIVE_INFINITY : f4;
                do {
                    Object e2 = object.next();
                    Map.Entry entry2 = (Map.Entry)e2;
                    f3 = ((Number)entry2.getValue()).floatValue();
                    f3 = bl ? f3 - f2 : f2 - f3;
                    float f5 = f3 = f3 < 0.0f ? Float.POSITIVE_INFINITY : f3;
                    if (Float.compare(f4, f3) <= 0) continue;
                    e = e2;
                    f4 = f3;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final float minAnchor() {
        Float f2 = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        if (f2 != null) {
            return f2.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final float maxAnchor() {
        Float f2 = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        if (f2 != null) {
            return f2.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final int getSize() {
        return this.anchors.size();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)object).anchors);
    }

    public final int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    public final String toString() {
        return "MapDraggableAnchors(" + this.anchors + ")";
    }
}

