/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.ChannelException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.VSockAddress;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;

public final class LinuxSocket
extends Socket {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;

    LinuxSocket(int n) {
        super(n);
    }

    final InternetProtocolFamily family() {
        if (this.ipv6) {
            return InternetProtocolFamily.IPv6;
        }
        return InternetProtocolFamily.IPv4;
    }

    final int sendmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n, int n2) {
        return Native.sendmmsg(this.intValue(), this.ipv6, nativeDatagramPacketArray, n, n2);
    }

    final int recvmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n, int n2) {
        return Native.recvmmsg(this.intValue(), this.ipv6, nativeDatagramPacketArray, n, n2);
    }

    final int recvmsg(NativeDatagramPacketArray.NativeDatagramPacket nativeDatagramPacket) {
        return Native.recvmsg(this.intValue(), this.ipv6, nativeDatagramPacket);
    }

    final void setTimeToLive(int n) {
        LinuxSocket.setTimeToLive(this.intValue(), n);
    }

    final void setInterface(InetAddress inetAddress) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, nativeInetAddress.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(inetAddress));
    }

    final void setNetworkInterface(NetworkInterface networkInterface) {
        InetAddress inetAddress = LinuxSocket.deriveInetAddress(networkInterface, this.family() == InternetProtocolFamily.IPv6);
        if (inetAddress.equals(this.family() == InternetProtocolFamily.IPv4 ? Native.INET_ANY : Native.INET6_ANY)) {
            throw new IOException("NetworkInterface does not support " + this.family());
        }
        inetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, inetAddress.address(), inetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
    }

    final InetAddress getInterface() {
        Object object = this.getNetworkInterface();
        if (object != null && (object = SocketUtils.addressesFromNetworkInterface((NetworkInterface)object)).hasMoreElements()) {
            return (InetAddress)object.nextElement();
        }
        return null;
    }

    final NetworkInterface getNetworkInterface() {
        int n = LinuxSocket.getInterface(this.intValue(), this.ipv6);
        if (this.ipv6) {
            if (PlatformDependent.javaVersion() >= 7) {
                return NetworkInterface.getByIndex(n);
            }
            return null;
        }
        InetAddress inetAddress = LinuxSocket.inetAddress(n);
        if (inetAddress != null) {
            return NetworkInterface.getByInetAddress(inetAddress);
        }
        return null;
    }

    private static InetAddress inetAddress(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    final void joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        boolean bl = inetAddress instanceof Inet6Address;
        NativeInetAddress nativeInetAddress2 = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(networkInterface, bl));
        if (inetAddress2 != null) {
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            inetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress2);
            LinuxSocket.joinSsmGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface), inetAddress.address());
            return;
        }
        LinuxSocket.joinGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
    }

    final void leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        boolean bl = inetAddress instanceof Inet6Address;
        NativeInetAddress nativeInetAddress2 = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(networkInterface, bl));
        if (inetAddress2 != null) {
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            inetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress2);
            LinuxSocket.leaveSsmGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface), inetAddress.address());
            return;
        }
        LinuxSocket.leaveGroup(this.intValue(), this.ipv6 && bl, nativeInetAddress.address(), nativeInetAddress2.address(), nativeInetAddress.scopeId(), LinuxSocket.interfaceIndex(networkInterface));
    }

    private static int interfaceIndex(NetworkInterface networkInterface) {
        if (PlatformDependent.javaVersion() >= 7) {
            return networkInterface.getIndex();
        }
        return -1;
    }

    private static int interfaceIndex(InetAddress object) {
        if (PlatformDependent.javaVersion() >= 7 && (object = NetworkInterface.getByInetAddress((InetAddress)object)) != null) {
            return ((NetworkInterface)object).getIndex();
        }
        return -1;
    }

    final void setTcpDeferAccept(int n) {
        LinuxSocket.setTcpDeferAccept(this.intValue(), n);
    }

    final void setTcpQuickAck(boolean bl) {
        LinuxSocket.setTcpQuickAck(this.intValue(), bl ? 1 : 0);
    }

    final void setTcpCork(boolean bl) {
        LinuxSocket.setTcpCork(this.intValue(), bl ? 1 : 0);
    }

    final void setSoBusyPoll(int n) {
        LinuxSocket.setSoBusyPoll(this.intValue(), n);
    }

    final void setTcpNotSentLowAt(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        LinuxSocket.setTcpNotSentLowAt(this.intValue(), (int)l);
    }

    final void setTcpFastOpen(int n) {
        LinuxSocket.setTcpFastOpen(this.intValue(), n);
    }

    final void setTcpKeepIdle(int n) {
        LinuxSocket.setTcpKeepIdle(this.intValue(), n);
    }

    final void setTcpKeepIntvl(int n) {
        LinuxSocket.setTcpKeepIntvl(this.intValue(), n);
    }

    final void setTcpKeepCnt(int n) {
        LinuxSocket.setTcpKeepCnt(this.intValue(), n);
    }

    final void setTcpUserTimeout(int n) {
        LinuxSocket.setTcpUserTimeout(this.intValue(), n);
    }

    final void setIpBindAddressNoPort(boolean bl) {
        LinuxSocket.setIpBindAddressNoPort(this.intValue(), bl ? 1 : 0);
    }

    final void setIpFreeBind(boolean bl) {
        LinuxSocket.setIpFreeBind(this.intValue(), bl ? 1 : 0);
    }

    final void setIpTransparent(boolean bl) {
        LinuxSocket.setIpTransparent(this.intValue(), bl ? 1 : 0);
    }

    final void setIpRecvOrigDestAddr(boolean bl) {
        LinuxSocket.setIpRecvOrigDestAddr(this.intValue(), bl ? 1 : 0);
    }

    final int getTimeToLive() {
        return LinuxSocket.getTimeToLive(this.intValue());
    }

    final void getTcpInfo(EpollTcpInfo epollTcpInfo) {
        LinuxSocket.getTcpInfo(this.intValue(), epollTcpInfo.info);
    }

    final void setTcpMd5Sig(InetAddress inetAddress, byte[] byArray) {
        inetAddress = NativeInetAddress.newInstance((InetAddress)inetAddress);
        LinuxSocket.setTcpMd5Sig(this.intValue(), this.ipv6, inetAddress.address(), inetAddress.scopeId(), byArray);
    }

    final boolean isTcpCork() {
        return LinuxSocket.isTcpCork(this.intValue()) != 0;
    }

    final int getSoBusyPoll() {
        return LinuxSocket.getSoBusyPoll(this.intValue());
    }

    final int getTcpDeferAccept() {
        return LinuxSocket.getTcpDeferAccept(this.intValue());
    }

    final boolean isTcpQuickAck() {
        return LinuxSocket.isTcpQuickAck(this.intValue()) != 0;
    }

    final long getTcpNotSentLowAt() {
        return (long)LinuxSocket.getTcpNotSentLowAt(this.intValue()) & 0xFFFFFFFFL;
    }

    final int getTcpKeepIdle() {
        return LinuxSocket.getTcpKeepIdle(this.intValue());
    }

    final int getTcpKeepIntvl() {
        return LinuxSocket.getTcpKeepIntvl(this.intValue());
    }

    final int getTcpKeepCnt() {
        return LinuxSocket.getTcpKeepCnt(this.intValue());
    }

    final int getTcpUserTimeout() {
        return LinuxSocket.getTcpUserTimeout(this.intValue());
    }

    final boolean isIpBindAddressNoPort() {
        return LinuxSocket.isIpBindAddressNoPort(this.intValue()) != 0;
    }

    final boolean isIpFreeBind() {
        return LinuxSocket.isIpFreeBind(this.intValue()) != 0;
    }

    final boolean isIpTransparent() {
        return LinuxSocket.isIpTransparent(this.intValue()) != 0;
    }

    final boolean isIpRecvOrigDestAddr() {
        return LinuxSocket.isIpRecvOrigDestAddr(this.intValue()) != 0;
    }

    final PeerCredentials getPeerCredentials() {
        return LinuxSocket.getPeerCredentials(this.intValue());
    }

    final boolean isLoopbackModeDisabled() {
        return LinuxSocket.getIpMulticastLoop(this.intValue(), this.ipv6) == 0;
    }

    final void setLoopbackModeDisabled(boolean bl) {
        LinuxSocket.setIpMulticastLoop(this.intValue(), this.ipv6, bl ? 0 : 1);
    }

    final boolean isUdpGro() {
        return LinuxSocket.isUdpGro(this.intValue()) != 0;
    }

    final void setUdpGro(boolean bl) {
        LinuxSocket.setUdpGro(this.intValue(), bl ? 1 : 0);
    }

    final long sendFile(DefaultFileRegion defaultFileRegion, long l, long l2, long l3) {
        defaultFileRegion.open();
        long l4 = LinuxSocket.sendFile(this.intValue(), defaultFileRegion, l, l2, l3);
        if (l4 >= 0L) {
            return l4;
        }
        return Errors.ioResult((String)"sendfile", (int)((int)l4));
    }

    public final void bindVSock(VSockAddress vSockAddress) {
        int n = LinuxSocket.bindVSock(this.intValue(), vSockAddress.getCid(), vSockAddress.getPort());
        if (n < 0) {
            throw Errors.newIOException((String)"bindVSock", (int)n);
        }
    }

    public final boolean connectVSock(VSockAddress vSockAddress) {
        int n = LinuxSocket.connectVSock(this.intValue(), vSockAddress.getCid(), vSockAddress.getPort());
        if (n < 0) {
            return Errors.handleConnectErrno((String)"connectVSock", (int)n);
        }
        return true;
    }

    public final VSockAddress remoteVSockAddress() {
        byte[] byArray = LinuxSocket.remoteVSockAddress(this.intValue());
        if (byArray == null) {
            return null;
        }
        int n = LinuxSocket.getIntAt(byArray, 0);
        int n2 = LinuxSocket.getIntAt(byArray, 4);
        return new VSockAddress(n, n2);
    }

    public final VSockAddress localVSockAddress() {
        byte[] byArray = LinuxSocket.localVSockAddress(this.intValue());
        if (byArray == null) {
            return null;
        }
        int n = LinuxSocket.getIntAt(byArray, 0);
        int n2 = LinuxSocket.getIntAt(byArray, 4);
        return new VSockAddress(n, n2);
    }

    private static int getIntAt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static InetAddress deriveInetAddress(NetworkInterface object, boolean bl) {
        InetAddress inetAddress;
        InetAddress inetAddress2 = inetAddress = bl ? Native.INET6_ANY : Native.INET_ANY;
        if (object != null) {
            object = ((NetworkInterface)object).getInetAddresses();
            while (object.hasMoreElements()) {
                InetAddress inetAddress3 = (InetAddress)object.nextElement();
                boolean bl2 = inetAddress3 instanceof Inet6Address;
                if (bl2 != bl) continue;
                return inetAddress3;
            }
        }
        return inetAddress;
    }

    public static LinuxSocket newSocket(int n) {
        return new LinuxSocket(n);
    }

    public static LinuxSocket newVSockStream() {
        return new LinuxSocket(LinuxSocket.newVSockStream0());
    }

    static int newVSockStream0() {
        int n = LinuxSocket.newVSockStreamFd();
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException((String)"newVSockStream", (int)n));
        }
        return n;
    }

    public static LinuxSocket newSocketStream(boolean bl) {
        return new LinuxSocket(LinuxSocket.newSocketStream0((boolean)bl));
    }

    public static LinuxSocket newSocketStream(InternetProtocolFamily internetProtocolFamily) {
        return new LinuxSocket(LinuxSocket.newSocketStream0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketStream() {
        return LinuxSocket.newSocketStream(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDgram(boolean bl) {
        return new LinuxSocket(LinuxSocket.newSocketDgram0((boolean)bl));
    }

    public static LinuxSocket newSocketDgram(InternetProtocolFamily internetProtocolFamily) {
        return new LinuxSocket(LinuxSocket.newSocketDgram0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketDgram() {
        return LinuxSocket.newSocketDgram(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDomain() {
        return new LinuxSocket(LinuxSocket.newSocketDomain0());
    }

    public static LinuxSocket newSocketDomainDgram() {
        return new LinuxSocket(LinuxSocket.newSocketDomainDgram0());
    }

    private static native int newVSockStreamFd();

    private static native int bindVSock(int var0, int var1, int var2);

    private static native int connectVSock(int var0, int var1, int var2);

    private static native byte[] remoteVSockAddress(int var0);

    private static native byte[] localVSockAddress(int var0);

    private static native void joinGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5);

    private static native void joinSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6);

    private static native void leaveGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5);

    private static native void leaveSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6);

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6);

    private static native int getTcpDeferAccept(int var0);

    private static native int isTcpQuickAck(int var0);

    private static native int isTcpCork(int var0);

    private static native int getSoBusyPoll(int var0);

    private static native int getTcpNotSentLowAt(int var0);

    private static native int getTcpKeepIdle(int var0);

    private static native int getTcpKeepIntvl(int var0);

    private static native int getTcpKeepCnt(int var0);

    private static native int getTcpUserTimeout(int var0);

    private static native int getTimeToLive(int var0);

    private static native int isIpBindAddressNoPort(int var0);

    private static native int isIpFreeBind(int var0);

    private static native int isIpTransparent(int var0);

    private static native int isIpRecvOrigDestAddr(int var0);

    private static native void getTcpInfo(int var0, long[] var1);

    private static native PeerCredentials getPeerCredentials(int var0);

    private static native void setTcpDeferAccept(int var0, int var1);

    private static native void setTcpQuickAck(int var0, int var1);

    private static native void setTcpCork(int var0, int var1);

    private static native void setSoBusyPoll(int var0, int var1);

    private static native void setTcpNotSentLowAt(int var0, int var1);

    private static native void setTcpFastOpen(int var0, int var1);

    private static native void setTcpKeepIdle(int var0, int var1);

    private static native void setTcpKeepIntvl(int var0, int var1);

    private static native void setTcpKeepCnt(int var0, int var1);

    private static native void setTcpUserTimeout(int var0, int var1);

    private static native void setIpBindAddressNoPort(int var0, int var1);

    private static native void setIpFreeBind(int var0, int var1);

    private static native void setIpTransparent(int var0, int var1);

    private static native void setIpRecvOrigDestAddr(int var0, int var1);

    private static native void setTcpMd5Sig(int var0, boolean var1, byte[] var2, int var3, byte[] var4);

    private static native void setInterface(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int getInterface(int var0, boolean var1);

    private static native int getIpMulticastLoop(int var0, boolean var1);

    private static native void setIpMulticastLoop(int var0, boolean var1, int var2);

    private static native void setTimeToLive(int var0, int var1);

    private static native int isUdpGro(int var0);

    private static native void setUdpGro(int var0, int var1);
}

