/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010+\n\u0002\b\t\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0096\u0002J\u0015\u0010!\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010%\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0015\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010*\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0015\u0010+\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010,\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u001e\u0010-\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010.J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u00100\u001a\u00020#H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Landroidx/compose/runtime/snapshots/SubList;", "T", "", "parentList", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "fromIndex", "", "toIndex", "<init>", "(Landroidx/compose/runtime/snapshots/SnapshotStateList;II)V", "getParentList", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "offset", "structure", "value", "size", "getSize", "()I", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "get", "index", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "add", "", "(ILjava/lang/Object;)V", "addAll", "clear", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "validateModification", "runtime"})
public final class SubList<T>
implements List<T>,
KMutableList {
    private final SnapshotStateList<T> parentList;
    private final int offset;
    private int structure;
    private int size;
    public static final int $stable = 8;

    public SubList(SnapshotStateList<T> snapshotStateList, int n2, int n3) {
        this.parentList = snapshotStateList;
        this.offset = n2;
        this.structure = SnapshotStateListKt.getStructure(this.parentList);
        this.size = n3 - n2;
    }

    public final SnapshotStateList<T> getParentList() {
        return this.parentList;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public final boolean containsAll(Collection<?> object) {
        if (!((object = (Iterable)object) instanceof Collection) || !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.contains(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final T get(int n2) {
        this.validateModification();
        SnapshotStateListKt.access$validateRange(n2, this.size());
        return this.parentList.get(this.offset + n2);
    }

    @Override
    public final int indexOf(Object object) {
        this.validateModification();
        Object object2 = (Iterable)RangesKt.until((int)this.offset, (int)(this.offset + this.size()));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n2 = ((IntIterator)object2).nextInt();
            if (!Intrinsics.areEqual((Object)object, this.parentList.get(n2))) continue;
            return n2 - this.offset;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public final int lastIndexOf(Object object) {
        this.validateModification();
        for (int i2 = this.offset + this.size() - 1; i2 >= this.offset; --i2) {
            if (!Intrinsics.areEqual((Object)object, this.parentList.get(i2))) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    @Override
    public final boolean add(T t) {
        this.validateModification();
        this.parentList.add(this.offset + this.size(), t);
        int n2 = this.size();
        this.size = n2 + 1;
        this.structure = SnapshotStateListKt.getStructure(this.parentList);
        return true;
    }

    @Override
    public final void add(int n2, T t) {
        this.validateModification();
        this.parentList.add(this.offset + n2, t);
        n2 = this.size();
        this.size = n2 + 1;
        this.structure = SnapshotStateListKt.getStructure(this.parentList);
    }

    @Override
    public final boolean addAll(int n2, Collection<? extends T> collection) {
        this.validateModification();
        boolean bl = this.parentList.addAll(n2 + this.offset, (Collection<? extends T>)collection);
        n2 = bl ? 1 : 0;
        if (bl) {
            this.size = this.size() + collection.size();
            this.structure = SnapshotStateListKt.getStructure(this.parentList);
        }
        return n2 != 0;
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        SubList subList = this;
        return subList.addAll(subList.size(), collection);
    }

    @Override
    public final void clear() {
        if (this.size() > 0) {
            this.validateModification();
            this.parentList.removeRange(this.offset, this.offset + this.size());
            this.size = 0;
            this.structure = SnapshotStateListKt.getStructure(this.parentList);
        }
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<T> listIterator(int n2) {
        this.validateModification();
        Ref.IntRef intRef = new Ref.IntRef();
        new Ref.IntRef().element = n2 - 1;
        return new ListIterator<T>(intRef, this){
            final /* synthetic */ Ref.IntRef $current;
            final /* synthetic */ SubList<T> this$0;
            {
                this.$current = intRef;
                this.this$0 = subList;
            }

            public final boolean hasPrevious() {
                return this.$current.element >= 0;
            }

            public final int nextIndex() {
                return this.$current.element + 1;
            }

            public final T previous() {
                int n2 = this.$current.element;
                SnapshotStateListKt.access$validateRange(n2, this.this$0.size());
                this.$current.element = n2 - 1;
                return this.this$0.get(n2);
            }

            public final int previousIndex() {
                return this.$current.element;
            }

            public final Void add(T t) {
                SnapshotStateListKt.access$modificationError();
                throw new KotlinNothingValueException();
            }

            public final boolean hasNext() {
                return this.$current.element < this.this$0.size() - 1;
            }

            public final T next() {
                int n2 = this.$current.element + 1;
                SnapshotStateListKt.access$validateRange(n2, this.this$0.size());
                this.$current.element = n2;
                return this.this$0.get(n2);
            }

            public final Void remove() {
                SnapshotStateListKt.access$modificationError();
                throw new KotlinNothingValueException();
            }

            public final Void set(T t) {
                SnapshotStateListKt.access$modificationError();
                throw new KotlinNothingValueException();
            }
        };
    }

    @Override
    public final boolean remove(Object object) {
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeAll(Collection<?> object) {
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            bl = this.remove(e) || bl;
        }
        return bl;
    }

    public final T removeAt(int n2) {
        this.validateModification();
        T t = this.parentList.remove(this.offset + n2);
        int n3 = this.size();
        this.size = n3 + -1;
        this.structure = SnapshotStateListKt.getStructure(this.parentList);
        return t;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        this.validateModification();
        int n2 = this.parentList.retainAllInRange$runtime(collection, this.offset, this.offset + this.size());
        if (n2 > 0) {
            this.structure = SnapshotStateListKt.getStructure(this.parentList);
            this.size = this.size() - n2;
        }
        return n2 > 0;
    }

    @Override
    public final T set(int n2, T t) {
        SnapshotStateListKt.access$validateRange(n2, this.size());
        this.validateModification();
        T t2 = this.parentList.set(n2 + this.offset, t);
        this.structure = SnapshotStateListKt.getStructure(this.parentList);
        return t2;
    }

    @Override
    public final List<T> subList(int n2, int n3) {
        boolean bl = (n2 >= 0 ? n2 <= n3 : false) && n3 <= this.size();
        if (!bl) {
            PreconditionsKt.throwIllegalArgumentException("fromIndex or toIndex are out of bounds");
        }
        this.validateModification();
        return new SubList<T>(this.parentList, n2 + this.offset, n3 + this.offset);
    }

    private final void validateModification() {
        if (SnapshotStateListKt.getStructure(this.parentList) != this.structure) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final T remove(int n2) {
        return this.removeAt(n2);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @Override
    public final Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

