/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private static final int HASH_CODE_PRIME = 31;
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, DefaultHttpHeadersFactory.headersFactory().newHeaders());
    }

    @Deprecated
    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, boolean bl) {
        this(httpVersion, httpMethod, string, DefaultHttpHeadersFactory.headersFactory().withValidation(bl));
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeadersFactory httpHeadersFactory) {
        this(httpVersion, httpMethod, string, httpHeadersFactory.newHeaders());
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeaders httpHeaders) {
        super(httpVersion, httpHeaders);
        this.method = (HttpMethod)ObjectUtil.checkNotNull((Object)httpMethod, (String)"method");
        this.uri = (String)ObjectUtil.checkNotNull((Object)string, (String)"uri");
    }

    @Override
    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    @Deprecated
    public String getUri() {
        return this.uri();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod httpMethod) {
        this.method = (HttpMethod)ObjectUtil.checkNotNull((Object)httpMethod, (String)"method");
        return this;
    }

    @Override
    public HttpRequest setUri(String string) {
        this.uri = (String)ObjectUtil.checkNotNull((Object)string, (String)"uri");
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.method.hashCode();
        n = n * 31 + this.uri.hashCode();
        n = n * 31 + super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpRequest)) {
            return false;
        }
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)object;
        return this.method().equals(defaultHttpRequest.method()) && this.uri().equalsIgnoreCase(defaultHttpRequest.uri()) && super.equals(object);
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

