/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpStatusClass;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public final class HttpServerCodec
extends CombinedChannelDuplexHandler<HttpRequestDecoder, HttpResponseEncoder>
implements HttpServerUpgradeHandler.SourceCodec {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();

    public HttpServerCodec() {
        this(4096, 8192, 8192);
    }

    public HttpServerCodec(int n, int n2, int n3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3));
    }

    @Deprecated
    public HttpServerCodec(int n, int n2, int n3, boolean bl) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl));
    }

    @Deprecated
    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl).setInitialBufferSize(n4));
    }

    @Deprecated
    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl2));
    }

    @Deprecated
    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl2).setAllowPartialChunks(bl3));
    }

    public HttpServerCodec(HttpDecoderConfig httpDecoderConfig) {
        this.init((ChannelInboundHandler)new HttpServerRequestDecoder(httpDecoderConfig), (ChannelOutboundHandler)new HttpServerResponseEncoder());
    }

    @Override
    public final void upgradeFrom(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().remove((ChannelHandler)this);
    }

    private final class HttpServerResponseEncoder
    extends HttpResponseEncoder {
        private HttpMethod method;

        private HttpServerResponseEncoder() {
        }

        @Override
        protected final void sanitizeHeadersBeforeEncode(HttpResponse httpResponse, boolean bl) {
            if (!bl && HttpMethod.CONNECT.equals(this.method) && httpResponse.status().codeClass() == HttpStatusClass.SUCCESS) {
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                return;
            }
            super.sanitizeHeadersBeforeEncode(httpResponse, bl);
        }

        @Override
        protected final boolean isContentAlwaysEmpty(HttpResponse httpResponse) {
            this.method = (HttpMethod)HttpServerCodec.this.queue.poll();
            return HttpMethod.HEAD.equals(this.method) || super.isContentAlwaysEmpty(httpResponse);
        }
    }

    private final class HttpServerRequestDecoder
    extends HttpRequestDecoder {
        HttpServerRequestDecoder(HttpDecoderConfig httpDecoderConfig) {
            super(httpDecoderConfig);
        }

        @Override
        protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            int n = list.size();
            super.decode(channelHandlerContext, byteBuf, list);
            int n2 = list.size();
            for (int i = n; i < n2; ++i) {
                Object object = list.get(i);
                if (!(object instanceof HttpRequest)) continue;
                HttpServerCodec.this.queue.add(((HttpRequest)object).method());
            }
        }
    }
}

