/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
    private int chunkPosition;

    protected AbstractMemoryHttpData(String string, Charset charset, long l) {
        super(string, charset, l);
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
        long l = byteBuf.readableBytes();
        try {
            this.checkSize(l);
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        if (this.definedSize > 0L && this.definedSize < l) {
            byteBuf.release();
            throw new IOException("Out of size: " + l + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.size = l;
        this.setCompleted();
    }

    @Override
    public void setContent(InputStream inputStream) {
        ObjectUtil.checkNotNull((Object)inputStream, (String)"inputStream");
        byte[] byArray = new byte[16384];
        ByteBuf byteBuf = Unpooled.buffer();
        int n = 0;
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                byteBuf.writeBytes(byArray, 0, n2);
                this.checkSize(n += n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        this.size = n;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            byteBuf.release();
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.setCompleted();
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (byteBuf != null) {
            long l = byteBuf.readableBytes();
            try {
                AbstractMemoryHttpData abstractMemoryHttpData = this;
                abstractMemoryHttpData.checkSize(abstractMemoryHttpData.size + l);
            }
            catch (IOException iOException) {
                byteBuf.release();
                throw iOException;
            }
            if (this.definedSize > 0L && this.definedSize < this.size + l) {
                byteBuf.release();
                throw new IOException("Out of size: " + (this.size + l) + " > " + this.definedSize);
            }
            this.size += l;
            if (this.byteBuf == null) {
                this.byteBuf = byteBuf;
            } else if (l == 0L) {
                byteBuf.release();
            } else if (this.byteBuf.readableBytes() == 0) {
                this.byteBuf.release();
                this.byteBuf = byteBuf;
            } else if (this.byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.byteBuf;
                compositeByteBuf.addComponent(true, byteBuf);
            } else {
                CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
                compositeByteBuf.addComponents(true, new ByteBuf[]{this.byteBuf, byteBuf});
                this.byteBuf = compositeByteBuf;
            }
        }
        if (bl) {
            this.setCompleted();
            return;
        }
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
    }

    @Override
    public void setContent(File object) {
        Object object2;
        ObjectUtil.checkNotNull((Object)object, (String)"file");
        long l = ((File)object).length();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(l);
        object = new RandomAccessFile((File)object, "r");
        try {
            FileChannel fileChannel = ((RandomAccessFile)object).getChannel();
            try {
                object2 = new byte[(int)l];
                object2 = ByteBuffer.wrap((byte[])object2);
                int n = 0;
                while ((long)n < l) {
                    n += fileChannel.read((ByteBuffer)object2);
                }
            }
            finally {
                fileChannel.close();
            }
        }
        finally {
            ((RandomAccessFile)object).close();
        }
        ((ByteBuffer)object2).flip();
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuffer[])new ByteBuffer[]{object2});
        this.size = l;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            this.byteBuf.release();
            this.byteBuf = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.byteBuf == null) {
            return Unpooled.EMPTY_BUFFER.array();
        }
        byte[] byArray = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(this.byteBuf.readerIndex(), byArray);
        return byArray;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.byteBuf == null) {
            return "";
        }
        if (charset == null) {
            charset = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString(charset);
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Override
    public ByteBuf getChunk(int n) {
        if (this.byteBuf == null || n == 0 || this.byteBuf.readableBytes() == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n2 = this.byteBuf.readableBytes() - this.chunkPosition;
        if (n2 == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n3 = n;
        if (n2 < n) {
            n3 = n2;
        }
        ByteBuf byteBuf = this.byteBuf.retainedSlice(this.chunkPosition, n3);
        this.chunkPosition += n3;
        return byteBuf;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean renameTo(File object) {
        long l;
        ObjectUtil.checkNotNull((Object)object, (String)"dest");
        if (this.byteBuf == null) {
            if (!((File)object).createNewFile()) {
                throw new IOException("file exists already: " + object);
            }
            return true;
        }
        int n = this.byteBuf.readableBytes();
        object = new RandomAccessFile((File)object, "rw");
        try {
            FileChannel fileChannel = ((RandomAccessFile)object).getChannel();
            try {
                if (this.byteBuf.nioBufferCount() == 1) {
                    ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
                    for (l = 0L; l < (long)n; l += (long)fileChannel.write(byteBuffer)) {
                    }
                } else {
                    ByteBuffer[] byteBufferArray = this.byteBuf.nioBuffers();
                    while (l < (long)n) {
                        l += fileChannel.write(byteBufferArray);
                    }
                }
                fileChannel.force(false);
            }
            finally {
                fileChannel.close();
            }
        }
        finally {
            ((RandomAccessFile)object).close();
        }
        return l == (long)n;
    }

    @Override
    public File getFile() {
        throw new IOException("Not represented by a file");
    }

    @Override
    public HttpData touch() {
        return ((AbstractHttpData)this).touch(null);
    }

    @Override
    public HttpData touch(Object object) {
        if (this.byteBuf != null) {
            this.byteBuf.touch(object);
        }
        return this;
    }
}

