/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private String baseDir;
    private boolean deleteOnExit;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = Collections.synchronizedMap(new IdentityHashMap());

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public DefaultHttpDataFactory(Charset charset) {
        this();
        this.charset = charset;
    }

    public DefaultHttpDataFactory(boolean bl) {
        this.useDisk = bl;
        this.checkSize = false;
    }

    public DefaultHttpDataFactory(boolean bl, Charset charset) {
        this(bl);
        this.charset = charset;
    }

    public DefaultHttpDataFactory(long l) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = l;
    }

    public DefaultHttpDataFactory(long l, Charset charset) {
        this(l);
        this.charset = charset;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    @Override
    public void setMaxLimit(long l) {
        this.maxSize = l;
    }

    private List<HttpData> getList(HttpRequest httpRequest) {
        List<HttpData> list = this.requestFileDeleteMap.get(httpRequest);
        if (list == null) {
            list = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put(httpRequest, list);
        }
        return list;
    }

    @Override
    public Attribute createAttribute(HttpRequest list, String object) {
        if (this.useDisk) {
            object = new DiskAttribute((String)object, this.charset, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        if (this.checkSize) {
            object = new MixedAttribute((String)object, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        object = new MemoryAttribute((String)object);
        ((AbstractHttpData)object).setMaxSize(this.maxSize);
        return object;
    }

    @Override
    public Attribute createAttribute(HttpRequest list, String object, long l) {
        if (this.useDisk) {
            object = new DiskAttribute((String)object, l, this.charset, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        if (this.checkSize) {
            object = new MixedAttribute((String)object, l, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        object = new MemoryAttribute((String)object, l);
        ((AbstractHttpData)object).setMaxSize(this.maxSize);
        return object;
    }

    private static void checkHttpDataSize(HttpData httpData) {
        try {
            HttpData httpData2 = httpData;
            httpData2.checkSize(httpData2.length());
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    @Override
    public Attribute createAttribute(HttpRequest list, String string, String string2) {
        if (this.useDisk) {
            AbstractReferenceCounted abstractReferenceCounted;
            try {
                abstractReferenceCounted = new DiskAttribute(string, string2, this.charset, this.baseDir, this.deleteOnExit);
                abstractReferenceCounted.setMaxSize(this.maxSize);
            }
            catch (IOException iOException) {
                abstractReferenceCounted = new MixedAttribute(string, string2, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
                abstractReferenceCounted.setMaxSize(this.maxSize);
            }
            DefaultHttpDataFactory.checkHttpDataSize(abstractReferenceCounted);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)abstractReferenceCounted);
            return abstractReferenceCounted;
        }
        if (this.checkSize) {
            MixedAttribute mixedAttribute = new MixedAttribute(string, string2, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            mixedAttribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(mixedAttribute);
            list = this.getList((HttpRequest)((Object)list));
            list.add(mixedAttribute);
            return mixedAttribute;
        }
        try {
            MemoryAttribute memoryAttribute = new MemoryAttribute(string, string2, this.charset);
            memoryAttribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(memoryAttribute);
            return memoryAttribute;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    public FileUpload createFileUpload(HttpRequest list, String object, String string, String string2, String string3, Charset charset, long l) {
        if (this.useDisk) {
            object = new DiskFileUpload((String)object, string, string2, string3, charset, l, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize((HttpData)object);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        if (this.checkSize) {
            object = new MixedFileUpload((String)object, string, string2, string3, charset, l, this.minSize, this.baseDir, this.deleteOnExit);
            object.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize((HttpData)object);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)object);
            return object;
        }
        object = new MemoryFileUpload((String)object, string, string2, string3, charset, l);
        ((AbstractHttpData)object).setMaxSize(this.maxSize);
        DefaultHttpDataFactory.checkHttpDataSize((HttpData)object);
        return object;
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest httpRequest, InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof HttpData)) {
            return;
        }
        List<HttpData> list = this.requestFileDeleteMap.get(httpRequest);
        if (list == null) {
            return;
        }
        Iterator<HttpData> iterator = list.iterator();
        while (iterator.hasNext()) {
            HttpData httpData = iterator.next();
            if (httpData != interfaceHttpData) continue;
            iterator.remove();
            if (list.isEmpty()) {
                this.requestFileDeleteMap.remove(httpRequest);
            }
            return;
        }
    }

    @Override
    public void cleanRequestHttpData(HttpRequest iterator) {
        if ((iterator = this.requestFileDeleteMap.remove(iterator)) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HttpData httpData = (HttpData)iterator.next();
                httpData.release();
            }
        }
    }

    @Override
    public void cleanAllHttpData() {
        Iterator<Map.Entry<HttpRequest, List<HttpData>>> iterator = this.requestFileDeleteMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator<HttpData> iterator2 = iterator.next();
            iterator2 = iterator2.getValue();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                HttpData httpData = iterator2.next();
                httpData.release();
            }
            iterator.remove();
        }
    }

    @Override
    public void cleanRequestHttpDatas(HttpRequest httpRequest) {
        this.cleanRequestHttpData(httpRequest);
    }

    @Override
    public void cleanAllHttpDatas() {
        this.cleanAllHttpData();
    }
}

