/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

final class InternalAttribute
extends AbstractReferenceCounted
implements InterfaceHttpData {
    private final List<ByteBuf> value = new ArrayList<ByteBuf>();
    private final Charset charset;
    private int size;

    InternalAttribute(Charset charset) {
        this.charset = charset;
    }

    @Override
    public final InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.InternalAttribute;
    }

    public final void addValue(String string) {
        ObjectUtil.checkNotNull((Object)string, (String)"value");
        string = Unpooled.copiedBuffer((CharSequence)string, (Charset)this.charset);
        this.value.add((ByteBuf)string);
        this.size += string.readableBytes();
    }

    public final void addValue(String string, int n) {
        ObjectUtil.checkNotNull((Object)string, (String)"value");
        string = Unpooled.copiedBuffer((CharSequence)string, (Charset)this.charset);
        this.value.add(n, (ByteBuf)string);
        this.size += string.readableBytes();
    }

    public final void setValue(String string, int n) {
        ObjectUtil.checkNotNull((Object)string, (String)"value");
        string = Unpooled.copiedBuffer((CharSequence)string, (Charset)this.charset);
        ByteBuf byteBuf = this.value.set(n, (ByteBuf)string);
        if (byteBuf != null) {
            this.size -= byteBuf.readableBytes();
            byteBuf.release();
        }
        this.size += string.readableBytes();
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof InternalAttribute)) {
            return false;
        }
        object = (InternalAttribute)object;
        return this.getName().equalsIgnoreCase(((InternalAttribute)object).getName());
    }

    @Override
    public final int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof InternalAttribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((InternalAttribute)interfaceHttpData);
    }

    @Override
    public final int compareTo(InternalAttribute internalAttribute) {
        return this.getName().compareToIgnoreCase(internalAttribute.getName());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ByteBuf byteBuf : this.value) {
            stringBuilder.append(byteBuf.toString(this.charset));
        }
        return stringBuilder.toString();
    }

    public final int size() {
        return this.size;
    }

    public final ByteBuf toByteBuf() {
        return Unpooled.compositeBuffer().addComponents(this.value).writerIndex(this.size()).readerIndex(0);
    }

    @Override
    public final String getName() {
        return "InternalAttribute";
    }

    protected final void deallocate() {
    }

    @Override
    public final InterfaceHttpData retain() {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.retain();
        }
        return this;
    }

    @Override
    public final InterfaceHttpData retain(int n) {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.retain(n);
        }
        return this;
    }

    @Override
    public final InterfaceHttpData touch() {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.touch();
        }
        return this;
    }

    @Override
    public final InterfaceHttpData touch(Object object) {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.touch(object);
        }
        return this;
    }
}

