/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final WebSocketDecoderConfig decoderConfig;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    protected WebSocketServerHandshaker(WebSocketVersion webSocketVersion, String string, String string2, int n) {
        this(webSocketVersion, string, string2, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n).build());
    }

    protected WebSocketServerHandshaker(WebSocketVersion stringArray, String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        this.version = stringArray;
        this.uri = string;
        if (string2 != null) {
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            this.subprotocols = stringArray;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.decoderConfig = (WebSocketDecoderConfig)ObjectUtil.checkNotNull((Object)webSocketDecoderConfig, (String)"decoderConfig");
    }

    public String uri() {
        return this.uri;
    }

    public Set<String> subprotocols() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Collections.addAll(linkedHashSet, this.subprotocols);
        return linkedHashSet;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.decoderConfig.maxFramePayloadLength();
    }

    public WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpRequest) {
        return this.handshake(channel, fullHttpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpMessage, HttpHeaders httpHeaders, ChannelPromise channelPromise) {
        Object object;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        fullHttpMessage = this.newHandshakeResponse((FullHttpRequest)fullHttpMessage, httpHeaders);
        httpHeaders = channel.pipeline();
        if (httpHeaders.get(HttpObjectAggregator.class) != null) {
            httpHeaders.remove(HttpObjectAggregator.class);
        }
        if (httpHeaders.get(HttpContentCompressor.class) != null) {
            httpHeaders.remove(HttpContentCompressor.class);
        }
        if ((object = httpHeaders.context(HttpRequestDecoder.class)) == null) {
            object = httpHeaders.context(HttpServerCodec.class);
            if (object == null) {
                channelPromise.setFailure((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
                fullHttpMessage.release();
                return channelPromise;
            }
            httpHeaders.addBefore(object.name(), "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
            httpHeaders.addBefore(object.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            object = object.name();
        } else {
            httpHeaders.replace(object.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            object = httpHeaders.context(HttpResponseEncoder.class).name();
            httpHeaders.addBefore((String)object, "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
        }
        channel.writeAndFlush((Object)fullHttpMessage).addListener((GenericFutureListener)new ChannelFutureListener((String)object, channelPromise){
            final /* synthetic */ String val$encoderName;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$encoderName = string;
                this.val$promise = channelPromise;
            }

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    channelFuture = channelFuture.channel().pipeline();
                    channelFuture.remove(this.val$encoderName);
                    this.val$promise.setSuccess();
                    return;
                }
                this.val$promise.setFailure(channelFuture.cause());
            }
        });
        return channelPromise;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest httpRequest) {
        return this.handshake(channel, httpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(final Channel channel, HttpRequest httpRequest, final HttpHeaders httpHeaders, final ChannelPromise channelPromise) {
        ChannelPipeline channelPipeline;
        ChannelHandlerContext channelHandlerContext;
        if (httpRequest instanceof FullHttpRequest) {
            return this.handshake(channel, (FullHttpRequest)httpRequest, httpHeaders, channelPromise);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        if ((channelHandlerContext = (channelPipeline = channel.pipeline()).context(HttpRequestDecoder.class)) == null && (channelHandlerContext = channelPipeline.context(HttpServerCodec.class)) == null) {
            channelPromise.setFailure((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
            return channelPromise;
        }
        String string = channelHandlerContext.name();
        if (HttpUtil.isContentLengthSet(httpRequest) || HttpUtil.isTransferEncodingChunked(httpRequest) || this.version == WebSocketVersion.V00) {
            string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, (ChannelHandler)new HttpObjectAggregator(8192));
        }
        channelPipeline.addAfter(string, "handshaker", (ChannelHandler)new ChannelInboundHandlerAdapter(){
            private FullHttpRequest fullHttpRequest;

            public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
                if (object instanceof HttpObject) {
                    try {
                        this.handleHandshakeRequest(channelHandlerContext, (HttpObject)object);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)object);
                    }
                } else {
                    super.channelRead(channelHandlerContext, object);
                }
            }

            public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
                channelPromise.tryFailure(throwable);
                channelHandlerContext.fireExceptionCaught(throwable);
            }

            public void channelInactive(ChannelHandlerContext channelHandlerContext) {
                try {
                    if (!channelPromise.isDone()) {
                        channelPromise.tryFailure((Throwable)new ClosedChannelException());
                    }
                    channelHandlerContext.fireChannelInactive();
                    return;
                }
                finally {
                    this.releaseFullHttpRequest();
                }
            }

            public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
                this.releaseFullHttpRequest();
            }

            private void handleHandshakeRequest(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                if (httpObject instanceof FullHttpRequest) {
                    channelHandlerContext.pipeline().remove((ChannelHandler)this);
                    WebSocketServerHandshaker.this.handshake(channel, (FullHttpRequest)httpObject, httpHeaders, channelPromise);
                    return;
                }
                if (httpObject instanceof LastHttpContent) {
                    assert (this.fullHttpRequest != null);
                    httpObject = this.fullHttpRequest;
                    this.fullHttpRequest = null;
                    try {
                        channelHandlerContext.pipeline().remove((ChannelHandler)this);
                        WebSocketServerHandshaker.this.handshake(channel, (FullHttpRequest)httpObject, httpHeaders, channelPromise);
                        return;
                    }
                    finally {
                        httpObject.release();
                    }
                }
                if (httpObject instanceof HttpRequest) {
                    httpObject = (HttpRequest)httpObject;
                    this.fullHttpRequest = new DefaultFullHttpRequest(httpObject.protocolVersion(), httpObject.method(), httpObject.uri(), Unpooled.EMPTY_BUFFER, httpObject.headers(), EmptyHttpHeaders.INSTANCE);
                    if (httpObject.decoderResult().isFailure()) {
                        this.fullHttpRequest.setDecoderResult(httpObject.decoderResult());
                    }
                }
            }

            private void releaseFullHttpRequest() {
                if (this.fullHttpRequest != null) {
                    this.fullHttpRequest.release();
                    this.fullHttpRequest = null;
                }
            }
        });
        try {
            channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain((Object)httpRequest));
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    protected abstract FullHttpResponse newHandshakeResponse(FullHttpRequest var1, HttpHeaders var2);

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return this.close0((ChannelOutboundInvoker)channel, closeWebSocketFrame, channelPromise);
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
        return this.close(channelHandlerContext, closeWebSocketFrame, channelHandlerContext.newPromise());
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
        return this.close0((ChannelOutboundInvoker)channelHandlerContext, closeWebSocketFrame, channelPromise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private ChannelFuture close0(ChannelOutboundInvoker channelOutboundInvoker, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channelOutboundInvoker.writeAndFlush((Object)closeWebSocketFrame, channelPromise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected String selectSubprotocol(String stringArray) {
        if (stringArray == null || this.subprotocols.length == 0) {
            return null;
        }
        String[] stringArray2 = stringArray.split(",");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            string = string.trim();
            String[] stringArray3 = this.subprotocols;
            int n2 = this.subprotocols.length;
            for (int j = 0; j < n2; ++j) {
                String string2 = stringArray3[j];
                if (!SUB_PROTOCOL_WILDCARD.equals(string2) && !string.equals(string2)) continue;
                this.selectedSubprotocol = string;
                return string;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();
}

