/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
extends DefaultSpdyStreamFrame
implements SpdyDataFrame {
    private final ByteBuf data;

    public DefaultSpdyDataFrame(int n) {
        this(n, Unpooled.buffer((int)0));
    }

    public DefaultSpdyDataFrame(int n, ByteBuf byteBuf) {
        super(n);
        this.data = DefaultSpdyDataFrame.validate((ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"data"));
    }

    private static ByteBuf validate(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        return byteBuf;
    }

    @Override
    public SpdyDataFrame setStreamId(int n) {
        super.setStreamId(n);
        return this;
    }

    @Override
    public SpdyDataFrame setLast(boolean bl) {
        super.setLast(bl);
        return this;
    }

    @Override
    public ByteBuf content() {
        return ByteBufUtil.ensureAccessible((ByteBuf)this.data);
    }

    @Override
    public SpdyDataFrame copy() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().copy());
    }

    @Override
    public SpdyDataFrame duplicate() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().duplicate());
    }

    @Override
    public SpdyDataFrame retainedDuplicate() {
        DefaultSpdyDataFrame defaultSpdyDataFrame = this;
        return defaultSpdyDataFrame.replace(defaultSpdyDataFrame.content().retainedDuplicate());
    }

    @Override
    public SpdyDataFrame replace(ByteBuf object) {
        object = new DefaultSpdyDataFrame(this.streamId(), (ByteBuf)object);
        object.setLast(this.isLast());
        return object;
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public SpdyDataFrame retain() {
        this.data.retain();
        return this;
    }

    @Override
    public SpdyDataFrame retain(int n) {
        this.data.retain(n);
        return this;
    }

    @Override
    public SpdyDataFrame touch() {
        this.data.touch();
        return this;
    }

    @Override
    public SpdyDataFrame touch(Object object) {
        this.data.touch(object);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int n) {
        return this.data.release(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append("(last: ").append(this.isLast()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE).append("--> Size = ");
        if (this.refCnt() == 0) {
            stringBuilder.append("(freed)");
        } else {
            stringBuilder.append(this.content().readableBytes());
        }
        return stringBuilder.toString();
    }
}

