/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.netty.handler.codec.spdy.SpdyFrameDecoderExtendedDelegate;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;

public class SpdyFrameDecoder {
    protected final SpdyFrameDecoderDelegate delegate;
    protected final int spdyVersion;
    private final int maxChunkSize;
    private int frameType;
    private State state;
    private byte flags;
    private int length;
    private int streamId;
    private int numSettings;

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate) {
        this(spdyVersion, spdyFrameDecoderDelegate, 8192);
    }

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate, int n) {
        this.spdyVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"spdyVersion"))).version();
        this.delegate = (SpdyFrameDecoderDelegate)ObjectUtil.checkNotNull((Object)spdyFrameDecoderDelegate, (String)"delegate");
        this.maxChunkSize = ObjectUtil.checkPositive((int)n, (String)"maxChunkSize");
        this.state = State.READ_COMMON_HEADER;
    }

    public void decode(ByteBuf byteBuf) {
        block17: while (true) {
            switch (this.state) {
                case READ_COMMON_HEADER: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int by = byteBuf.readerIndex();
                    int n = by + 4;
                    byte by2 = by + 5;
                    byteBuf.skipBytes(8);
                    int n2 = (byteBuf.getByte(by) & 0x80) != 0;
                    if (n2) {
                        n2 = SpdyCodecUtil.getUnsignedShort(byteBuf, by) & Short.MAX_VALUE;
                        this.frameType = SpdyCodecUtil.getUnsignedShort(byteBuf, by + 2);
                        this.streamId = 0;
                    } else {
                        n2 = this.spdyVersion;
                        this.frameType = 0;
                        this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, by);
                    }
                    this.flags = byteBuf.getByte(n);
                    this.length = SpdyCodecUtil.getUnsignedMedium(byteBuf, by2);
                    if (n2 != this.spdyVersion) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SPDY Version");
                        continue block17;
                    }
                    if (!SpdyFrameDecoder.isValidFrameHeader(this.streamId, this.frameType, this.flags, this.length)) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid Frame Error");
                        continue block17;
                    }
                    SpdyFrameDecoder spdyFrameDecoder = this;
                    if (spdyFrameDecoder.isValidUnknownFrameHeader(spdyFrameDecoder.streamId, this.frameType, this.flags, this.length)) {
                        this.state = State.READ_UNKNOWN_FRAME;
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder.getNextState(this.frameType, this.length);
                    continue block17;
                }
                case READ_DATA_FRAME: {
                    if (this.length == 0) {
                        this.state = State.READ_COMMON_HEADER;
                        this.delegate.readDataFrame(this.streamId, SpdyFrameDecoder.hasFlag(this.flags, (byte)1), Unpooled.buffer((int)0));
                        continue block17;
                    }
                    int by = Math.min(this.maxChunkSize, this.length);
                    if (byteBuf.readableBytes() < by) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(by);
                    this.length -= by;
                    if (this.length == 0) {
                        this.state = State.READ_COMMON_HEADER;
                    }
                    by = this.length == 0 && SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? (int)1 : 0;
                    this.delegate.readDataFrame(this.streamId, by != 0, byteBuf2);
                    continue block17;
                }
                case READ_SYN_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 10) {
                        return;
                    }
                    int by = byteBuf.readerIndex();
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, by);
                    int n = SpdyCodecUtil.getUnsignedInt(byteBuf, by + 4);
                    byte by2 = (byte)(byteBuf.getByte(by + 8) >> 5 & 7);
                    by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    int n2 = SpdyFrameDecoder.hasFlag(this.flags, (byte)2) ? 1 : 0;
                    byteBuf.skipBytes(10);
                    this.length -= 10;
                    if (this.streamId == 0) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_STREAM Frame");
                        continue block17;
                    }
                    this.state = State.READ_HEADER_BLOCK;
                    this.delegate.readSynStreamFrame(this.streamId, n, by2, by != 0, n2 != 0);
                    continue block17;
                }
                case READ_SYN_REPLY_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf2, byteBuf2.readerIndex());
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_REPLY Frame");
                        continue block17;
                    }
                    this.state = State.READ_HEADER_BLOCK;
                    this.delegate.readSynReplyFrame(this.streamId, by != 0);
                    continue block17;
                }
                case READ_RST_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf3 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf3, byteBuf3.readerIndex());
                    ByteBuf byteBuf4 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf4, byteBuf4.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (this.streamId == 0 || by == 0) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid RST_STREAM Frame");
                        continue block17;
                    }
                    this.state = State.READ_COMMON_HEADER;
                    this.delegate.readRstStreamFrame(this.streamId, by);
                    continue block17;
                }
                case READ_SETTINGS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    ByteBuf byteBuf5 = byteBuf;
                    this.numSettings = SpdyCodecUtil.getUnsignedInt(byteBuf5, byteBuf5.readerIndex());
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if ((this.length & 7) != 0 || this.length >> 3 != this.numSettings) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SETTINGS Frame");
                        continue block17;
                    }
                    this.state = State.READ_SETTING;
                    this.delegate.readSettingsFrame(by != 0);
                    continue block17;
                }
                case READ_SETTING: {
                    if (this.numSettings == 0) {
                        this.state = State.READ_COMMON_HEADER;
                        this.delegate.readSettingsEnd();
                        continue block17;
                    }
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf6 = byteBuf;
                    int by = byteBuf6.getByte(byteBuf6.readerIndex());
                    ByteBuf byteBuf7 = byteBuf;
                    int n = SpdyCodecUtil.getUnsignedMedium(byteBuf7, byteBuf7.readerIndex() + 1);
                    ByteBuf byteBuf8 = byteBuf;
                    byte by2 = SpdyCodecUtil.getSignedInt(byteBuf8, byteBuf8.readerIndex() + 4);
                    int n2 = SpdyFrameDecoder.hasFlag(by, (byte)1);
                    by = SpdyFrameDecoder.hasFlag(by, (byte)2) ? 1 : 0;
                    byteBuf.skipBytes(8);
                    --this.numSettings;
                    this.delegate.readSetting(n, by2, n2 != 0, by != 0);
                    continue block17;
                }
                case READ_PING_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf9 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf9, byteBuf9.readerIndex());
                    byteBuf.skipBytes(4);
                    this.state = State.READ_COMMON_HEADER;
                    this.delegate.readPingFrame(by);
                    continue block17;
                }
                case READ_GOAWAY_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf10 = byteBuf;
                    int n = SpdyCodecUtil.getUnsignedInt(byteBuf10, byteBuf10.readerIndex());
                    ByteBuf byteBuf11 = byteBuf;
                    int by = SpdyCodecUtil.getSignedInt(byteBuf11, byteBuf11.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    this.state = State.READ_COMMON_HEADER;
                    this.delegate.readGoAwayFrame(n, by);
                    continue block17;
                }
                case READ_HEADERS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    ByteBuf byteBuf12 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf12, byteBuf12.readerIndex());
                    int by = SpdyFrameDecoder.hasFlag(this.flags, (byte)1) ? 1 : 0;
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid HEADERS Frame");
                        continue block17;
                    }
                    this.state = State.READ_HEADER_BLOCK;
                    this.delegate.readHeadersFrame(this.streamId, by != 0);
                    continue block17;
                }
                case READ_WINDOW_UPDATE_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    ByteBuf byteBuf13 = byteBuf;
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf13, byteBuf13.readerIndex());
                    ByteBuf byteBuf14 = byteBuf;
                    int by = SpdyCodecUtil.getUnsignedInt(byteBuf14, byteBuf14.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (by == 0) {
                        this.state = State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid WINDOW_UPDATE Frame");
                        continue block17;
                    }
                    this.state = State.READ_COMMON_HEADER;
                    this.delegate.readWindowUpdateFrame(this.streamId, by);
                    continue block17;
                }
                case READ_UNKNOWN_FRAME: {
                    SpdyFrameDecoder spdyFrameDecoder = this;
                    if (spdyFrameDecoder.decodeUnknownFrame(spdyFrameDecoder.frameType, this.flags, this.length, byteBuf)) {
                        this.state = State.READ_COMMON_HEADER;
                        continue block17;
                    }
                    return;
                }
                case READ_HEADER_BLOCK: {
                    if (this.length == 0) {
                        this.state = State.READ_COMMON_HEADER;
                        this.delegate.readHeaderBlockEnd();
                        continue block17;
                    }
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    int by = Math.min(byteBuf.readableBytes(), this.length);
                    ByteBuf byteBuf16 = byteBuf.readRetainedSlice(by);
                    this.length -= by;
                    this.delegate.readHeaderBlock(byteBuf16);
                    continue block17;
                }
                case DISCARD_FRAME: {
                    int by = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(by);
                    this.length -= by;
                    if (this.length == 0) {
                        this.state = State.READ_COMMON_HEADER;
                        continue block17;
                    }
                    return;
                }
                case FRAME_ERROR: {
                    ByteBuf byteBuf15 = byteBuf;
                    byteBuf15.skipBytes(byteBuf15.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new Error("Shouldn't reach here.");
    }

    private static boolean hasFlag(byte by, byte by2) {
        return (by & by2) != 0;
    }

    private static State getNextState(int n, int n2) {
        switch (n) {
            case 0: {
                return State.READ_DATA_FRAME;
            }
            case 1: {
                return State.READ_SYN_STREAM_FRAME;
            }
            case 2: {
                return State.READ_SYN_REPLY_FRAME;
            }
            case 3: {
                return State.READ_RST_STREAM_FRAME;
            }
            case 4: {
                return State.READ_SETTINGS_FRAME;
            }
            case 6: {
                return State.READ_PING_FRAME;
            }
            case 7: {
                return State.READ_GOAWAY_FRAME;
            }
            case 8: {
                return State.READ_HEADERS_FRAME;
            }
            case 9: {
                return State.READ_WINDOW_UPDATE_FRAME;
            }
        }
        if (n2 != 0) {
            return State.DISCARD_FRAME;
        }
        return State.READ_COMMON_HEADER;
    }

    protected boolean decodeUnknownFrame(int n, byte by, int n2, ByteBuf byteBuf) {
        if (n2 == 0) {
            if (this.delegate instanceof SpdyFrameDecoderExtendedDelegate) {
                ((SpdyFrameDecoderExtendedDelegate)this.delegate).readUnknownFrame(n, by, Unpooled.EMPTY_BUFFER);
            }
            return true;
        }
        if (byteBuf.readableBytes() < n2) {
            return false;
        }
        if (this.delegate instanceof SpdyFrameDecoderExtendedDelegate) {
            ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
            ((SpdyFrameDecoderExtendedDelegate)this.delegate).readUnknownFrame(n, by, byteBuf2);
        } else {
            byteBuf.skipBytes(n2);
        }
        return true;
    }

    protected boolean isValidUnknownFrameHeader(int n, int n2, byte by, int n3) {
        return false;
    }

    private static boolean isValidFrameHeader(int n, int n2, byte by, int n3) {
        switch (n2) {
            case 0: {
                return n != 0;
            }
            case 1: {
                return n3 >= 10;
            }
            case 2: {
                return n3 >= 4;
            }
            case 3: {
                return by == 0 && n3 == 8;
            }
            case 4: {
                return n3 >= 4;
            }
            case 6: {
                return n3 == 4;
            }
            case 7: {
                return n3 == 8;
            }
            case 8: {
                return n3 >= 4;
            }
            case 9: {
                return n3 == 8;
            }
        }
        return true;
    }

    private static enum State {
        READ_COMMON_HEADER,
        READ_DATA_FRAME,
        READ_SYN_STREAM_FRAME,
        READ_SYN_REPLY_FRAME,
        READ_RST_STREAM_FRAME,
        READ_SETTINGS_FRAME,
        READ_SETTING,
        READ_PING_FRAME,
        READ_GOAWAY_FRAME,
        READ_HEADERS_FRAME,
        READ_WINDOW_UPDATE_FRAME,
        READ_UNKNOWN_FRAME,
        READ_HEADER_BLOCK,
        DISCARD_FRAME,
        FRAME_ERROR;

    }
}

