/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
extends MessageToMessageEncoder<HttpObject> {
    private int currentStreamId;
    private final boolean validateHeaders;
    private final boolean headersToLowerCase;

    public SpdyHttpEncoder(SpdyVersion spdyVersion) {
        this(spdyVersion, true, true);
    }

    public SpdyHttpEncoder(SpdyVersion spdyVersion, boolean bl, boolean bl2) {
        ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"version");
        this.headersToLowerCase = bl;
        this.validateHeaders = bl2;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        boolean bl = false;
        boolean bl2 = false;
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            list.add(spdySynStreamFrame);
            bl2 = spdySynStreamFrame.isLast() || spdySynStreamFrame.isUnidirectional();
            bl = true;
        }
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            SpdyHeadersFrame spdyHeadersFrame = this.createHeadersFrame(httpResponse);
            list.add(spdyHeadersFrame);
            bl2 = spdyHeadersFrame.isLast();
            bl = true;
        }
        if (httpObject instanceof HttpContent && !bl2) {
            Iterator<Map.Entry<CharSequence, CharSequence>> iterator = (HttpContent)httpObject;
            iterator.content().retain();
            DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(this.currentStreamId, iterator.content());
            if (iterator instanceof LastHttpContent) {
                iterator = (LastHttpContent)((Object)iterator);
                if (((HttpHeaders)((Object)(iterator = iterator.trailingHeaders()))).isEmpty()) {
                    defaultSpdyDataFrame.setLast(true);
                    list.add(defaultSpdyDataFrame);
                } else {
                    DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamId, this.validateHeaders);
                    defaultSpdyHeadersFrame.setLast(true);
                    iterator = ((HttpHeaders)((Object)iterator)).iteratorCharSequence();
                    while (iterator.hasNext()) {
                        Map.Entry<CharSequence, CharSequence> entry = iterator.next();
                        CharSequence charSequence = this.headersToLowerCase ? AsciiString.of((CharSequence)entry.getKey()).toLowerCase() : entry.getKey();
                        defaultSpdyHeadersFrame.headers().add(charSequence, entry.getValue());
                    }
                    list.add(defaultSpdyDataFrame);
                    list.add(defaultSpdyHeadersFrame);
                }
            } else {
                list.add(defaultSpdyDataFrame);
            }
            bl = true;
        }
        if (!bl) {
            throw new UnsupportedMessageTypeException((Object)httpObject, new Class[0]);
        }
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpRequest httpRequest) {
        Object object = httpRequest.headers();
        int n = ((HttpHeaders)object).getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        int n2 = ((HttpHeaders)object).getInt((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, 0);
        byte by = (byte)((HttpHeaders)object).getInt((CharSequence)SpdyHttpHeaders.Names.PRIORITY, 0);
        Object object2 = ((HttpHeaders)object).get((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        ((HttpHeaders)object).remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        ((HttpHeaders)object).remove((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID);
        ((HttpHeaders)object).remove((CharSequence)SpdyHttpHeaders.Names.PRIORITY);
        ((HttpHeaders)object).remove((CharSequence)SpdyHttpHeaders.Names.SCHEME);
        ((HttpHeaders)object).remove((CharSequence)HttpHeaderNames.CONNECTION);
        ((HttpHeaders)object).remove("Keep-Alive");
        ((HttpHeaders)object).remove("Proxy-Connection");
        ((HttpHeaders)object).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n, n2, by, this.validateHeaders);
        SpdyHeaders spdyHeaders = defaultSpdySynStreamFrame.headers();
        spdyHeaders.set(SpdyHeaders.HttpNames.METHOD, httpRequest.method().name());
        spdyHeaders.set(SpdyHeaders.HttpNames.PATH, httpRequest.uri());
        spdyHeaders.set(SpdyHeaders.HttpNames.VERSION, httpRequest.protocolVersion().text());
        CharSequence charSequence = ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.HOST);
        ((HttpHeaders)object).remove((CharSequence)HttpHeaderNames.HOST);
        spdyHeaders.set(SpdyHeaders.HttpNames.HOST, charSequence);
        if (object2 == null) {
            object2 = "https";
        }
        spdyHeaders.set(SpdyHeaders.HttpNames.SCHEME, object2);
        object = ((HttpHeaders)object).iteratorCharSequence();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            charSequence = this.headersToLowerCase ? AsciiString.of((CharSequence)((CharSequence)object2.getKey())).toLowerCase() : (CharSequence)object2.getKey();
            spdyHeaders.add(charSequence, object2.getValue());
        }
        this.currentStreamId = defaultSpdySynStreamFrame.streamId();
        if (n2 == 0) {
            defaultSpdySynStreamFrame.setLast(SpdyHttpEncoder.isLast(httpRequest));
        } else {
            defaultSpdySynStreamFrame.setUnidirectional(true);
        }
        return defaultSpdySynStreamFrame;
    }

    private SpdyHeadersFrame createHeadersFrame(HttpResponse httpResponse) {
        Object object = httpResponse.headers();
        int n = ((HttpHeaders)object).getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        ((HttpHeaders)object).remove((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
        ((HttpHeaders)object).remove((CharSequence)HttpHeaderNames.CONNECTION);
        ((HttpHeaders)object).remove("Keep-Alive");
        ((HttpHeaders)object).remove("Proxy-Connection");
        ((HttpHeaders)object).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = SpdyCodecUtil.isServerId(n) ? new DefaultSpdyHeadersFrame(n, this.validateHeaders) : new DefaultSpdySynReplyFrame(n, this.validateHeaders);
        Object object2 = defaultSpdyHeadersFrame.headers();
        object2.set((Object)SpdyHeaders.HttpNames.STATUS, (Object)httpResponse.status().codeAsText());
        object2.set((Object)SpdyHeaders.HttpNames.VERSION, (Object)httpResponse.protocolVersion().text());
        object = ((HttpHeaders)object).iteratorCharSequence();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            CharSequence charSequence = this.headersToLowerCase ? AsciiString.of((CharSequence)((CharSequence)object2.getKey())).toLowerCase() : (CharSequence)object2.getKey();
            defaultSpdyHeadersFrame.headers().add(charSequence, object2.getValue());
        }
        this.currentStreamId = n;
        defaultSpdyHeadersFrame.setLast(SpdyHttpEncoder.isLast(httpResponse));
        return defaultSpdyHeadersFrame;
    }

    private static boolean isLast(HttpMessage httpMessage) {
        return httpMessage instanceof FullHttpMessage && (httpMessage = (FullHttpMessage)httpMessage).trailingHeaders().isEmpty() && !httpMessage.content().isReadable();
    }
}

