/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2HeadersFrame
extends AbstractHttp2StreamFrame
implements Http2HeadersFrame {
    private final Http2Headers headers;
    private final boolean endStream;
    private final int padding;

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers) {
        this(http2Headers, false);
    }

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers, boolean bl) {
        this(http2Headers, bl, 0);
    }

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers, boolean bl, int n) {
        this.headers = (Http2Headers)ObjectUtil.checkNotNull((Object)http2Headers, (String)"headers");
        this.endStream = bl;
        Http2CodecUtil.verifyPadding(n);
        this.padding = n;
    }

    @Override
    public final DefaultHttp2HeadersFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public final String name() {
        return "HEADERS";
    }

    @Override
    public final Http2Headers headers() {
        return this.headers;
    }

    @Override
    public final boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public final int padding() {
        return this.padding;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(stream=" + this.stream() + ", headers=" + this.headers + ", endStream=" + this.endStream + ", padding=" + this.padding + ')';
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2HeadersFrame)) {
            return false;
        }
        return super.equals(object = (DefaultHttp2HeadersFrame)object) && this.headers.equals(((DefaultHttp2HeadersFrame)object).headers) && this.endStream == ((DefaultHttp2HeadersFrame)object).endStream && this.padding == ((DefaultHttp2HeadersFrame)object).padding;
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.headers.hashCode();
        n = n * 31 + (this.endStream ? 0 : 1);
        n = n * 31 + this.padding;
        return n;
    }
}

