/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2EmptyDataFrameConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

public class Http2FrameCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2FrameCodec, Http2FrameCodecBuilder> {
    private Http2FrameWriter frameWriter;

    protected Http2FrameCodecBuilder() {
    }

    Http2FrameCodecBuilder(boolean bl) {
        this.server(bl);
        this.gracefulShutdownTimeoutMillis(0L);
    }

    public static Http2FrameCodecBuilder forClient() {
        return new Http2FrameCodecBuilder(false);
    }

    public static Http2FrameCodecBuilder forServer() {
        return new Http2FrameCodecBuilder(true);
    }

    Http2FrameCodecBuilder frameWriter(Http2FrameWriter http2FrameWriter) {
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)http2FrameWriter, (String)"frameWriter");
        return this;
    }

    @Override
    public Http2Settings initialSettings() {
        return super.initialSettings();
    }

    @Override
    public Http2FrameCodecBuilder initialSettings(Http2Settings http2Settings) {
        return (Http2FrameCodecBuilder)super.initialSettings(http2Settings);
    }

    @Override
    public long gracefulShutdownTimeoutMillis() {
        return super.gracefulShutdownTimeoutMillis();
    }

    @Override
    public Http2FrameCodecBuilder gracefulShutdownTimeoutMillis(long l) {
        return (Http2FrameCodecBuilder)super.gracefulShutdownTimeoutMillis(l);
    }

    @Override
    public boolean isServer() {
        return super.isServer();
    }

    @Override
    public int maxReservedStreams() {
        return super.maxReservedStreams();
    }

    @Override
    public Http2FrameCodecBuilder maxReservedStreams(int n) {
        return (Http2FrameCodecBuilder)super.maxReservedStreams(n);
    }

    @Override
    public boolean isValidateHeaders() {
        return super.isValidateHeaders();
    }

    @Override
    public Http2FrameCodecBuilder validateHeaders(boolean bl) {
        return (Http2FrameCodecBuilder)super.validateHeaders(bl);
    }

    @Override
    public Http2FrameLogger frameLogger() {
        return super.frameLogger();
    }

    @Override
    public Http2FrameCodecBuilder frameLogger(Http2FrameLogger http2FrameLogger) {
        return (Http2FrameCodecBuilder)super.frameLogger(http2FrameLogger);
    }

    @Override
    public boolean encoderEnforceMaxConcurrentStreams() {
        return super.encoderEnforceMaxConcurrentStreams();
    }

    @Override
    public Http2FrameCodecBuilder encoderEnforceMaxConcurrentStreams(boolean bl) {
        return (Http2FrameCodecBuilder)super.encoderEnforceMaxConcurrentStreams(bl);
    }

    @Override
    public int encoderEnforceMaxQueuedControlFrames() {
        return super.encoderEnforceMaxQueuedControlFrames();
    }

    @Override
    public Http2FrameCodecBuilder encoderEnforceMaxQueuedControlFrames(int n) {
        return (Http2FrameCodecBuilder)super.encoderEnforceMaxQueuedControlFrames(n);
    }

    @Override
    public Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector() {
        return super.headerSensitivityDetector();
    }

    @Override
    public Http2FrameCodecBuilder headerSensitivityDetector(Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        return (Http2FrameCodecBuilder)super.headerSensitivityDetector(sensitivityDetector);
    }

    @Override
    public Http2FrameCodecBuilder encoderIgnoreMaxHeaderListSize(boolean bl) {
        return (Http2FrameCodecBuilder)super.encoderIgnoreMaxHeaderListSize(bl);
    }

    @Override
    @Deprecated
    public Http2FrameCodecBuilder initialHuffmanDecodeCapacity(int n) {
        return (Http2FrameCodecBuilder)super.initialHuffmanDecodeCapacity(n);
    }

    @Override
    public Http2FrameCodecBuilder autoAckSettingsFrame(boolean bl) {
        return (Http2FrameCodecBuilder)super.autoAckSettingsFrame(bl);
    }

    @Override
    public Http2FrameCodecBuilder autoAckPingFrame(boolean bl) {
        return (Http2FrameCodecBuilder)super.autoAckPingFrame(bl);
    }

    @Override
    public Http2FrameCodecBuilder decoupleCloseAndGoAway(boolean bl) {
        return (Http2FrameCodecBuilder)super.decoupleCloseAndGoAway(bl);
    }

    @Override
    public Http2FrameCodecBuilder flushPreface(boolean bl) {
        return (Http2FrameCodecBuilder)super.flushPreface(bl);
    }

    @Override
    public int decoderEnforceMaxConsecutiveEmptyDataFrames() {
        return super.decoderEnforceMaxConsecutiveEmptyDataFrames();
    }

    @Override
    public Http2FrameCodecBuilder decoderEnforceMaxConsecutiveEmptyDataFrames(int n) {
        return (Http2FrameCodecBuilder)super.decoderEnforceMaxConsecutiveEmptyDataFrames(n);
    }

    @Override
    public Http2FrameCodecBuilder decoderEnforceMaxRstFramesPerWindow(int n, int n2) {
        return (Http2FrameCodecBuilder)super.decoderEnforceMaxRstFramesPerWindow(n, n2);
    }

    @Override
    public Http2FrameCodec build() {
        Http2FrameWriter http2FrameWriter = this.frameWriter;
        if (http2FrameWriter != null) {
            Object object = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
            Object object2 = this.initialSettings().maxHeaderListSize();
            object2 = new DefaultHttp2FrameReader(object2 == null ? new DefaultHttp2HeadersDecoder(this.isValidateHeaders()) : new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), (Long)object2));
            if (this.frameLogger() != null) {
                http2FrameWriter = new Http2OutboundFrameLogger(http2FrameWriter, this.frameLogger());
                object2 = new Http2InboundFrameLogger((Http2FrameReader)object2, this.frameLogger());
            }
            http2FrameWriter = new DefaultHttp2ConnectionEncoder((Http2Connection)object, http2FrameWriter);
            if (this.encoderEnforceMaxConcurrentStreams()) {
                http2FrameWriter = new StreamBufferingEncoder((Http2ConnectionEncoder)http2FrameWriter);
            }
            object = new DefaultHttp2ConnectionDecoder((Http2Connection)object, (Http2ConnectionEncoder)http2FrameWriter, (Http2FrameReader)object2, this.promisedRequestVerifier(), this.isAutoAckSettingsFrame(), this.isAutoAckPingFrame(), this.isValidateHeaders());
            int n = this.decoderEnforceMaxConsecutiveEmptyDataFrames();
            if (n > 0) {
                object = new Http2EmptyDataFrameConnectionDecoder((Http2ConnectionDecoder)object, n);
            }
            return this.build((Http2ConnectionDecoder)object, (Http2ConnectionEncoder)http2FrameWriter, this.initialSettings());
        }
        return (Http2FrameCodec)super.build();
    }

    @Override
    protected Http2FrameCodec build(Http2ConnectionDecoder object, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        object = new Http2FrameCodec(http2ConnectionEncoder, (Http2ConnectionDecoder)object, http2Settings, this.decoupleCloseAndGoAway(), this.flushPreface());
        ((Http2ConnectionHandler)object).gracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis());
        return object;
    }
}

