/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.extensions;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.core.ByteReadPacketKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.t;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u001a-\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\u00020\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0015\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\bH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a#\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\"\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"", "hashValue", "signValue", "", "oidValue", "Lio/ktor/network/tls/extensions/HashAndSign;", "HashAndSign", "(BBLjava/lang/String;)Lio/ktor/network/tls/extensions/HashAndSign;", "Lkotlinx/io/Source;", "", "parseSignatureAlgorithms", "(Lkotlinx/io/Source;)Ljava/util/List;", "readHashAndSign", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/extensions/HashAndSign;", "Lio/ktor/network/tls/extensions/HashAndSign$Companion;", "hash", "sign", "byCode", "(Lio/ktor/network/tls/extensions/HashAndSign$Companion;BB)Lio/ktor/network/tls/extensions/HashAndSign;", "SupportedSignatureAlgorithms", "Ljava/util/List;", "getSupportedSignatureAlgorithms", "()Ljava/util/List;", "ktor-network-tls"})
public final class SignatureAlgorithmKt {
    private static final List<HashAndSign> SupportedSignatureAlgorithms;

    public static final HashAndSign HashAndSign(byte by, byte by2, String object) {
        OID oID;
        HashAlgorithm hashAlgorithm = HashAlgorithm.Companion.byCode(by);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.byCode(by2);
        if (signatureAlgorithm == null) {
            return null;
        }
        SignatureAlgorithm signatureAlgorithm2 = signatureAlgorithm;
        String string = object;
        if (string != null) {
            object = string;
            oID = new OID((String)object);
        } else {
            oID = null;
        }
        object = oID;
        return new HashAndSign(hashAlgorithm, signatureAlgorithm2, (OID)object);
    }

    public static /* synthetic */ HashAndSign HashAndSign$default(byte by, byte by2, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        return SignatureAlgorithmKt.HashAndSign(by, by2, string);
    }

    public static final List<HashAndSign> getSupportedSignatureAlgorithms() {
        return SupportedSignatureAlgorithms;
    }

    public static final List<HashAndSign> parseSignatureAlgorithms(t t2) {
        Intrinsics.checkNotNullParameter((Object)t2, (String)"");
        int n2 = t2.g() & 0xFFFF;
        List list = new ArrayList();
        while (ByteReadPacketKt.getRemaining((t)t2) > 0L) {
            Collection collection = list;
            HashAndSign hashAndSign = SignatureAlgorithmKt.readHashAndSign(t2);
            if (hashAndSign == null) continue;
            collection.add(hashAndSign);
        }
        if ((int)ByteReadPacketKt.getRemaining((t)t2) != n2) {
            throw new TLSException("Invalid hash and sign packet size: expected " + n2 + ", actual " + list.size(), null, 2, null);
        }
        return list;
    }

    public static final HashAndSign readHashAndSign(t t2) {
        Intrinsics.checkNotNullParameter((Object)t2, (String)"");
        byte by = t2.f();
        byte by2 = t2.f();
        return SignatureAlgorithmKt.byCode(HashAndSign.Companion, by, by2);
    }

    public static final HashAndSign byCode(HashAndSign.Companion iterator, byte by, byte by2) {
        HashAndSign hashAndSign;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"");
            if (!(by2 != SignatureAlgorithm.ANON.getCode())) {
                iterator = "Anonymous signature not allowed.";
                throw new IllegalStateException(iterator.toString());
            }
            iterator = SupportedSignatureAlgorithms;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                HashAndSign hashAndSign2 = (HashAndSign)t2;
                if (!(hashAndSign2.getHash().getCode() == by && hashAndSign2.getSign().getCode() == by2)) continue;
                v0 = t2;
                break block3;
            }
            v0 = null;
        }
        if ((hashAndSign = (HashAndSign)v0) == null) {
            hashAndSign = SignatureAlgorithmKt.HashAndSign$default(by, by2, null, 4, null);
        }
        return hashAndSign;
    }

    static {
        Object[] objectArray = new HashAndSign[6];
        Object[] objectArray2 = objectArray;
        objectArray[0] = new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA384Encryption());
        objectArray2[1] = new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA256Encryption());
        objectArray2[2] = new HashAndSign(HashAlgorithm.SHA512, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA512Encryption());
        objectArray2[3] = new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA384Encryption());
        objectArray2[4] = new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA256Encryption());
        objectArray2[5] = new HashAndSign(HashAlgorithm.SHA1, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA1Encryption());
        SupportedSignatureAlgorithms = CollectionsKt.listOf((Object[])objectArray2);
    }
}

