/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.Span;
import org.nibor.autolink.internal.EmailScanner;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.SpanImpl;
import org.nibor.autolink.internal.UrlScanner;
import org.nibor.autolink.internal.WwwScanner;

public class LinkExtractor {
    private final Scanner urlScanner;
    private final Scanner wwwScanner;
    private final Scanner emailScanner;

    private LinkExtractor(UrlScanner urlScanner, WwwScanner wwwScanner, EmailScanner emailScanner) {
        this.urlScanner = urlScanner;
        this.wwwScanner = wwwScanner;
        this.emailScanner = emailScanner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Iterable<LinkSpan> extractLinks(final CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("input must not be null");
        }
        return new Iterable<LinkSpan>(){

            @Override
            public Iterator<LinkSpan> iterator() {
                return new LinkIterator(charSequence);
            }
        };
    }

    public Iterable<Span> extractSpans(final CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("input must not be null");
        }
        return new Iterable<Span>(){

            @Override
            public Iterator<Span> iterator() {
                return new SpanIterator(charSequence, new LinkIterator(charSequence));
            }
        };
    }

    private Scanner trigger(char c) {
        switch (c) {
            case ':': {
                return this.urlScanner;
            }
            case '@': {
                return this.emailScanner;
            }
            case 'w': {
                return this.wwwScanner;
            }
        }
        return null;
    }

    private class SpanIterator
    implements Iterator<Span> {
        private final CharSequence input;
        private final LinkIterator linkIterator;
        private int index = 0;
        private LinkSpan nextLink = null;

        public SpanIterator(CharSequence charSequence, LinkIterator linkIterator) {
            this.input = charSequence;
            this.linkIterator = linkIterator;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.input.length();
        }

        private Span nextTextSpan(int n) {
            SpanImpl spanImpl = new SpanImpl(this.index, n);
            this.index = n;
            return spanImpl;
        }

        @Override
        public Span next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextLink == null) {
                if (this.linkIterator.hasNext()) {
                    this.nextLink = this.linkIterator.next();
                } else {
                    SpanIterator spanIterator = this;
                    return spanIterator.nextTextSpan(spanIterator.input.length());
                }
            }
            if (this.index < this.nextLink.getBeginIndex()) {
                SpanIterator spanIterator = this;
                return spanIterator.nextTextSpan(spanIterator.nextLink.getBeginIndex());
            }
            LinkSpan linkSpan = this.nextLink;
            this.index = this.nextLink.getEndIndex();
            this.nextLink = null;
            return linkSpan;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class LinkIterator
    implements Iterator<LinkSpan> {
        private final CharSequence input;
        private LinkSpan next = null;
        private int index = 0;
        private int rewindIndex = 0;

        public LinkIterator(CharSequence charSequence) {
            this.input = charSequence;
        }

        @Override
        public boolean hasNext() {
            this.setNext();
            return this.next != null;
        }

        @Override
        public LinkSpan next() {
            if (this.hasNext()) {
                LinkSpan linkSpan = this.next;
                this.next = null;
                return linkSpan;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void setNext() {
            if (this.next != null) {
                return;
            }
            int n = this.input.length();
            while (this.index < n) {
                Object object = LinkExtractor.this.trigger(this.input.charAt(this.index));
                if (object != null) {
                    if ((object = object.scan(this.input, this.index, this.rewindIndex)) != null) {
                        this.next = object;
                        this.rewindIndex = this.index = object.getEndIndex();
                        return;
                    }
                    ++this.index;
                    continue;
                }
                ++this.index;
            }
        }
    }

    public static class Builder {
        private Set<LinkType> linkTypes = EnumSet.allOf(LinkType.class);
        private boolean emailDomainMustHaveDot = true;

        private Builder() {
        }

        public Builder linkTypes(Set<LinkType> set) {
            if (set == null) {
                throw new NullPointerException("linkTypes must not be null");
            }
            this.linkTypes = new HashSet<LinkType>(set);
            return this;
        }

        public Builder emailDomainMustHaveDot(boolean bl) {
            this.emailDomainMustHaveDot = bl;
            return this;
        }

        public LinkExtractor build() {
            UrlScanner urlScanner = this.linkTypes.contains((Object)LinkType.URL) ? new UrlScanner() : null;
            WwwScanner wwwScanner = this.linkTypes.contains((Object)LinkType.WWW) ? new WwwScanner() : null;
            EmailScanner emailScanner = this.linkTypes.contains((Object)LinkType.EMAIL) ? new EmailScanner(this.emailDomainMustHaveDot) : null;
            return new LinkExtractor(urlScanner, wwwScanner, emailScanner);
        }
    }
}

