/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Vec3f;

public final class Source {
    private int sourceID;
    private Buffer buffer;

    public Source() {
        this.sourceID = -1;
    }

    public Source(int n) {
        this.sourceID = n;
    }

    public final boolean create() {
        if (this.isValid()) {
            return false;
        }
        int[] nArray = new int[]{-1};
        AudioSystem3D.al.alGenSources(1, nArray, 0);
        if (0 <= nArray[0] && AudioSystem3D.al.alIsSource(nArray[0])) {
            this.sourceID = nArray[0];
            return true;
        }
        this.sourceID = -1;
        return false;
    }

    public final int getID() {
        return this.sourceID;
    }

    public final boolean isValid() {
        return this.sourceID >= 0 && AudioSystem3D.al.alIsSource(this.sourceID);
    }

    public final void delete() {
        if (this.sourceID >= 0) {
            Buffer buffer = this.buffer;
            this.stop();
            if (buffer != null) {
                this.setBuffer(null);
            }
            AudioSystem3D.al.alDeleteSources(1, new int[]{this.sourceID}, 0);
            if (buffer != null) {
                buffer.delete();
            }
            this.sourceID = -1;
            return;
        }
        if (this.buffer != null) {
            this.buffer.delete();
            this.buffer = null;
        }
    }

    public final void play() {
        AudioSystem3D.al.alSourcePlay(this.sourceID);
    }

    public final void pause() {
        AudioSystem3D.al.alSourcePause(this.sourceID);
    }

    public final void stop() {
        AudioSystem3D.al.alSourceStop(this.sourceID);
    }

    public final void rewind() {
        AudioSystem3D.al.alSourceRewind(this.sourceID);
    }

    public final boolean isPlaying() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetSourcei(this.sourceID, 4112, nArray, 0);
        return nArray[0] == 4114;
    }

    public final void setPitch(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4099, f);
    }

    public final float getPitch() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4099, fArray, 0);
        return fArray[0];
    }

    public final void setGain(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4106, f);
    }

    public final float getGain() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4106, fArray, 0);
        return fArray[0];
    }

    public final void setMaxDistance(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4131, f);
    }

    public final float getMaxDistance() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4131, fArray, 0);
        return fArray[0];
    }

    public final void setRolloffFactor(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4129, f);
    }

    public final float getRolloffFactor() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4129, fArray, 0);
        return fArray[0];
    }

    public final void setReferenceDistance(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4128, f);
    }

    public final float getReferenceDistance() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4128, fArray, 0);
        return fArray[0];
    }

    public final void setMinGain(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4109, f);
    }

    public final float getMinGain() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4109, fArray, 0);
        return fArray[0];
    }

    public final void setMaxGain(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4110, f);
    }

    public final float getMaxGain() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4110, fArray, 0);
        return fArray[0];
    }

    public final void setConeOuterGain(float f) {
        AudioSystem3D.al.alSourcef(this.sourceID, 4130, f);
    }

    public final float getConeOuterGain() {
        float[] fArray = new float[1];
        AudioSystem3D.al.alGetSourcef(this.sourceID, 4130, fArray, 0);
        return fArray[0];
    }

    public final void setPosition(Vec3f vec3f) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4100, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public final void setPosition(float f, float f2, float f3) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4100, f, f2, f3);
    }

    public final Vec3f getPosition() {
        Object object = new float[3];
        AudioSystem3D.al.alGetSourcefv(this.sourceID, 4100, (float[])object, 0);
        Vec3f vec3f = new Vec3f(object[0], object[1], object[2]);
        object = vec3f;
        return vec3f;
    }

    public final void setVelocity(Vec3f vec3f) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4102, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public final void setVelocity(float f, float f2, float f3) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4102, f, f2, f3);
    }

    public final Vec3f getVelocity() {
        Object object = new float[3];
        AudioSystem3D.al.alGetSourcefv(this.sourceID, 4102, (float[])object, 0);
        Vec3f vec3f = new Vec3f(object[0], object[1], object[2]);
        object = vec3f;
        return vec3f;
    }

    public final void setDirection(Vec3f vec3f) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4101, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public final void setDirection(float f, float f2, float f3) {
        AudioSystem3D.al.alSource3f(this.sourceID, 4101, f, f2, f3);
    }

    public final Vec3f getDirection() {
        Object object = new float[3];
        AudioSystem3D.al.alGetSourcefv(this.sourceID, 4101, (float[])object, 0);
        Vec3f vec3f = new Vec3f(object[0], object[1], object[2]);
        object = vec3f;
        return vec3f;
    }

    public final void setSourceRelative(boolean bl) {
        bl = bl;
        AudioSystem3D.al.alSourcei(this.sourceID, 514, bl ? 1 : 0);
    }

    public final boolean isSourceRelative() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetSourcei(this.sourceID, 514, nArray, 0);
        return nArray[0] == 1;
    }

    public final void setLooping(boolean bl) {
        bl = bl;
        AudioSystem3D.al.alSourcei(this.sourceID, 4103, bl ? 1 : 0);
    }

    public final boolean getLooping() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetSourcei(this.sourceID, 4103, nArray, 0);
        return nArray[0] == 1;
    }

    public final int getBuffersQueued() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetSourcei(this.sourceID, 4117, nArray, 0);
        AudioSystem3D.checkALError("Query AL_BUFFERS_QUEUED", true, true);
        return nArray[0];
    }

    public final int getBuffersProcessed() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetSourcei(this.sourceID, 4118, nArray, 0);
        AudioSystem3D.checkALError("Query AL_BUFFERS_PROCESSED", true, true);
        return nArray[0];
    }

    public final void setBuffer(Buffer buffer) {
        if (buffer != null) {
            AudioSystem3D.al.alSourcei(this.sourceID, 4105, buffer.getID());
        } else {
            AudioSystem3D.al.alSourcei(this.sourceID, 4105, 0);
        }
        this.buffer = buffer;
    }

    public final Buffer getBuffer() {
        return this.buffer;
    }

    public final void queueBuffers(Buffer[] bufferArray) {
        int n = bufferArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bufferArray[i].getID();
        }
        AudioSystem3D.al.alSourceQueueBuffers(this.sourceID, n, nArray, 0);
        AudioSystem3D.checkALError("alSourceQueueBuffers", true, true);
    }

    public final void queueBuffers(int[] nArray) {
        AudioSystem3D.al.alSourceQueueBuffers(this.sourceID, nArray.length, nArray, 0);
        AudioSystem3D.checkALError("alSourceQueueBuffers", true, true);
    }

    public final void unqueueBuffers(Buffer[] bufferArray) {
        int n = bufferArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bufferArray[i].getID();
        }
        AudioSystem3D.al.alSourceUnqueueBuffers(this.sourceID, n, nArray, 0);
        AudioSystem3D.checkALError("alSourceUnqueueBuffers", true, true);
    }

    public final void unqueueBuffers(int[] nArray) {
        AudioSystem3D.al.alSourceUnqueueBuffers(this.sourceID, nArray.length, nArray, 0);
        AudioSystem3D.checkALError("alSourceUnqueueBuffers", true, true);
    }

    public final String toString() {
        return "ALSource[id " + this.sourceID + ", buffer " + this.buffer + "]";
    }
}

