/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.CoreFriendModuleApi;

@CoreFriendModuleApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/internal/ElementMarker;", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "readIfAbsent", "Lkotlin/Function2;", "", "", "<init>", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function2;)V", "lowerMarks", "", "highMarksArray", "", "mark", "", "index", "nextUnmarkedIndex", "prepareHighMarksArray", "elementsCount", "markHigh", "nextUnmarkedHighIndex", "Companion", "kotlinx-serialization-core"})
public final class ElementMarker {
    private static final Companion Companion = new Companion(null);
    private final SerialDescriptor descriptor;
    private final Function2<SerialDescriptor, Integer, Boolean> readIfAbsent;
    private long lowerMarks;
    private final long[] highMarksArray;
    private static final long[] EMPTY_HIGH_MARKS = new long[0];

    public ElementMarker(SerialDescriptor serialDescriptor, Function2<? super SerialDescriptor, ? super Integer, Boolean> function2) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        this.descriptor = serialDescriptor;
        this.readIfAbsent = function2;
        int n = this.descriptor.getElementsCount();
        if (n <= 64) {
            this.lowerMarks = n == 64 ? 0L : -1L << n;
            this.highMarksArray = EMPTY_HIGH_MARKS;
            return;
        }
        this.lowerMarks = 0L;
        this.highMarksArray = this.prepareHighMarksArray(n);
    }

    public final void mark(int n) {
        if (n < 64) {
            this.lowerMarks |= 1L << n;
            return;
        }
        this.markHigh(n);
    }

    public final int nextUnmarkedIndex() {
        int n = this.descriptor.getElementsCount();
        while (this.lowerMarks != -1L) {
            int n2 = Long.numberOfTrailingZeros(this.lowerMarks ^ 0xFFFFFFFFFFFFFFFFL);
            this.lowerMarks |= 1L << n2;
            if (!((Boolean)this.readIfAbsent.invoke((Object)this.descriptor, (Object)n2)).booleanValue()) continue;
            return n2;
        }
        if (n > 64) {
            return this.nextUnmarkedHighIndex();
        }
        return -1;
    }

    private final long[] prepareHighMarksArray(int n) {
        int n2 = n - 1 >>> 6;
        int n3 = n & 0x3F;
        long[] lArray = new long[n2];
        if (n3 != 0) {
            lArray[ArraysKt.getLastIndex((long[])lArray)] = -1L << n;
        }
        return lArray;
    }

    private final void markHigh(int n) {
        int n2 = (n >>> 6) - 1;
        this.highMarksArray[n2] = this.highMarksArray[n2] | 1L << (n &= 0x3F);
    }

    private final int nextUnmarkedHighIndex() {
        int n = this.highMarksArray.length;
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            int n3 = i + 1 << 6;
            for (l = this.highMarksArray[i]; l != -1L; l |= 1L << n2) {
                n2 = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                if (!((Boolean)this.readIfAbsent.invoke((Object)this.descriptor, (Object)(n2 = n3 + n2))).booleanValue()) continue;
                this.highMarksArray[i] = l;
                return n2;
            }
            this.highMarksArray[i] = l;
        }
        return -1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/internal/ElementMarker$Companion;", "", "<init>", "()V", "EMPTY_HIGH_MARKS", "", "kotlinx-serialization-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

