/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.av;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public final class JavaSoundAudioSink
implements AudioSink {
    public static final int BUFFER_SIZE = 1000;
    public static final int SAMPLES_PER_BUFFER = 500;
    private static final boolean staticAvailable;
    private javax.sound.sampled.AudioFormat format;
    private DataLine.Info info;
    private SourceDataLine auline;
    private int bufferCount;
    private final byte[] sampleData = new byte[1000];
    private boolean available = false;
    private final AudioFormat nativeFormat;
    private int userMaxChannels = 8;
    private AudioFormat preferredFormat = null;
    private AudioFormat chosenFormat = null;
    private volatile boolean playRequested = false;
    private float volume = 1.0f;

    public JavaSoundAudioSink() {
        if (!staticAvailable) {
            this.nativeFormat = DefaultFormat;
            return;
        }
        this.preferredFormat = this.nativeFormat = new AudioFormat(JavaSoundAudioSink.DefaultFormat.sampleRate, JavaSoundAudioSink.DefaultFormat.sampleSize, this.getMaxSupportedChannels(), JavaSoundAudioSink.DefaultFormat.signed, JavaSoundAudioSink.DefaultFormat.fixedP, JavaSoundAudioSink.DefaultFormat.planar, JavaSoundAudioSink.DefaultFormat.littleEndian);
        this.available = true;
    }

    @Override
    public final boolean makeCurrent(boolean bl) {
        return true;
    }

    @Override
    public final boolean release(boolean bl) {
        return true;
    }

    public final String toString() {
        return "JavaSoundSink[avail " + this.available + ", dataLine " + this.info + ", source " + this.auline + ", bufferCount " + this.bufferCount + ", chosen " + this.chosenFormat + ", jsFormat " + this.format;
    }

    @Override
    public final float getPlaySpeed() {
        return 1.0f;
    }

    @Override
    public final boolean setPlaySpeed(float f) {
        return false;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    @Override
    public final boolean setVolume(float f) {
        this.volume = f;
        return true;
    }

    @Override
    public final int getSourceCount() {
        return -1;
    }

    @Override
    public final float getDefaultLatency() {
        return 0.02f;
    }

    @Override
    public final float getLatency() {
        return 0.02f;
    }

    @Override
    public final AudioFormat getNativeFormat() {
        return this.nativeFormat;
    }

    @Override
    public final AudioFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public final void setChannelLimit(int n) {
        this.userMaxChannels = Math.min(8, Math.max(1, n));
        this.preferredFormat = new AudioFormat(this.nativeFormat.sampleRate, this.nativeFormat.sampleSize, this.getMaxSupportedChannels(), this.nativeFormat.signed, this.nativeFormat.fixedP, this.nativeFormat.planar, this.nativeFormat.littleEndian);
        if (DEBUG) {
            System.out.println("ALAudioSink: channelLimit " + this.userMaxChannels + ", preferredFormat " + this.preferredFormat);
        }
    }

    private final int getMaxSupportedChannels() {
        return Math.min(this.userMaxChannels, 2);
    }

    @Override
    public final boolean isSupported(AudioFormat audioFormat) {
        return audioFormat.planar == this.preferredFormat.planar && audioFormat.fixedP == this.preferredFormat.fixedP && audioFormat.sampleRate <= this.preferredFormat.sampleRate && audioFormat.channelCount <= this.preferredFormat.channelCount;
    }

    @Override
    public final boolean init(AudioFormat audioFormat, int n, int n2, int n3, int n4) {
        if (!staticAvailable) {
            return false;
        }
        if (!this.isSupported(audioFormat)) {
            return false;
        }
        this.format = new javax.sound.sampled.AudioFormat(audioFormat.sampleRate, audioFormat.sampleSize, audioFormat.channelCount, audioFormat.signed, !audioFormat.littleEndian);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        Arrays.fill(this.sampleData, (byte)0);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(this.info);
            this.auline.open(this.format);
            this.auline.start();
            System.out.println("JavaSound audio sink");
            this.available = true;
            this.chosenFormat = audioFormat;
        }
        catch (Exception exception) {
            this.available = false;
        }
        return true;
    }

    @Override
    public final AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    @Override
    public final boolean isPlaying() {
        return this.playRequested && this.auline.isRunning();
    }

    @Override
    public final void play() {
        if (this.auline != null) {
            this.playRequested = true;
            this.playImpl();
        }
    }

    private void playImpl() {
        if (this.playRequested && !this.auline.isRunning()) {
            this.auline.start();
        }
    }

    @Override
    public final void pause() {
        if (this.auline != null) {
            this.playRequested = false;
            this.auline.stop();
        }
    }

    @Override
    public final void flush() {
        if (this.auline != null) {
            this.playRequested = false;
            this.auline.stop();
            this.auline.flush();
        }
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return 0;
    }

    @Override
    public final int getFrameCount() {
        return 1;
    }

    @Override
    public final int getQueuedFrameCount() {
        return 0;
    }

    @Override
    public final boolean isAvailable() {
        return this.available;
    }

    @Override
    public final void destroy() {
        this.available = false;
        this.chosenFormat = null;
    }

    @Override
    public final AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.get(byArray, 0, n2);
        byteBuffer.position(n3);
        n3 = 0;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = this.auline.write(byArray, n3, n2);
            n4 -= n5;
            n3 += n5;
        }
        this.playImpl();
        return new AudioSink.AudioDataFrame(n, Math.round(1000.0f * this.chosenFormat.getBytesDuration(n2)), byteBuffer, n2);
    }

    @Override
    public final int getQueuedByteCount() {
        return this.auline.getBufferSize() - this.auline.available();
    }

    @Override
    public final int getFreeFrameCount() {
        return this.auline.available();
    }

    @Override
    public final float getQueuedTime() {
        return this.chosenFormat.getBytesDuration(this.getQueuedByteCount());
    }

    @Override
    public final float getAvgFrameDuration() {
        return 0.0f;
    }

    @Override
    public final int getPTS() {
        return 0;
    }

    static {
        boolean bl = false;
        try {
            bl = AudioSystem.getAudioFileTypes().length > 0;
        }
        catch (Throwable throwable) {}
        staticAvailable = bl;
    }
}

