/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class LockDebugUtil {
    private static final ThreadLocal<ArrayList<Throwable>> tlsLockedStacks;
    private static final List<Throwable> dummy;

    public static List<Throwable> getRecursiveLockTrace() {
        if (Lock.DEBUG) {
            ArrayList<Throwable> arrayList = tlsLockedStacks.get();
            if (arrayList == null) {
                arrayList = new ArrayList();
                tlsLockedStacks.set(arrayList);
            }
            return arrayList;
        }
        return dummy;
    }

    public static void dumpRecursiveLockTrace(PrintStream printStream) {
        Object object;
        if (Lock.DEBUG && (object = LockDebugUtil.getRecursiveLockTrace()) != null && object.size() > 0) {
            int n = 0;
            printStream.println("TLSLockedStacks: locks " + object.size());
            object = object.iterator();
            while (object.hasNext()) {
                printStream.print(n + ": ");
                ((Throwable)object.next()).printStackTrace(printStream);
                ++n;
            }
        }
    }

    static {
        if (Lock.DEBUG) {
            tlsLockedStacks = new ThreadLocal();
            dummy = null;
        } else {
            tlsLockedStacks = null;
            dummy = new ArrayList<Throwable>(0);
        }
    }
}

