/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.Date;
import java.util.Arrays;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;
import org.sqlite.jdbc3.JDBC3Connection;
import org.sqlite.jdbc3.JDBC3Statement;
import org.sqlite.jdbc4.JDBC4Statement;

public abstract class CorePreparedStatement
extends JDBC4Statement {
    protected int columnCount;
    protected int paramCount;
    protected int batchQueryCount;

    protected CorePreparedStatement(SQLiteConnection object, String string) {
        super((SQLiteConnection)object);
        this.sql = string;
        object = ((SQLiteConnection)object).getDatabase();
        ((DB)object).prepare(this);
        this.rs.colsMeta = this.pointer.safeRun(DB::column_names);
        this.columnCount = this.pointer.safeRunInt(DB::column_count);
        this.paramCount = this.pointer.safeRunInt(DB::bind_parameter_count);
        this.batchQueryCount = 0;
        this.batch = null;
        this.batchPos = 0;
    }

    @Override
    public int[] executeBatch() {
        return Arrays.stream(((JDBC3Statement)this).executeLargeBatch()).mapToInt(l -> (int)l).toArray();
    }

    @Override
    public long[] executeLargeBatch() {
        if (this.batchQueryCount == 0) {
            return new long[0];
        }
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        CorePreparedStatement corePreparedStatement = this;
        return corePreparedStatement.withConnectionTimeout(() -> {
            try {
                long[] lArray = this.conn.getDatabase().executeBatch(this.pointer, this.batchQueryCount, this.batch, this.conn.getAutoCommit());
                return lArray;
            }
            finally {
                ((JDBC3Statement)this).clearBatch();
            }
        });
    }

    @Override
    public void clearBatch() {
        super.clearBatch();
        this.batchQueryCount = 0;
    }

    protected void batch(int n, Object object) {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        this.batch[this.batchPos + n - 1] = object;
    }

    protected void setDateByMilliseconds(int n, Long l, Calendar calendar) {
        SQLiteConnectionConfig sQLiteConnectionConfig = this.conn.getConnectionConfig();
        switch (sQLiteConnectionConfig.getDateClass()) {
            case TEXT: {
                this.batch(n, FastDateFormat.getInstance(sQLiteConnectionConfig.getDateStringFormat(), calendar.getTimeZone()).format(new Date(l)));
                return;
            }
            case REAL: {
                this.batch(n, new Double((double)l.longValue() / 8.64E7 + 2440587.5));
                return;
            }
        }
        this.batch(n, new Long(l / sQLiteConnectionConfig.getDateMultiplier()));
    }
}

