/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatIconColors;
import com.formdev.flatlaf.FlatInputMaps;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.LinuxFontPolicy;
import com.formdev.flatlaf.MnemonicHandler;
import com.formdev.flatlaf.SubMenuUsabilityHelper;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatPopupFactory;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.JavaCompatibility2;
import com.formdev.flatlaf.util.FontUtils;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;

public abstract class FlatLaf
extends BasicLookAndFeel {
    private static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private static List<Object> customDefaultsSources;
    private static Map<String, String> globalExtraDefaults;
    private Map<String, String> extraDefaults;
    private static Function<String, Color> systemColorGetter;
    private String desktopPropertyName;
    private String desktopPropertyName2;
    private PropertyChangeListener desktopPropertyListener;
    private static boolean aquaLoaded;
    private static boolean updateUIPending;
    private PopupFactory oldPopupFactory;
    private MnemonicHandler mnemonicHandler;
    private boolean subMenuUsabilityHelperInstalled;
    private Consumer<UIDefaults> postInitialization;
    private List<Function<Object, Object>> uiDefaultsGetters;
    private static String preferredFontFamily;
    private static String preferredLightFontFamily;
    private static String preferredSemiboldFontFamily;
    private static String preferredMonospacedFontFamily;
    public static final Object NULL_VALUE;

    public static boolean setup(LookAndFeel lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            return true;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to setup look and feel '" + lookAndFeel.getClass().getName() + "'.", exception);
            return false;
        }
    }

    @Deprecated
    public static boolean install(LookAndFeel lookAndFeel) {
        return FlatLaf.setup(lookAndFeel);
    }

    public static void installLafInfo(String string, Class<? extends LookAndFeel> clazz) {
        UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo(string, clazz.getName()));
    }

    @Override
    public String getID() {
        return "FlatLaf - " + this.getName();
    }

    public abstract boolean isDark();

    public static boolean isLafDark() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel instanceof FlatLaf && ((FlatLaf)lookAndFeel).isDark();
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        if (SystemInfo.isProjector || SystemInfo.isWebswing || SystemInfo.isWinPE) {
            return false;
        }
        if (SystemInfo.isWindows_10_orLater && FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return SystemInfo.isWindows_10_orLater || SystemInfo.isLinux;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent object, Icon object2) {
        if (object2 instanceof DisabledIconProvider) {
            object = ((DisabledIconProvider)object2).getDisabledIcon();
            if (!(object instanceof UIResource)) {
                return new IconUIResource((Icon)object);
            }
            return object;
        }
        if (object2 instanceof ImageIcon) {
            object = UIManager.get("Component.grayFilter");
            object = object instanceof ImageFilter ? (ImageFilter)object : GrayFilter.createDisabledIconFilter(this.isDark());
            object = arg_0 -> FlatLaf.lambda$getDisabledIcon$0((ImageFilter)object, arg_0);
            object2 = ((ImageIcon)object2).getImage();
            return new ImageIconUIResource(MultiResolutionImageSupport.map((Image)object2, object));
        }
        return null;
    }

    @Override
    public void initialize() {
        if (UIManager.getLookAndFeel() != this) {
            return;
        }
        if (SystemInfo.isMacOS) {
            this.initializeAqua();
        }
        super.initialize();
        this.oldPopupFactory = PopupFactory.getSharedInstance();
        PopupFactory.setSharedInstance(new FlatPopupFactory());
        this.mnemonicHandler = new MnemonicHandler();
        this.mnemonicHandler.install();
        this.subMenuUsabilityHelperInstalled = SubMenuUsabilityHelper.install();
        if (SystemInfo.isWindows) {
            this.desktopPropertyName = "win.messagebox.font";
        } else if (SystemInfo.isLinux) {
            this.desktopPropertyName = "gnome.Gtk/FontName";
            this.desktopPropertyName2 = "gnome.Xft/DPI";
        }
        if (this.desktopPropertyName != null) {
            this.desktopPropertyListener = object -> {
                if (!FlatSystemProperties.getBoolean("flatlaf.updateUIOnSystemFontChange", true)) {
                    return;
                }
                if (this.desktopPropertyName.equals(object = ((PropertyChangeEvent)object).getPropertyName()) || ((String)((Object)object)).equals(this.desktopPropertyName2)) {
                    FlatLaf.reSetLookAndFeel();
                    return;
                }
                if (DESKTOPFONTHINTS.equals(object) && UIManager.getLookAndFeel() instanceof FlatLaf) {
                    this.putAATextInfo(UIManager.getLookAndFeelDefaults());
                    FlatLaf.updateUILater();
                }
            };
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.getDesktopProperty("dummy");
            toolkit.addPropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            if (this.desktopPropertyName2 != null) {
                toolkit.addPropertyChangeListener(this.desktopPropertyName2, this.desktopPropertyListener);
            }
            toolkit.addPropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
        }
        this.postInitialization = serializable -> {
            if ((serializable = ((UIDefaults)serializable).getColor("Component.linkColor")) != null) {
                new HTMLEditorKit().getStyleSheet().addRule(String.format("a, address { color: #%06x; }", ((Color)serializable).getRGB() & 0xFFFFFF));
            }
        };
    }

    @Override
    public void uninitialize() {
        if (UIManager.getLookAndFeel() != this) {
            return;
        }
        if (this.desktopPropertyListener != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removePropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            if (this.desktopPropertyName2 != null) {
                toolkit.removePropertyChangeListener(this.desktopPropertyName2, this.desktopPropertyListener);
            }
            toolkit.removePropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
            this.desktopPropertyName = null;
            this.desktopPropertyName2 = null;
            this.desktopPropertyListener = null;
        }
        if (this.oldPopupFactory != null) {
            PopupFactory.setSharedInstance(this.oldPopupFactory);
            this.oldPopupFactory = null;
        }
        if (this.mnemonicHandler != null) {
            this.mnemonicHandler.uninstall();
            this.mnemonicHandler = null;
        }
        if (this.subMenuUsabilityHelperInstalled) {
            SubMenuUsabilityHelper.uninstall();
            this.subMenuUsabilityHelperInstalled = false;
        }
        new HTMLEditorKit().getStyleSheet().addRule("a, address { color: blue; }");
        this.postInitialization = null;
        super.uninitialize();
    }

    private void initializeAqua() {
        BasicLookAndFeel basicLookAndFeel;
        Object object;
        if (aquaLoaded) {
            return;
        }
        aquaLoaded = true;
        String string = "com.apple.laf.AquaLookAndFeel";
        try {
            if (SystemInfo.isJava_9_orLater) {
                object = UIManager.class.getMethod("createLookAndFeel", String.class);
                basicLookAndFeel = (BasicLookAndFeel)((Method)object).invoke(null, "Mac OS X");
            } else {
                basicLookAndFeel = Class.forName(string).asSubclass(BasicLookAndFeel.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to initialize Aqua look and feel '" + string + "'.", exception);
            throw new IllegalStateException();
        }
        object = PopupFactory.getSharedInstance();
        basicLookAndFeel.initialize();
        basicLookAndFeel.uninitialize();
        PopupFactory.setSharedInstance((PopupFactory)object);
    }

    @Override
    public UIDefaults getDefaults() {
        FlatUIDefaults flatUIDefaults = new FlatUIDefaults(1500, 0.75f);
        this.initClassDefaults(flatUIDefaults);
        this.initSystemColorDefaults(flatUIDefaults);
        this.initComponentDefaults(flatUIDefaults);
        flatUIDefaults.put("laf.dark", (Object)this.isDark());
        this.initResourceBundle(flatUIDefaults, "com.formdev.flatlaf.resources.Bundle");
        FlatUIDefaults flatUIDefaults2 = flatUIDefaults;
        this.putDefaults(flatUIDefaults2, flatUIDefaults2.getColor("control"), "Button.disabledBackground", "EditorPane.disabledBackground", "EditorPane.inactiveBackground", "FormattedTextField.disabledBackground", "PasswordField.disabledBackground", "RootPane.background", "Spinner.disabledBackground", "TextArea.disabledBackground", "TextArea.inactiveBackground", "TextField.disabledBackground", "TextPane.disabledBackground", "TextPane.inactiveBackground", "ToggleButton.disabledBackground");
        FlatUIDefaults flatUIDefaults3 = flatUIDefaults;
        this.putDefaults(flatUIDefaults3, flatUIDefaults3.getColor("textInactiveText"), "Button.disabledText", "CheckBox.disabledText", "CheckBoxMenuItem.disabledForeground", "Menu.disabledForeground", "MenuItem.disabledForeground", "RadioButton.disabledText", "RadioButtonMenuItem.disabledForeground", "Spinner.disabledForeground", "ToggleButton.disabledText");
        FlatUIDefaults flatUIDefaults4 = flatUIDefaults;
        this.putDefaults(flatUIDefaults4, flatUIDefaults4.getColor("textText"), "DesktopIcon.foreground", "RootPane.foreground");
        this.initFonts(flatUIDefaults);
        FlatLaf.initIconColors(flatUIDefaults, this.isDark());
        FlatInputMaps.initInputMaps(flatUIDefaults);
        Object object2 = flatUIDefaults.remove("InternalFrame.icon");
        flatUIDefaults.put("InternalFrame.icon", object2);
        flatUIDefaults.put("TitlePane.icon", object2);
        ServiceLoader<FlatDefaultsAddon> serviceLoader = ServiceLoader.load(FlatDefaultsAddon.class);
        ArrayList<FlatDefaultsAddon> arrayList = new ArrayList<FlatDefaultsAddon>();
        for (Object object : serviceLoader) {
            arrayList.add((FlatDefaultsAddon)object);
        }
        arrayList.sort((flatDefaultsAddon, flatDefaultsAddon2) -> flatDefaultsAddon.getPriority() - flatDefaultsAddon2.getPriority());
        List<Class<?>> list = this.getLafClassesForDefaultsLoading();
        if (list != null) {
            UIDefaultsLoader.loadDefaultsFromProperties(list, arrayList, this.getAdditionalDefaults(), this.isDark(), (UIDefaults)flatUIDefaults);
        } else {
            UIDefaultsLoader.loadDefaultsFromProperties(this.getClass(), arrayList, this.getAdditionalDefaults(), this.isDark(), (UIDefaults)flatUIDefaults);
        }
        this.initDefaultFont(flatUIDefaults);
        if (SystemInfo.isMacOS && Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            flatUIDefaults.put("MenuBarUI", "com.apple.laf.AquaMenuBarUI");
            flatUIDefaults.put("MenuBar.backgroundPainter", BorderFactory.createEmptyBorder());
        }
        this.putAATextInfo(flatUIDefaults);
        this.applyAdditionalDefaults(flatUIDefaults);
        for (FlatDefaultsAddon flatDefaultsAddon3 : arrayList) {
            flatDefaultsAddon3.afterDefaultsLoading(this, flatUIDefaults);
        }
        flatUIDefaults.put("laf.scaleFactor", uIDefaults -> Float.valueOf(UIScale.getUserScaleFactor()));
        if (this.postInitialization != null) {
            this.postInitialization.accept(flatUIDefaults);
            this.postInitialization = null;
        }
        return flatUIDefaults;
    }

    void applyAdditionalDefaults(UIDefaults uIDefaults) {
    }

    protected List<Class<?>> getLafClassesForDefaultsLoading() {
        return null;
    }

    protected Properties getAdditionalDefaults() {
        if (globalExtraDefaults == null && this.extraDefaults == null) {
            return null;
        }
        Properties properties = new Properties();
        if (globalExtraDefaults != null) {
            properties.putAll(globalExtraDefaults);
        }
        if (this.extraDefaults != null) {
            properties.putAll(this.extraDefaults);
        }
        return properties;
    }

    private void initResourceBundle(UIDefaults uIDefaults, String object) {
        uIDefaults.addResourceBundle((String)object);
        if (uIDefaults.get("TabbedPane.moreTabsButtonToolTipText") != null) {
            return;
        }
        try {
            object = ResourceBundle.getBundle((String)object, uIDefaults.getDefaultLocale());
            Enumeration<String> enumeration = ((ResourceBundle)object).getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = ((ResourceBundle)object).getString(string);
                String string3 = StringUtils.removeTrailing(string, ".textAndMnemonic");
                if (string3 != string) {
                    string = string2.replace("&", "");
                    String string4 = null;
                    int n = string2.indexOf(38);
                    if (n >= 0) {
                        string4 = Integer.toString(Character.toUpperCase(string2.charAt(n + 1)));
                    }
                    uIDefaults.put(string3 + "Text", string);
                    if (string4 == null) continue;
                    uIDefaults.put(string3 + "Mnemonic", string4);
                    continue;
                }
                uIDefaults.put(string, string2);
            }
            return;
        }
        catch (MissingResourceException missingResourceException) {
            LoggingFacade.INSTANCE.logSevere(null, missingResourceException);
            return;
        }
    }

    private void initFonts(UIDefaults uIDefaults) {
        ActiveFont activeFont = new ActiveFont(null, null, -1, 0, 0, 0, 0.0f);
        ArrayList<String> arrayList = new ArrayList<String>(50);
        for (Object object : uIDefaults.keySet()) {
            if (!(object instanceof String) || !((String)object).endsWith(".font") && !((String)object).endsWith("Font")) continue;
            arrayList.add((String)object);
        }
        for (String string : arrayList) {
            uIDefaults.put(string, activeFont);
        }
        uIDefaults.put("RootPane.font", activeFont);
        uIDefaults.put("TitlePane.font", activeFont);
    }

    private void initDefaultFont(UIDefaults uIDefaults) {
        Object object;
        Font font;
        Object object2;
        Object object3 = null;
        if (SystemInfo.isWindows) {
            object2 = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
            if (object2 != null) {
                if (SystemInfo.isWinPE) {
                    font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.defaultGUI.font");
                    if (font != null) {
                        object3 = FlatLaf.createCompositeFont(font.getFamily(), font.getStyle(), ((Font)object2).getSize());
                    }
                } else {
                    object3 = FlatLaf.createCompositeFont(((Font)object2).getFamily(), ((Font)object2).getStyle(), ((Font)object2).getSize());
                }
            }
        } else if (SystemInfo.isMacOS) {
            object2 = SystemInfo.isMacOS_10_15_Catalina_orLater ? (SystemInfo.isJetBrainsJVM_11_orLater ? ".AppleSystemUIFont" : "Helvetica Neue") : (SystemInfo.isMacOS_10_11_ElCapitan_orLater ? ".SF NS Text" : "Lucida Grande");
            object = FlatLaf.createCompositeFont((String)object2, 0, 13);
        } else if (SystemInfo.isLinux) {
            object2 = LinuxFontPolicy.getFont();
            object = object3 = object2 instanceof FontUIResource ? (FontUIResource)object2 : new FontUIResource((Font)object2);
        }
        if (object3 == null) {
            object3 = FlatLaf.createCompositeFont("SansSerif", 0, 12);
        }
        if (preferredFontFamily != null && (!ActiveFont.isFallbackFont((Font)(object2 = FlatLaf.createCompositeFont(FlatLaf.preferredFontFamily, ((Font)object3).getStyle(), ((Font)object3).getSize()))) || ActiveFont.isDialogFamily(FlatLaf.preferredFontFamily))) {
            object3 = object2;
        }
        if ((object2 = uIDefaults.remove("defaultFont")) instanceof ActiveFont) {
            Font font2 = font = object3;
            object3 = ((ActiveFont)object2).derive(font2, n -> Math.round((float)n * UIScale.computeFontScaleFactor(font2)));
        }
        object3 = UIScale.applyCustomScaleFactor((FontUIResource)object3);
        uIDefaults.put("defaultFont", object3);
    }

    static FontUIResource createCompositeFont(String object, int n, int n2) {
        FontUtils.loadFontFamily((String)object);
        object = StyleContext.getDefaultStyleContext().getFont((String)object, n, n2);
        if (object instanceof FontUIResource) {
            return (FontUIResource)object;
        }
        return new FontUIResource((Font)object);
    }

    public static UIDefaults.ActiveValue createActiveFontValue(float f) {
        return new ActiveFont(null, null, -1, 0, 0, 0, f);
    }

    public static void initIconColors(UIDefaults uIDefaults, boolean bl) {
        for (FlatIconColors flatIconColors : FlatIconColors.values()) {
            if (flatIconColors.light != !bl && flatIconColors.dark != bl) continue;
            uIDefaults.put(flatIconColors.key, new ColorUIResource(flatIconColors.rgb));
        }
    }

    private void putAATextInfo(UIDefaults uIDefaults) {
        if (SystemInfo.isMacOS && SystemInfo.isJetBrainsJVM) {
            uIDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            return;
        }
        if (SystemInfo.isJava_9_orLater) {
            Map map;
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty(DESKTOPFONTHINTS);
            if (object == null) {
                object = this.fallbackAATextInfo();
            }
            if (object instanceof Map && (object = (map = (Map)object).get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null && object != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && object != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                uIDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                uIDefaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
            return;
        }
        try {
            Object object = Class.forName("sun.swing.SwingUtilities2").getField("AA_TEXT_PROPERTY_KEY").get(null);
            Object object2 = Class.forName("sun.swing.SwingUtilities2$AATextInfo").getMethod("getAATextInfo", Boolean.TYPE).invoke(null, Boolean.TRUE);
            if (object2 == null) {
                object2 = this.fallbackAATextInfo();
            }
            uIDefaults.put(object, object2);
            return;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
            throw new RuntimeException(exception);
        }
    }

    private Object fallbackAATextInfo() {
        Object object;
        if (System.getProperty("awt.useSystemAAFontSettings") != null) {
            return null;
        }
        Object object2 = null;
        if (SystemInfo.isLinux && ((Toolkit)(object = Toolkit.getDefaultToolkit())).getDesktopProperty("gnome.Xft/Antialias") == null && ((Toolkit)object).getDesktopProperty("fontconfig/Antialias") == null) {
            object2 = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        if (object2 == null) {
            return null;
        }
        if (SystemInfo.isJava_9_orLater) {
            object = new HashMap<RenderingHints.Key, Object>();
            object.put(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
            object.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, null);
            return object;
        }
        try {
            return Class.forName("sun.swing.SwingUtilities2$AATextInfo").getConstructor(Object.class, Integer.class).newInstance(object2, null);
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
            throw new RuntimeException(exception);
        }
    }

    private void putDefaults(UIDefaults uIDefaults, Object object, String ... stringArray) {
        for (String string : stringArray) {
            uIDefaults.put(string, object);
        }
    }

    static List<Object> getCustomDefaultsSources() {
        return customDefaultsSources;
    }

    public static void registerCustomDefaultsSource(String string) {
        FlatLaf.registerCustomDefaultsSource(string, null);
    }

    public static void unregisterCustomDefaultsSource(String string) {
        FlatLaf.unregisterCustomDefaultsSource(string, null);
    }

    public static void registerCustomDefaultsSource(String string, ClassLoader classLoader) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(string);
        customDefaultsSources.add(classLoader);
    }

    public static void unregisterCustomDefaultsSource(String string, ClassLoader classLoader) {
        if (customDefaultsSources == null) {
            return;
        }
        int n = customDefaultsSources.size();
        for (int i = 0; i < n - 1; ++i) {
            Object object = customDefaultsSources.get(i);
            if (!string.equals(object) || customDefaultsSources.get(i + 1) != classLoader) continue;
            customDefaultsSources.remove(i + 1);
            customDefaultsSources.remove(i);
            return;
        }
    }

    public static void registerCustomDefaultsSource(URL uRL) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(uRL);
    }

    public static void unregisterCustomDefaultsSource(URL uRL) {
        if (customDefaultsSources == null) {
            return;
        }
        customDefaultsSources.remove(uRL);
    }

    public static void registerCustomDefaultsSource(File file) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(file);
    }

    public static void unregisterCustomDefaultsSource(File file) {
        if (customDefaultsSources == null) {
            return;
        }
        customDefaultsSources.remove(file);
    }

    public static Map<String, String> getGlobalExtraDefaults() {
        return globalExtraDefaults;
    }

    public static void setGlobalExtraDefaults(Map<String, String> map) {
        globalExtraDefaults = map;
    }

    public Map<String, String> getExtraDefaults() {
        return this.extraDefaults;
    }

    public void setExtraDefaults(Map<String, String> map) {
        this.extraDefaults = map;
    }

    public static Object parseDefaultsValue(String object, String string2, Class<?> clazz) {
        if ((object = UIDefaultsLoader.parseValue((String)object, string2 = UIDefaultsLoader.resolveValueFromUIManager(string2), clazz, null, string -> UIDefaultsLoader.resolveValueFromUIManager(string), Collections.emptyList())) instanceof UIDefaults.LazyValue) {
            object = ((UIDefaults.LazyValue)object).createValue(null);
        } else if (object instanceof UIDefaults.ActiveValue) {
            object = ((UIDefaults.ActiveValue)object).createValue(null);
        }
        return object;
    }

    public static Function<String, Color> getSystemColorGetter() {
        return systemColorGetter;
    }

    public static void setSystemColorGetter(Function<String, Color> function) {
        systemColorGetter = function;
    }

    private static void reSetLookAndFeel() {
        EventQueue.invokeLater(() -> {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                LookAndFeel lookAndFeel2 = lookAndFeel;
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(UIManager.class, "lookAndFeel", lookAndFeel2, lookAndFeel2);
                for (PropertyChangeListener propertyChangeListener : UIManager.getPropertyChangeListeners()) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
                FlatLaf.updateUI();
                return;
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to reinitialize look and feel '" + lookAndFeel.getClass().getName() + "'.", unsupportedLookAndFeelException);
                return;
            }
        });
    }

    public static void updateUI() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public static void updateUILater() {
        Class<FlatLaf> clazz = FlatLaf.class;
        synchronized (FlatLaf.class) {
            if (updateUIPending) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            updateUIPending = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            EventQueue.invokeLater(() -> {
                FlatLaf.updateUI();
                Class<FlatLaf> clazz = FlatLaf.class;
                synchronized (FlatLaf.class) {
                    updateUIPending = false;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            });
            return;
        }
    }

    public static boolean supportsNativeWindowDecorations() {
        return SystemInfo.isWindows_10_orLater && FlatNativeWindowBorder.isSupported();
    }

    public static boolean isUseNativeWindowDecorations() {
        return UIManager.getBoolean("TitlePane.useWindowDecorations");
    }

    public static void setUseNativeWindowDecorations(boolean bl) {
        UIManager.put("TitlePane.useWindowDecorations", bl);
        if (!(UIManager.getLookAndFeel() instanceof FlatLaf)) {
            return;
        }
        for (Window window : Window.getWindows()) {
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            FlatRootPaneUI.updateNativeWindowBorder(((RootPaneContainer)((Object)window)).getRootPane());
        }
    }

    public static void revalidateAndRepaintAllFramesAndDialogs() {
        for (Window window : Window.getWindows()) {
            JMenuBar jMenuBar;
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            if ((window instanceof JFrame ? ((JFrame)window).getJMenuBar() : (jMenuBar = window instanceof JDialog ? ((JDialog)window).getJMenuBar() : null)) != null) {
                jMenuBar.revalidate();
            }
            window.revalidate();
            window.repaint();
        }
    }

    public static void repaintAllFramesAndDialogs() {
        for (Window window : Window.getWindows()) {
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            window.repaint();
        }
    }

    private static boolean isDisplayableFrameOrDialog(Window window) {
        return window.isDisplayable() && (window instanceof JFrame || window instanceof JDialog);
    }

    public static boolean isShowMnemonics() {
        return MnemonicHandler.isShowMnemonics();
    }

    public static void showMnemonics(Component component) {
        MnemonicHandler.showMnemonics(true, component);
    }

    public static void hideMnemonics() {
        MnemonicHandler.showMnemonics(false, null);
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void registerUIDefaultsGetter(Function<Object, Object> function) {
        if (this.uiDefaultsGetters == null) {
            this.uiDefaultsGetters = new ArrayList<Function<Object, Object>>();
        }
        this.uiDefaultsGetters.remove(function);
        this.uiDefaultsGetters.add(function);
        FlatUIUtils.setUseSharedUIs(false);
    }

    public void unregisterUIDefaultsGetter(Function<Object, Object> function) {
        if (this.uiDefaultsGetters == null) {
            return;
        }
        this.uiDefaultsGetters.remove(function);
        if (this.uiDefaultsGetters.isEmpty()) {
            FlatUIUtils.setUseSharedUIs(true);
        }
    }

    public static void runWithUIDefaultsGetter(Function<Object, Object> function, Runnable runnable) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof FlatLaf) {
            ((FlatLaf)lookAndFeel).registerUIDefaultsGetter(function);
            try {
                runnable.run();
            }
            finally {
                ((FlatLaf)lookAndFeel).unregisterUIDefaultsGetter(function);
            }
        } else {
            runnable.run();
        }
    }

    public static Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        ComponentUI componentUI = JavaCompatibility2.getUI(jComponent);
        if (componentUI instanceof FlatStylingSupport.StyleableUI) {
            return ((FlatStylingSupport.StyleableUI)((Object)componentUI)).getStyleableInfos(jComponent);
        }
        return null;
    }

    public static <T> T getStyleableValue(JComponent jComponent, String string) {
        ComponentUI componentUI = JavaCompatibility2.getUI(jComponent);
        if (componentUI instanceof FlatStylingSupport.StyleableUI) {
            return (T)((FlatStylingSupport.StyleableUI)((Object)componentUI)).getStyleableValue(jComponent, string);
        }
        return null;
    }

    public static String getPreferredFontFamily() {
        return preferredFontFamily;
    }

    public static void setPreferredFontFamily(String string) {
        preferredFontFamily = string;
    }

    public static String getPreferredLightFontFamily() {
        return preferredLightFontFamily;
    }

    public static void setPreferredLightFontFamily(String string) {
        preferredLightFontFamily = string;
    }

    public static String getPreferredSemiboldFontFamily() {
        return preferredSemiboldFontFamily;
    }

    public static void setPreferredSemiboldFontFamily(String string) {
        preferredSemiboldFontFamily = string;
    }

    public static String getPreferredMonospacedFontFamily() {
        return preferredMonospacedFontFamily;
    }

    public static void setPreferredMonospacedFontFamily(String string) {
        preferredMonospacedFontFamily = string;
    }

    private static /* synthetic */ Image lambda$getDisabledIcon$0(ImageFilter object, Image image) {
        object = new FilteredImageSource(image.getSource(), (ImageFilter)object);
        return Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
    }

    static {
        NULL_VALUE = new Object();
    }

    public static interface DisabledIconProvider {
        public Icon getDisabledIcon();
    }

    private static class ImageIconUIResource
    extends ImageIcon
    implements UIResource {
        ImageIconUIResource(Image image) {
            super(image);
        }
    }

    static class ActiveFont
    implements UIDefaults.ActiveValue {
        private final String baseFontKey;
        private final List<String> families;
        private final int style;
        private final int styleChange;
        private final int absoluteSize;
        private final int relativeSize;
        private final float scaleSize;
        private FontUIResource font;
        private Font lastBaseFont;
        private boolean inCreateValue;

        ActiveFont(String string, List<String> list, int n, int n2, int n3, int n4, float f) {
            this.baseFontKey = string;
            this.families = list;
            this.style = n;
            this.styleChange = n2;
            this.absoluteSize = n3;
            this.relativeSize = n4;
            this.scaleSize = f;
        }

        @Override
        public synchronized Object createValue(UIDefaults serializable) {
            if (this.inCreateValue) {
                throw new IllegalStateException("FlatLaf: endless recursion in font");
            }
            serializable = null;
            this.inCreateValue = true;
            try {
                if (this.baseFontKey != null) {
                    serializable = (Font)UIDefaultsLoader.lazyUIManagerGet(this.baseFontKey);
                }
                if (serializable == null) {
                    serializable = UIManager.getFont("defaultFont");
                }
                if (serializable == null) {
                    serializable = UIManager.getFont("Label.font");
                }
            }
            finally {
                this.inCreateValue = false;
            }
            if (this.lastBaseFont != serializable) {
                this.lastBaseFont = serializable;
                this.font = this.derive((Font)serializable, n -> UIScale.scale(n));
            }
            return this.font;
        }

        FontUIResource derive(Font font, IntUnaryOperator intUnaryOperator) {
            int n;
            int n2;
            int n3 = font.getStyle();
            int n4 = font.getSize();
            int n5 = this.style != -1 ? this.style : (n2 = this.styleChange != 0 ? n3 & ~(this.styleChange >> 16 & 0xFFFF) | this.styleChange & 0xFFFF : n3);
            if ((this.absoluteSize > 0 ? intUnaryOperator.applyAsInt(this.absoluteSize) : (this.relativeSize != 0 ? n4 + intUnaryOperator.applyAsInt(this.relativeSize) : (n = this.scaleSize > 0.0f ? Math.round((float)n4 * this.scaleSize) : n4))) <= 0) {
                n = 1;
            }
            if (this.families != null && !this.families.isEmpty()) {
                Object object;
                String object3 = ActiveFont.preferredFamily(this.families);
                if (object3 != null && (!ActiveFont.isFallbackFont((Font)(object = FlatLaf.createCompositeFont(object3, n2, n))) || ActiveFont.isDialogFamily(object3))) {
                    return this.toUIResource((Font)object);
                }
                for (String string : this.families) {
                    FontUIResource fontUIResource = FlatLaf.createCompositeFont(string, n2, n);
                    if (ActiveFont.isFallbackFont(fontUIResource) && !ActiveFont.isDialogFamily(string)) continue;
                    return this.toUIResource(fontUIResource);
                }
            }
            if (n2 != n3 || n != n4) {
                FontUIResource fontUIResource;
                if ("Ubuntu Medium".equalsIgnoreCase(font.getName()) && "Ubuntu Light".equalsIgnoreCase(font.getFamily()) && !ActiveFont.isFallbackFont(fontUIResource = FlatLaf.createCompositeFont("Ubuntu Medium", n2, n))) {
                    return this.toUIResource(fontUIResource);
                }
                return this.toUIResource(font.deriveFont(n2, n));
            }
            return this.toUIResource(font);
        }

        private FontUIResource toUIResource(Font font) {
            if (font instanceof FontUIResource) {
                return (FontUIResource)font;
            }
            return new FontUIResource(font);
        }

        private static boolean isFallbackFont(Font font) {
            return "Dialog".equalsIgnoreCase(font.getFamily());
        }

        private static boolean isDialogFamily(String string) {
            return string.equalsIgnoreCase("Dialog");
        }

        private static String preferredFamily(List<String> object) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if ((string = string.toLowerCase(Locale.ENGLISH)).endsWith(" light") || string.endsWith("-thin")) {
                    return preferredLightFontFamily;
                }
                if (string.endsWith(" semibold") || string.endsWith("-medium")) {
                    return preferredSemiboldFontFamily;
                }
                if (!string.equals("monospaced")) continue;
                return preferredMonospacedFontFamily;
            }
            return null;
        }
    }

    private class FlatUIDefaults
    extends UIDefaults {
        private UIDefaults metalDefaults;

        FlatUIDefaults(int n, float f) {
            super(n, f);
        }

        @Override
        public Object get(Object object) {
            return this.get(object, null);
        }

        @Override
        public Object get(Object object, Locale locale) {
            Object object2 = this.getFromUIDefaultsGetters(object);
            if (object2 != null) {
                if (object2 != NULL_VALUE) {
                    return object2;
                }
                return null;
            }
            object2 = super.get(object, locale);
            if (object2 != null) {
                return object2;
            }
            if (object instanceof String && ((String)object).startsWith("FileChooser.")) {
                return this.getFromMetal((String)object, locale);
            }
            return null;
        }

        private Object getFromUIDefaultsGetters(Object object) {
            List list = FlatLaf.this.uiDefaultsGetters;
            if (list == null) {
                return null;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Object r = ((Function)list.get(i)).apply(object);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        private synchronized Object getFromMetal(String string, Locale locale) {
            if (this.metalDefaults == null) {
                this.metalDefaults = new MetalLookAndFeel(){

                    @Override
                    protected void initClassDefaults(UIDefaults uIDefaults) {
                    }

                    @Override
                    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
                    }
                }.getDefaults();
                this.metalDefaults.clear();
            }
            return this.metalDefaults.get(string, locale);
        }
    }
}

