/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.image.BufferedImage;
import java.util.Map;

public class FlatDropShadowBorder
extends FlatEmptyBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable
    protected Insets shadowInsets;
    @FlatStylingSupport.Styleable
    protected float shadowOpacity;
    private int shadowSize;
    private Image shadowImage;
    private Color lastShadowColor;
    private float lastShadowOpacity;
    private int lastShadowSize;
    private double lastSystemScaleFactor;
    private float lastUserScaleFactor;

    public FlatDropShadowBorder() {
        this((Color)null);
    }

    public FlatDropShadowBorder(Color color) {
        this(color, 4, 0.5f);
    }

    public FlatDropShadowBorder(Color color, int n, float f) {
        int n2 = n;
        this(color, new Insets(-n, -n, n2, n2), f);
    }

    public FlatDropShadowBorder(Color color, Insets insets, float f) {
        super(FlatDropShadowBorder.nonNegativeInsets(insets));
        this.shadowColor = color;
        this.shadowInsets = insets;
        this.shadowOpacity = f;
        this.shadowSize = this.maxInset(insets);
    }

    private static Insets nonNegativeInsets(Insets insets) {
        return new Insets(Math.max(insets.top, 0), Math.max(insets.left, 0), Math.max(insets.bottom, 0), Math.max(insets.right, 0));
    }

    private int maxInset(Insets insets) {
        return Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
    }

    @Override
    public Object applyStyleProperty(String string, Object object) {
        object = FlatStylingSupport.applyToAnnotatedObject(this, string, object);
        if (string.equals("shadowInsets")) {
            FlatDropShadowBorder flatDropShadowBorder = this;
            flatDropShadowBorder.applyStyleProperty(FlatDropShadowBorder.nonNegativeInsets(flatDropShadowBorder.shadowInsets));
            this.shadowSize = this.maxInset(this.shadowInsets);
        }
        return object;
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.shadowSize <= 0) {
            return;
        }
        HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n, n2, n3, n4, this::paintImpl);
    }

    private void paintImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
        Color color = this.shadowColor != null ? this.shadowColor : graphics2D.getColor();
        FlatDropShadowBorder flatDropShadowBorder = this;
        int n5 = flatDropShadowBorder.scale(flatDropShadowBorder.shadowSize, d);
        float f = UIScale.getUserScaleFactor();
        if (this.shadowImage == null || !color.equals(this.lastShadowColor) || this.lastShadowOpacity != this.shadowOpacity || this.lastShadowSize != n5 || this.lastSystemScaleFactor != d || this.lastUserScaleFactor != f) {
            this.shadowImage = FlatDropShadowBorder.createShadowImage(color, n5, this.shadowOpacity, (float)(d * (double)f));
            this.lastShadowColor = color;
            this.lastShadowOpacity = this.shadowOpacity;
            this.lastShadowSize = n5;
            this.lastSystemScaleFactor = d;
            this.lastUserScaleFactor = f;
        }
        FlatDropShadowBorder flatDropShadowBorder2 = this;
        int n6 = flatDropShadowBorder2.scale(flatDropShadowBorder2.shadowInsets.left, d);
        FlatDropShadowBorder flatDropShadowBorder3 = this;
        int n7 = flatDropShadowBorder3.scale(flatDropShadowBorder3.shadowInsets.right, d);
        FlatDropShadowBorder flatDropShadowBorder4 = this;
        int n8 = flatDropShadowBorder4.scale(flatDropShadowBorder4.shadowInsets.top, d);
        FlatDropShadowBorder flatDropShadowBorder5 = this;
        int n9 = flatDropShadowBorder5.scale(flatDropShadowBorder5.shadowInsets.bottom, d);
        int n10 = n - Math.min(n6, 0);
        int n11 = n2 - Math.min(n8, 0);
        n = n + n3 + Math.min(n7, 0);
        n2 = n2 + n4 + Math.min(n9, 0);
        n3 = n10 + n5;
        n4 = n11 + n5;
        int n12 = n - n5;
        int n13 = n2 - n5;
        int n14 = (n5 << 1) - 1;
        --n5;
        if (n6 > 0 || n8 > 0) {
            int n15 = n5;
            graphics2D.drawImage(this.shadowImage, n10, n11, n3, n4, 0, 0, n15, n15, null);
        }
        if (n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n3, n11, n12, n4, n5, 0, n5 + 1, n5, null);
        }
        if (n7 > 0 || n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n12, n11, n, n4, n5, 0, n14, n5, null);
        }
        if (n6 > 0) {
            int n16 = n5;
            graphics2D.drawImage(this.shadowImage, n10, n4, n3, n13, 0, n16, n16, n5 + 1, null);
        }
        if (n7 > 0) {
            int n17 = n5;
            graphics2D.drawImage(this.shadowImage, n12, n4, n, n13, n17, n17, n14, n5 + 1, null);
        }
        if (n6 > 0 || n9 > 0) {
            int n18 = n5;
            graphics2D.drawImage(this.shadowImage, n10, n13, n3, n2, 0, n18, n18, n14, null);
        }
        if (n9 > 0) {
            int n19 = n5;
            graphics2D.drawImage(this.shadowImage, n3, n13, n12, n2, n19, n19, n5 + 1, n14, null);
        }
        if (n7 > 0 || n9 > 0) {
            int n20 = n5;
            int n21 = n14;
            graphics2D.drawImage(this.shadowImage, n12, n13, n, n2, n20, n20, n21, n21, null);
        }
    }

    private int scale(int n, double d) {
        return (int)Math.ceil((double)UIScale.scale(n) * d);
    }

    private static BufferedImage createShadowImage(Color color, int n, float f, float f2) {
        int n2 = color.getRGB() & 0xFFFFFF;
        int n3 = (int)(255.0f * f);
        Color color2 = new Color(n2 | (n3 & 0xFF) << 24, true);
        Object object = new Color(n2 | (n3 / 2 & 0xFF) << 24, true);
        Paint paint = new Color(n2, true);
        int n4 = (n << 1) - 1;
        int n5 = n - 1;
        paint = new RadialGradientPaint(n5, (float)n5, (float)n - 0.75f * f2, new float[]{0.0f, 0.35f, 1.0f}, new Color[]{color2, object, paint});
        int n6 = n4;
        BufferedImage bufferedImage = new BufferedImage(n6, n6, 2);
        object = bufferedImage.createGraphics();
        try {
            ((Graphics2D)object).setPaint(paint);
            int n7 = n4;
            ((Graphics)object).fillRect(0, 0, n7, n7);
        }
        finally {
            ((Graphics)object).dispose();
        }
        return bufferedImage;
    }
}

