/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FlatProgressBarUI
extends BasicProgressBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int arc;
    @FlatStylingSupport.Styleable
    protected Dimension horizontalSize;
    @FlatStylingSupport.Styleable
    protected Dimension verticalSize;
    @FlatStylingSupport.Styleable
    protected boolean largeHeight;
    @FlatStylingSupport.Styleable
    protected boolean square;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatProgressBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.arc = UIManager.getInt("ProgressBar.arc");
        this.horizontalSize = UIManager.getDimension("ProgressBar.horizontalSize");
        this.verticalSize = UIManager.getDimension("ProgressBar.verticalSize");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = object -> {
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "JProgressBar.largeHeight": 
                case "JProgressBar.square": {
                    this.progressBar.revalidate();
                    this.progressBar.repaint();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.progressBar.revalidate();
                    this.progressBar.repaint();
                }
            }
        };
        this.progressBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            FlatProgressBarUI flatProgressBarUI = this;
            flatProgressBarUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatProgressBarUI.progressBar, "ProgressBar"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        FlatProgressBarUI flatProgressBarUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatProgressBarUI, flatProgressBarUI.progressBar, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent serializable) {
        Dimension dimension = super.getPreferredSize((JComponent)serializable);
        if (this.progressBar.isStringPainted() || FlatClientProperties.clientPropertyBoolean(serializable, "JProgressBar.largeHeight", this.largeHeight)) {
            serializable = this.progressBar.getInsets();
            FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
            if (this.progressBar.getOrientation() == 0) {
                dimension.height = Math.max(fontMetrics.getHeight() + ((Insets)serializable).top + ((Insets)serializable).bottom, this.getPreferredInnerHorizontal().height);
            } else {
                dimension.width = Math.max(fontMetrics.getHeight() + ((Insets)serializable).left + ((Insets)serializable).right, this.getPreferredInnerVertical().width);
            }
        }
        return dimension;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return UIScale.scale(this.horizontalSize);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return UIScale.scale(this.verticalSize);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent serializable) {
        boolean bl;
        Insets insets = this.progressBar.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n4 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        boolean bl2 = bl = this.progressBar.getOrientation() == 0;
        int n5 = FlatClientProperties.clientPropertyBoolean(serializable, "JProgressBar.square", this.square) ? 0 : Math.min(UIScale.scale(this.arc), bl ? n4 : n3);
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n5);
        graphics.setColor(this.progressBar.getBackground());
        ((Graphics2D)graphics).fill(float_);
        int n6 = 0;
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                ((Graphics2D)graphics).fill(new RoundRectangle2D.Float(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, n5, n5));
            }
        } else {
            n6 = this.getAmountFull(insets, n3, n4);
            serializable = bl ? new RoundRectangle2D.Float(serializable.getComponentOrientation().isLeftToRight() ? (float)n : (float)(n + (n3 - n6)), n2, n6, n4, n5, n5) : new RoundRectangle2D.Float(n, n2 + (n4 - n6), n3, n6, n5, n5);
            graphics.setColor(this.progressBar.getForeground());
            if (n6 < (bl ? n4 : n3)) {
                Area area = new Area(float_);
                area.intersect(new Area((Shape)((Object)serializable)));
                ((Graphics2D)graphics).fill(area);
            } else {
                ((Graphics2D)graphics).fill((Shape)((Object)serializable));
            }
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, n, n2, n3, n4, n6, insets);
        }
    }

    @Override
    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
        super.paintString(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics), n, n2, n3, n4, n5, insets);
    }

    @Override
    protected void setAnimationIndex(int n) {
        super.setAnimationIndex(n);
        double d = UIScale.getSystemScaleFactor(this.progressBar.getGraphicsConfiguration());
        if ((double)((int)d) != d) {
            this.progressBar.repaint();
        }
    }
}

