/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0016\u0010$\u001a\u0004\u0018\u00010\u00152\n\u0010%\u001a\u00060&j\u0002`'H\u0016J\b\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\tH\u0002J\u0006\u0010,\u001a\u00020\tJ\u0014\u0010-\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J!\u00105\u001a\u00020\t2\u0011\u00106\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b7H\u0087\u0002\u00a2\u0006\u0002\u00108R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropContainer;", "Landroidx/compose/ui/viewinterop/InteropContainer;", "root", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "placeInteropAbove", "", "requestRedraw", "Lkotlin/Function0;", "", "<init>", "(Ljava/awt/Container;ZLkotlin/jvm/functions/Function0;)V", "getRoot", "()Ljava/awt/Container;", "value", "getPlaceInteropAbove", "()Z", "setPlaceInteropAbove", "(Z)V", "interopComponents", "", "Landroidx/compose/ui/viewinterop/InteropViewHolder;", "rootModifier", "Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "getRootModifier", "()Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "setRootModifier", "(Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;)V", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "getSnapshotObserver", "()Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "scheduledUpdatesSwapchain", "Landroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain;", "contains", "holder", "holderOfView", "view", "", "Landroidx/compose/ui/viewinterop/InteropView;", "updateInteropComponentsOrder", "place", "unplace", "executeScheduledUpdates", "dispose", "postponingExecutingScheduledUpdates", "body", "scheduleUpdate", "action", "getClipRectForComponent", "Lorg/jetbrains/skiko/ClipRectangle;", "component", "Ljava/awt/Component;", "invoke", "content", "Landroidx/compose/runtime/Composable;", "(Lkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;I)V", "ui"})
public final class SwingInteropContainer
implements InteropContainer {
    private final Container root;
    private boolean placeInteropAbove;
    private Map<Container, InteropViewHolder> interopComponents;
    private TrackInteropPlacementModifierNode rootModifier;
    private final SnapshotStateObserver snapshotObserver;
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    public SwingInteropContainer(Container container2, boolean bl, Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this.root = container2;
        this.placeInteropAbove = bl;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver(SwingInteropContainer::snapshotObserver$lambda$0);
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain(function0);
    }

    @Override
    public final Container getRoot() {
        return this.root;
    }

    public final boolean getPlaceInteropAbove() {
        return this.placeInteropAbove;
    }

    public final void setPlaceInteropAbove(boolean bl) {
        if (this.placeInteropAbove != bl) {
            this.placeInteropAbove = bl;
            this.updateInteropComponentsOrder();
        }
    }

    @Override
    public final TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    @Override
    public final void setRootModifier(TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        this.rootModifier = trackInteropPlacementModifierNode;
    }

    @Override
    public final SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    @Override
    public final boolean contains(InteropViewHolder interopViewHolder) {
        Intrinsics.checkNotNullParameter((Object)interopViewHolder, (String)"");
        return this.interopComponents.containsKey(interopViewHolder.getGroup());
    }

    @Override
    public final InteropViewHolder holderOfView(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = (Component)object;
        Container container2 = ((Component)object).getParent();
        if (container2 == null) {
            object = "InteropView is assumed to be added to its group for its entire lifetime";
            throw new IllegalStateException(object.toString());
        }
        object = container2;
        return this.interopComponents.get(object);
    }

    private final void updateInteropComponentsOrder() {
        List<InteropViewHolder> list = InteropContainer_skikoKt.interopComponentsSortedByDrawOrder(this, this.interopComponents.values());
        SwingInteropContainer swingInteropContainer = this;
        swingInteropContainer.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.updateInteropComponentsOrder$lambda$2(swingInteropContainer, list)));
    }

    @Override
    public final void place(InteropViewHolder interopViewHolder) {
        Intrinsics.checkNotNullParameter((Object)interopViewHolder, (String)"");
        Container container2 = interopViewHolder.getGroup();
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().start();
        }
        boolean bl = this.interopComponents.putIfAbsent(container2, interopViewHolder) == null;
        int n2 = this.interopComponents.size();
        int n3 = InteropContainer_skikoKt.countInteropComponentsBelow(this, interopViewHolder);
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.place$lambda$3(n2, this, bl, n3, interopViewHolder)));
    }

    @Override
    public final void unplace(InteropViewHolder interopViewHolder) {
        Intrinsics.checkNotNullParameter((Object)interopViewHolder, (String)"");
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.unplace$lambda$4(interopViewHolder, this)));
        this.interopComponents.remove(interopViewHolder.getGroup());
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Check failed.");
        }
        boolean bl = this.scheduledUpdatesSwapchain.execute();
        if (bl) {
            this.getRoot().validate();
            this.getRoot().repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    public final void postponingExecutingScheduledUpdates(Function0<Unit> object) {
        Object object2;
        Intrinsics.checkNotNullParameter(object, (String)"");
        ScheduledUpdatesSwapchain scheduledUpdatesSwapchain = this.scheduledUpdatesSwapchain;
        try {
            object2 = ScheduledUpdatesSwapchain.access$getLock$p(scheduledUpdatesSwapchain);
            synchronized (object2) {
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(scheduledUpdatesSwapchain)) {
                    object = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException(object.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(scheduledUpdatesSwapchain, false);
            }
            object.invoke();
        }
        finally {
            object2 = ScheduledUpdatesSwapchain.access$getLock$p(scheduledUpdatesSwapchain);
            synchronized (object2) {
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(scheduledUpdatesSwapchain, true);
            }
        }
        this.executeScheduledUpdates();
    }

    @Override
    public final void scheduleUpdate(Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this.scheduledUpdatesSwapchain.scheduleUpdate(function0);
    }

    public final ClipRectangle getClipRectForComponent(Component object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        InteropViewHolder interopViewHolder = this.interopComponents.get(object);
        if (interopViewHolder == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder);
        return (ClipRectangle)interopViewHolder;
    }

    public final void invoke(Function2<? super Composer, ? super Integer, Unit> function2, Composer composer, int n2) {
        Intrinsics.checkNotNullParameter(function2, (String)"");
        composer = composer.startRestartGroup(-1827244710);
        int n3 = n2;
        if ((n2 & 6) == 0) {
            n3 = n2 | (composer.changedInstance(function2) ? 4 : 2);
        }
        if ((n2 & 0x30) == 0) {
            n3 |= composer.changedInstance((Object)this) ? 32 : 16;
        }
        if ((n3 & 0x13) != 18 || !composer.getSkipping()) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)-1827244710, (int)n3, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:271)");
            }
            CompositionLocalKt.CompositionLocalProvider((ProvidedValue)InteropContainer_skikoKt.getLocalInteropContainer().provides((Object)this), (Function2)((Function2)ComposableLambdaKt.rememberComposableLambda((int)-1220154854, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this, function2){
                final /* synthetic */ SwingInteropContainer this$0;
                final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                {
                    this.this$0 = swingInteropContainer;
                    this.$content = function2;
                }

                public final void invoke(Composer composer, int n2) {
                    if ((n2 & 3) != 2 || !composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-1220154854, (int)n2, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:275)");
                        }
                        InteropContainer_skikoKt.TrackInteropPlacementContainer(this.this$0, this.$content, composer, 0);
                        if (ComposerKt.isTraceInProgress()) {
                            return;
                        }
                    } else {
                        composer.skipToGroupEnd();
                    }
                }

                public final /* synthetic */ Object invoke(Object object, Object object2) {
                    this.invoke((Composer)object, ((Number)object2).intValue());
                    return Unit.INSTANCE;
                }
            }, (Composer)composer, (int)54)), (Composer)composer, (int)(0x30 | ProvidedValue.$stable));
            if (ComposerKt.isTraceInProgress()) {
                // empty if block
            }
        } else {
            composer.skipToGroupEnd();
        }
        ScopeUpdateScope scopeUpdateScope = composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((arg_0, arg_1) -> SwingInteropContainer.invoke$lambda$6(this, function2, n2, arg_0, arg_1));
            return;
        }
    }

    private static final Unit snapshotObserver$lambda$0(Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)function0, (String)"");
        function0.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit updateInteropComponentsOrder$lambda$2(SwingInteropContainer swingInteropContainer, List object) {
        int n2 = swingInteropContainer.getRoot().getComponents().length;
        object = ((Iterable)CollectionsKt.asReversed((List)object)).iterator();
        int n3 = 0;
        while (object.hasNext()) {
            int n4 = n3++;
            InteropViewHolder interopViewHolder = (InteropViewHolder)object.next();
            interopViewHolder.changeInteropViewIndex(swingInteropContainer.getRoot(), swingInteropContainer.placeInteropAbove ? n2 - 1 : n4);
        }
        return Unit.INSTANCE;
    }

    private static final Unit place$lambda$3(int n2, SwingInteropContainer swingInteropContainer, boolean bl, int n3, InteropViewHolder interopViewHolder) {
        int n4 = n2 - 1;
        if (!swingInteropContainer.placeInteropAbove) {
            n4 += swingInteropContainer.getRoot().getComponentCount() - (n2 -= bl ? 1 : 0);
        }
        n2 = n4 - n3;
        if (bl) {
            interopViewHolder.insertInteropView(swingInteropContainer.getRoot(), n2);
        } else {
            interopViewHolder.changeInteropViewIndex(swingInteropContainer.getRoot(), n2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unplace$lambda$4(InteropViewHolder interopViewHolder, SwingInteropContainer swingInteropContainer) {
        interopViewHolder.removeInteropView(swingInteropContainer.getRoot());
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$6(SwingInteropContainer swingInteropContainer, Function2 function2, int n2, Composer composer, int n3) {
        swingInteropContainer.invoke((Function2<? super Composer, ? super Integer, Unit>)function2, composer, RecomposeScopeImplKt.updateChangedFlags((int)(n2 | 1)));
        return Unit.INSTANCE;
    }
}

