/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.macos.cocoa;

import com.sun.jna.Pointer;
import dorkbox.jna.macos.cocoa.NSData;
import dorkbox.jna.macos.cocoa.NSObject;
import dorkbox.jna.macos.cocoa.NSString;
import dorkbox.jna.macos.foundation.ObjectiveC;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;

public class NSImage
extends NSObject {
    private static final Pointer objectClass = ObjectiveC.objc_lookUpClass("NSImage");
    private static final Pointer initWithContentsOfFile = ObjectiveC.sel_getUid("initWithContentsOfFile:");
    private static final Pointer initWithData = ObjectiveC.sel_getUid("initWithData:");

    public NSImage(NSData nSData) {
        super(ObjectiveC.class_createInstance(objectClass, 0));
        ObjectiveC.objc_msgSend(this, initWithData, new Object[]{nSData});
    }

    public NSImage(BufferedImage bufferedImage) {
        this(NSImage.toBytes(bufferedImage));
    }

    public NSImage(byte[] byArray) {
        this(new NSData(byArray));
    }

    public NSImage(File file) {
        super(ObjectiveC.class_createInstance(objectClass, 0));
        ObjectiveC.objc_msgSend(this, initWithContentsOfFile, new Object[]{new NSString(file.getAbsolutePath())});
    }

    private static byte[] toBytes(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

