/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerMask;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, Class<? extends ChannelHandler> clazz) {
        this.name = (String)ObjectUtil.checkNotNull((Object)string, (String)"name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.executionMask = ChannelHandlerMask.mask(clazz);
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound(2));
        return this;
    }

    static void invokeChannelRegistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelRegistered();
            }
        });
    }

    private void invokeChannelRegistered() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelRegistered(this);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).channelRegistered(this);
                }
                ((ChannelInboundHandler)channelHandler).channelRegistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelRegistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound(4));
        return this;
    }

    static void invokeChannelUnregistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelUnregistered();
            }
        });
    }

    private void invokeChannelUnregistered() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelUnregistered(this);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).channelUnregistered(this);
                }
                ((ChannelInboundHandler)channelHandler).channelUnregistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelUnregistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.findContextInbound(8));
        return this;
    }

    static void invokeChannelActive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelActive();
            }
        });
    }

    private void invokeChannelActive() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelActive(this);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).channelActive(this);
                }
                ((ChannelInboundHandler)channelHandler).channelActive(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelActive();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound(16));
        return this;
    }

    static void invokeChannelInactive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelInactive();
            }
        });
    }

    private void invokeChannelInactive() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelInactive(this);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).channelInactive(this);
                }
                ((ChannelInboundHandler)channelHandler).channelInactive(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelInactive();
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.findContextInbound(1), throwable);
        return this;
    }

    static void invokeExceptionCaught(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Throwable throwable) {
        ObjectUtil.checkNotNull((Object)throwable, (String)"cause");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            return;
        }
        try {
            eventExecutor.execute(new Runnable(){

                @Override
                public final void run() {
                    abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                }
            });
            return;
        }
        catch (Throwable throwable2) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
            }
            return;
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        block5: {
            if (this.invokeHandler()) {
                try {
                    this.handler().exceptionCaught(this, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString((Throwable)throwable2), (Object)throwable);
                        break block5;
                    }
                    if (logger.isWarnEnabled()) {
                        logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                    }
                    return;
                }
            }
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(128), object);
        return this;
    }

    static void invokeUserEventTriggered(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        ObjectUtil.checkNotNull((Object)object, (String)"event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeUserEventTriggered(object);
            }
        });
    }

    private void invokeUserEventTriggered(Object object) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.userEventTriggered(this, object);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).userEventTriggered(this, object);
                }
                ((ChannelInboundHandler)channelHandler).userEventTriggered(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireUserEventTriggered(object);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(32), object);
        return this;
    }

    static void invokeChannelRead(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        object = abstractChannelHandlerContext.pipeline.touch(ObjectUtil.checkNotNull((Object)object, (String)"msg"), abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object);
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelRead(object);
            }
        });
    }

    private void invokeChannelRead(Object object) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelRead(this, object);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).channelRead(this, object);
                }
                ((ChannelInboundHandler)channelHandler).channelRead(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelRead(object);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound(64));
        return this;
    }

    static void invokeChannelReadComplete(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
            return;
        }
        Tasks tasks = abstractChannelHandlerContext.invokeTasks;
        if (tasks == null) {
            abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        eventExecutor.execute(tasks.invokeChannelReadCompleteTask);
    }

    private void invokeChannelReadComplete() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelReadComplete(this);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).channelReadComplete(this);
                }
                ((ChannelInboundHandler)channelHandler).channelReadComplete(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelReadComplete();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound(256));
        return this;
    }

    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
            return;
        }
        Tasks tasks = abstractChannelHandlerContext.invokeTasks;
        if (tasks == null) {
            abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        eventExecutor.execute(tasks.invokeChannelWritableStateChangedTask);
    }

    private void invokeChannelWritabilityChanged() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.channelWritabilityChanged(this);
                }
                if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)channelHandler).channelWritabilityChanged(this);
                }
                ((ChannelInboundHandler)channelHandler).channelWritabilityChanged(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.fireChannelWritabilityChanged();
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.bind(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.connect(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.connect(socketAddress, socketAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.disconnect(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture close() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.close(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.deregister(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture bind(final SocketAddress socketAddress, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"localAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(512);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.bind(this, socketAddress, channelPromise);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).bind(this, socketAddress, channelPromise);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).bind(this, socketAddress, channelPromise);
                }
                ((ChannelOutboundHandler)channelHandler).bind(this, socketAddress, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        } else {
            this.bind(socketAddress, channelPromise);
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"remoteAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(1024);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.connect(this, socketAddress, socketAddress2, channelPromise);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                }
                ((ChannelOutboundHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        } else {
            this.connect(socketAddress, socketAddress2, channelPromise);
        }
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise channelPromise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(channelPromise);
        }
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(2048);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDisconnect(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDisconnect(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.disconnect(this, channelPromise);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).disconnect(this, channelPromise);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).disconnect(this, channelPromise);
                }
                ((ChannelOutboundHandler)channelHandler).disconnect(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        } else {
            this.disconnect(channelPromise);
        }
    }

    @Override
    public ChannelFuture close(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(4096);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeClose(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.close(this, channelPromise);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).close(this, channelPromise);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).close(this, channelPromise);
                }
                ((ChannelOutboundHandler)channelHandler).close(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        } else {
            this.close(channelPromise);
        }
    }

    @Override
    public ChannelFuture deregister(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(8192);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDeregister(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.deregister(this, channelPromise);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).deregister(this, channelPromise);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).deregister(this, channelPromise);
                }
                ((ChannelOutboundHandler)channelHandler).deregister(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        } else {
            this.deregister(channelPromise);
        }
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(16384);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(tasks.invokeReadTask);
        }
        return this;
    }

    private void invokeRead() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.read(this);
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).read(this);
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).read(this);
                }
                ((ChannelOutboundHandler)channelHandler).read(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        } else {
            this.read();
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            return;
        }
        this.write(object, channelPromise);
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        block5: {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.write(this, object, channelPromise);
                    break block5;
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).write(this, object, channelPromise);
                    break block5;
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).write(this, object, channelPromise);
                    break block5;
                }
                ((ChannelOutboundHandler)channelHandler).write(this, object, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(65536);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, tasks.invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
            return;
        }
        this.flush();
    }

    private void invokeFlush0() {
        block5: {
            try {
                ChannelHandler channelHandler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (channelHandler == headContext) {
                    headContext.flush(this);
                    break block5;
                }
                if (channelHandler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)channelHandler).flush(this);
                    break block5;
                }
                if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)channelHandler).flush(this);
                    break block5;
                }
                ((ChannelOutboundHandler)channelHandler).flush(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
            }
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
            return;
        }
        this.writeAndFlush(object, channelPromise);
    }

    private void write(Object object, boolean bl, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)object, (String)"msg");
        try {
            if (this.isNotValidPromise(channelPromise, true)) {
                ReferenceCountUtil.release((Object)object);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release((Object)object);
            throw runtimeException;
        }
        Object object2 = this.findContextOutbound(bl ? 98304 : 32768);
        object = this.pipeline.touch(object, (AbstractChannelHandlerContext)object2);
        EventExecutor eventExecutor = ((AbstractChannelHandlerContext)object2).executor();
        if (eventExecutor.inEventLoop()) {
            if (bl) {
                ((AbstractChannelHandlerContext)object2).invokeWriteAndFlush(object, channelPromise);
                return;
            }
            ((AbstractChannelHandlerContext)object2).invokeWrite(object, channelPromise);
            return;
        }
        if (!AbstractChannelHandlerContext.safeExecute(eventExecutor, (Runnable)(object2 = WriteTask.newInstance((AbstractChannelHandlerContext)object2, object, channelPromise, bl)), channelPromise, object, !bl)) {
            ((WriteTask)object2).cancel();
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        PromiseNotificationUtil.tryFailure((Promise)channelPromise, (Throwable)throwable, (InternalLogger)(channelPromise instanceof VoidChannelPromise ? null : logger));
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture channelFuture = this.succeededFuture;
        if (channelFuture == null) {
            this.succeededFuture = channelFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean isNotValidPromise(ChannelPromise channelPromise, boolean bl) {
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!bl && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int n) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.next, eventExecutor, n, 510)) {
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound(int n) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.prev, eventExecutor, n, 130560)) {
        }
        return abstractChannelHandlerContext;
    }

    private static boolean skipContext(AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor, int n, int n2) {
        return (abstractChannelHandlerContext.executionMask & (n2 | n)) == 0 || abstractChannelHandlerContext.executor() == eventExecutor && (abstractChannelHandlerContext.executionMask & n) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int n;
        do {
            if ((n = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, n, 2));
        return true;
    }

    final void setAddPending() {
        boolean bl = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl);
    }

    final void callHandlerAdded() {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
            return;
        }
        finally {
            this.setRemoved();
        }
    }

    private boolean invokeHandler() {
        int n = this.handlerState;
        return n == 2 || !this.ordered && n == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        return this.channel().hasAttr(attributeKey);
    }

    private static boolean safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object, boolean bl) {
        try {
            if (bl && eventExecutor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)eventExecutor).lazyExecute(runnable);
            } else {
                eventExecutor.execute(runnable);
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                if (object != null) {
                    ReferenceCountUtil.release((Object)object);
                }
            }
            finally {
                channelPromise.setFailure(throwable);
            }
            return false;
        }
    }

    public String toHintString() {
        return "'" + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    private static final class Tasks {
        private final AbstractChannelHandlerContext next;
        private final Runnable invokeChannelReadCompleteTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeChannelReadComplete();
            }
        };
        private final Runnable invokeReadTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeRead();
            }
        };
        private final Runnable invokeChannelWritableStateChangedTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeChannelWritabilityChanged();
            }
        };
        private final Runnable invokeFlushTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeFlush();
            }
        };

        Tasks(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            this.next = abstractChannelHandlerContext;
        }
    }

    static final class WriteTask
    implements Runnable {
        private static final ObjectPool<WriteTask> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<WriteTask>(){

            public final WriteTask newObject(ObjectPool.Handle<WriteTask> handle) {
                return new WriteTask(handle);
            }
        });
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean((String)"io.netty.transport.estimateSizeOnSubmit", (boolean)true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty.transport.writeTaskSizeOverhead", (int)32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        static WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
            WriteTask writeTask = (WriteTask)RECYCLER.get();
            WriteTask.init(writeTask, abstractChannelHandlerContext, object, channelPromise, bl);
            return writeTask;
        }

        private WriteTask(ObjectPool.Handle<? extends WriteTask> handle) {
            this.handle = handle;
        }

        protected static void init(WriteTask writeTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
            writeTask.ctx = abstractChannelHandlerContext;
            writeTask.msg = object;
            writeTask.promise = channelPromise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                writeTask.size = abstractChannelHandlerContext.pipeline.estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
                abstractChannelHandlerContext.pipeline.incrementPendingOutboundBytes(writeTask.size);
            } else {
                writeTask.size = 0;
            }
            if (bl) {
                writeTask.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public final void run() {
            try {
                this.decrementPendingOutboundBytes();
                if (this.size >= 0) {
                    this.ctx.invokeWrite(this.msg, this.promise);
                } else {
                    this.ctx.invokeWriteAndFlush(this.msg, this.promise);
                }
                return;
            }
            finally {
                this.recycle();
            }
        }

        final void cancel() {
            try {
                this.decrementPendingOutboundBytes();
                return;
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle((Object)this);
        }
    }
}

