/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.MaxMessagesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;

public abstract class DefaultMaxMessagesRecvByteBufAllocator
implements MaxMessagesRecvByteBufAllocator {
    private final boolean ignoreBytesRead;
    private volatile int maxMessagesPerRead;
    private volatile boolean respectMaybeMoreData = true;

    public DefaultMaxMessagesRecvByteBufAllocator() {
        this(1);
    }

    public DefaultMaxMessagesRecvByteBufAllocator(int n) {
        this(n, false);
    }

    DefaultMaxMessagesRecvByteBufAllocator(int n, boolean bl) {
        this.ignoreBytesRead = bl;
        this.maxMessagesPerRead(n);
    }

    @Override
    public int maxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    @Override
    public MaxMessagesRecvByteBufAllocator maxMessagesPerRead(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxMessagesPerRead");
        this.maxMessagesPerRead = n;
        return this;
    }

    public DefaultMaxMessagesRecvByteBufAllocator respectMaybeMoreData(boolean bl) {
        this.respectMaybeMoreData = bl;
        return this;
    }

    public final boolean respectMaybeMoreData() {
        return this.respectMaybeMoreData;
    }

    public abstract class MaxMessageHandle
    implements RecvByteBufAllocator.ExtendedHandle {
        private ChannelConfig config;
        private int maxMessagePerRead;
        private int totalMessages;
        private int totalBytesRead;
        private int attemptedBytesRead;
        private int lastBytesRead;
        private final boolean respectMaybeMoreData;
        private final UncheckedBooleanSupplier defaultMaybeMoreSupplier;

        public MaxMessageHandle() {
            this.respectMaybeMoreData = DefaultMaxMessagesRecvByteBufAllocator.this.respectMaybeMoreData;
            this.defaultMaybeMoreSupplier = new UncheckedBooleanSupplier(){

                public boolean get() {
                    return MaxMessageHandle.this.attemptedBytesRead == MaxMessageHandle.this.lastBytesRead;
                }
            };
        }

        @Override
        public void reset(ChannelConfig channelConfig) {
            this.config = channelConfig;
            this.maxMessagePerRead = DefaultMaxMessagesRecvByteBufAllocator.this.maxMessagesPerRead();
            MaxMessageHandle maxMessageHandle = this;
            maxMessageHandle.totalBytesRead = 0;
            maxMessageHandle.totalMessages = 0;
        }

        @Override
        public ByteBuf allocate(ByteBufAllocator byteBufAllocator) {
            return byteBufAllocator.ioBuffer(this.guess());
        }

        @Override
        public final void incMessagesRead(int n) {
            this.totalMessages += n;
        }

        @Override
        public void lastBytesRead(int n) {
            this.lastBytesRead = n;
            if (n > 0) {
                this.totalBytesRead += n;
            }
        }

        @Override
        public final int lastBytesRead() {
            return this.lastBytesRead;
        }

        @Override
        public boolean continueReading() {
            MaxMessageHandle maxMessageHandle = this;
            return maxMessageHandle.continueReading(maxMessageHandle.defaultMaybeMoreSupplier);
        }

        @Override
        public boolean continueReading(UncheckedBooleanSupplier uncheckedBooleanSupplier) {
            return !(!this.config.isAutoRead() || this.respectMaybeMoreData && !uncheckedBooleanSupplier.get() || this.totalMessages >= this.maxMessagePerRead || !DefaultMaxMessagesRecvByteBufAllocator.this.ignoreBytesRead && this.totalBytesRead <= 0);
        }

        @Override
        public void readComplete() {
        }

        @Override
        public int attemptedBytesRead() {
            return this.attemptedBytesRead;
        }

        @Override
        public void attemptedBytesRead(int n) {
            this.attemptedBytesRead = n;
        }

        protected final int totalBytesRead() {
            if (this.totalBytesRead < 0) {
                return Integer.MAX_VALUE;
            }
            return this.totalBytesRead;
        }
    }
}

