/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.group;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupException;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

final class DefaultChannelGroupFuture
extends DefaultPromise<Void>
implements ChannelGroupFuture {
    private final ChannelGroup group;
    private final Map<Channel, ChannelFuture> futures;
    private int successCount;
    private int failureCount;
    private final ChannelFutureListener childListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            boolean bl = channelFuture.isSuccess();
            Iterable<ChannelFuture> iterable = DefaultChannelGroupFuture.this;
            synchronized (iterable) {
                if (bl) {
                    DefaultChannelGroupFuture.this.successCount++;
                } else {
                    DefaultChannelGroupFuture.this.failureCount++;
                }
                boolean bl2 = bl = DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount == DefaultChannelGroupFuture.this.futures.size();
                assert (DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount <= DefaultChannelGroupFuture.this.futures.size());
            }
            if (bl) {
                if (DefaultChannelGroupFuture.this.failureCount > 0) {
                    iterable = new ArrayList(DefaultChannelGroupFuture.this.failureCount);
                    for (ChannelFuture channelFuture2 : DefaultChannelGroupFuture.this.futures.values()) {
                        if (channelFuture2.isSuccess()) continue;
                        iterable.add(new DefaultEntry<Channel, Throwable>(channelFuture2.channel(), channelFuture2.cause()));
                    }
                    DefaultChannelGroupFuture.this.setFailure0(new ChannelGroupException((Collection<Map.Entry<Channel, Throwable>>)iterable));
                    return;
                }
                DefaultChannelGroupFuture.this.setSuccess0();
            }
        }
    };

    DefaultChannelGroupFuture(ChannelGroup object, Collection<ChannelFuture> iterator, EventExecutor object22) {
        super((EventExecutor)object22);
        this.group = (ChannelGroup)ObjectUtil.checkNotNull((Object)object, (String)"group");
        ObjectUtil.checkNotNull(iterator, (String)"futures");
        object = new LinkedHashMap<Channel, ChannelFuture>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ChannelFuture channelFuture = iterator.next();
            object.put(channelFuture.channel(), channelFuture);
        }
        this.futures = Collections.unmodifiableMap(object);
        for (ChannelFuture channelFuture : this.futures.values()) {
            channelFuture.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    /*
     * WARNING - void declaration
     */
    DefaultChannelGroupFuture(ChannelGroup object, Map<Channel, ChannelFuture> object22, EventExecutor eventExecutor) {
        super((EventExecutor)var3_5);
        void var3_5;
        this.group = object;
        this.futures = Collections.unmodifiableMap(object22);
        for (ChannelFuture channelFuture : this.futures.values()) {
            channelFuture.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    @Override
    public final ChannelGroup group() {
        return this.group;
    }

    @Override
    public final ChannelFuture find(Channel channel) {
        return this.futures.get(channel);
    }

    @Override
    public final Iterator<ChannelFuture> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public final synchronized boolean isPartialSuccess() {
        return this.successCount != 0 && this.successCount != this.futures.size();
    }

    @Override
    public final synchronized boolean isPartialFailure() {
        return this.failureCount != 0 && this.failureCount != this.futures.size();
    }

    @Override
    public final DefaultChannelGroupFuture addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.addListener(genericFutureListener);
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        super.addListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        super.removeListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture await() {
        super.await();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture sync() {
        super.sync();
        return this;
    }

    @Override
    public final ChannelGroupException cause() {
        return (ChannelGroupException)super.cause();
    }

    private void setSuccess0() {
        super.setSuccess(null);
    }

    private void setFailure0(ChannelGroupException channelGroupException) {
        super.setFailure((Throwable)channelGroupException);
    }

    public final DefaultChannelGroupFuture setSuccess(Void void_) {
        throw new IllegalStateException();
    }

    public final boolean trySuccess(Void void_) {
        throw new IllegalStateException();
    }

    public final DefaultChannelGroupFuture setFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    public final boolean tryFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    protected final void checkDeadLock() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor != null && eventExecutor != ImmediateEventExecutor.INSTANCE && eventExecutor.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    private static final class DefaultEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        DefaultEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            throw new UnsupportedOperationException("read-only");
        }
    }
}

