/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newChannel(SelectorProvider selectorProvider, InternetProtocolFamily object) {
        try {
            object = (java.nio.channels.SocketChannel)SelectorProviderUtil.newChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider, object);
            if (object == null) {
                return selectorProvider.openSocketChannel();
            }
            return object;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(selectorProvider, null);
    }

    public NioSocketChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        this(NioSocketChannel.newChannel(selectorProvider, internetProtocolFamily));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        NioSocketChannel nioSocketChannel = this;
        this.config = nioSocketChannel.new NioSocketChannelConfig(nioSocketChannel, socketChannel.socket());
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.javaChannel().socket().isOutputShutdown() || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        Socket socket = this.javaChannel().socket();
        return socket.isInputShutdown() && socket.isOutputShutdown() || !this.isActive();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    protected final void doShutdownOutput() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
            return;
        }
        this.javaChannel().socket().shutdownOutput();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownOutput(nioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)((Object)NioSocketChannel.this.unsafe())).shutdownOutput(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownInput(nioSocketChannel.newPromise());
    }

    @Override
    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    NioSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdown(nioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    NioSocketChannel.this.shutdownOutputDone(channelFuture, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutputDone(final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            NioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
            return;
        }
        channelFuture2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture2) {
                NioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
            }
        });
    }

    private static void shutdownDone(ChannelFuture object, ChannelFuture object2, ChannelPromise channelPromise) {
        object = object.cause();
        object2 = object2.cause();
        if (object != null) {
            if (object2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", (Throwable)object2);
            }
            channelPromise.setFailure((Throwable)object);
            return;
        }
        if (object2 != null) {
            channelPromise.setFailure((Throwable)object2);
            return;
        }
        channelPromise.setSuccess();
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    private void shutdownInput0() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
            return;
        }
        this.javaChannel().socket().shutdownInput();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((java.nio.channels.SocketChannel)this.javaChannel(), (SocketAddress)socketAddress);
            return;
        }
        SocketUtils.bind((Socket)this.javaChannel().socket(), (SocketAddress)socketAddress);
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = SocketUtils.connect((java.nio.channels.SocketChannel)this.javaChannel(), (SocketAddress)socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    @Override
    protected void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) {
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), handle.attemptedBytesRead());
    }

    @Override
    protected int doWriteBytes(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        return byteBuf.readBytes((GatheringByteChannel)this.javaChannel(), n);
    }

    @Override
    protected long doWriteFileRegion(FileRegion fileRegion) {
        long l = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l);
    }

    private void adjustMaxBytesPerGatheringWrite(int n, int n2, int n3) {
        if (n == n2) {
            if (n << 1 > n3) {
                ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n << 1);
                return;
            }
        } else if (n > 4096 && n2 < n >>> 1) {
            ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n >>> 1);
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        int n = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n2 = ((NioSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n2);
            int n3 = channelOutboundBuffer.nioBufferCount();
            switch (n3) {
                case 0: {
                    n -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n4 = byteBuffer.remaining();
                    int n5 = socketChannel.write(byteBuffer);
                    if (n5 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n4, n5, n2);
                    channelOutboundBuffer.removeBytes(n5);
                    --n;
                    break;
                }
                default: {
                    long l = channelOutboundBuffer.nioBufferSize();
                    long l2 = socketChannel.write(byteBufferArray, 0, n3);
                    if (l2 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l, (int)l2, n2);
                    channelOutboundBuffer.removeBytes(l2);
                    --n;
                }
            }
        } while (n > 0);
        this.incompleteWrite(n < 0);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    private final class NioSocketChannelConfig
    extends DefaultSocketChannelConfig {
        private volatile int maxBytesPerGatheringWrite;

        private NioSocketChannelConfig(NioSocketChannel nioSocketChannel2, Socket socket) {
            super(nioSocketChannel2, socket);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        protected final void autoReadCleared() {
            NioSocketChannel.this.clearReadPending();
        }

        @Override
        public final NioSocketChannelConfig setSendBufferSize(int n) {
            super.setSendBufferSize(n);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }

        @Override
        public final <T> boolean setOption(ChannelOption<T> channelOption, T t) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t);
            }
            return super.setOption(channelOption, t);
        }

        @Override
        public final <T> T getOption(ChannelOption<T> channelOption) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
            }
            return super.getOption(channelOption);
        }

        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            if (PlatformDependent.javaVersion() >= 7) {
                NioSocketChannelConfig nioSocketChannelConfig = this;
                return nioSocketChannelConfig.getOptions(super.getOptions(), NioChannelOption.getOptions(this.jdkChannel()));
            }
            return super.getOptions();
        }

        final void setMaxBytesPerGatheringWrite(int n) {
            this.maxBytesPerGatheringWrite = n;
        }

        final int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        private void calculateMaxBytesPerGatheringWrite() {
            int n = this.getSendBufferSize() << 1;
            if (n > 0) {
                this.setMaxBytesPerGatheringWrite(n);
            }
        }

        private java.nio.channels.SocketChannel jdkChannel() {
            return ((NioSocketChannel)this.channel).javaChannel();
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
        }

        @Override
        protected final Executor prepareToClose() {
            try {
                if (NioSocketChannel.this.javaChannel().isOpen() && NioSocketChannel.this.config().getSoLinger() > 0) {
                    NioSocketChannel.this.doDeregister();
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

