/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import com.jogamp.common.net.AssetURLStreamHandler;
import com.jogamp.common.net.GenericURLStreamHandlerFactory;
import com.jogamp.common.net.PiggybackURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class AssetURLContext
implements PiggybackURLContext {
    private static final boolean DEBUG = IOUtil.DEBUG;
    public static final String asset_protocol = "asset";
    public static final String asset_protocol_prefix = "asset:";
    public static final String assets_folder = "assets/";

    public static AssetURLContext create(final ClassLoader classLoader) {
        return new AssetURLContext(){

            @Override
            public ClassLoader getClassLoader() {
                return classLoader;
            }
        };
    }

    public static AssetURLStreamHandler createHandler(ClassLoader classLoader) {
        return new AssetURLStreamHandler(AssetURLContext.create(classLoader));
    }

    public static URL createURL(String string, ClassLoader classLoader) {
        return new URL(null, string.startsWith(asset_protocol_prefix) ? string : asset_protocol_prefix + string, AssetURLContext.createHandler(classLoader));
    }

    public static URL createURL(String string) {
        return new URL(string.startsWith(asset_protocol_prefix) ? string : asset_protocol_prefix + string);
    }

    public static URLStreamHandler getRegisteredHandler() {
        GenericURLStreamHandlerFactory genericURLStreamHandlerFactory = GenericURLStreamHandlerFactory.register();
        if (genericURLStreamHandlerFactory != null) {
            return genericURLStreamHandlerFactory.getHandler(asset_protocol);
        }
        return null;
    }

    public static boolean registerHandler(ClassLoader classLoader) {
        GenericURLStreamHandlerFactory genericURLStreamHandlerFactory = GenericURLStreamHandlerFactory.register();
        if (genericURLStreamHandlerFactory != null) {
            genericURLStreamHandlerFactory.setHandler(asset_protocol, AssetURLContext.createHandler(classLoader));
            return true;
        }
        return false;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public String getImplementedProtocol() {
        return asset_protocol;
    }

    @Override
    public URLConnection resolve(String string) {
        return AssetURLContext.resolve(string, this.getClassLoader());
    }

    public static URLConnection resolve(String string, ClassLoader classLoader) {
        int n;
        URLConnection uRLConnection;
        URL uRL;
        block15: {
            Object object;
            block14: {
                uRL = null;
                uRLConnection = null;
                n = -1;
                if (DEBUG) {
                    System.err.println("AssetURLContext.resolve: <" + string + ">");
                }
                try {
                    string = IOUtil.cleanPathString(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
                try {
                    uRL = new URL(string);
                    uRLConnection = AssetURLContext.open(uRL);
                    n = uRLConnection != null ? 1 : -1;
                }
                catch (MalformedURLException malformedURLException) {
                    if (!DEBUG) break block14;
                    System.err.println("FAIL(1): " + malformedURLException.getMessage());
                }
            }
            if (uRLConnection == null && classLoader != null) {
                object = string;
                while (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                if (AndroidVersion.isAvailable) {
                    object = ((String)object).startsWith(assets_folder) ? object : assets_folder + (String)object;
                }
                int n2 = n = (uRLConnection = AssetURLContext.open(uRL = classLoader.getResource((String)object))) != null ? 2 : -1;
            }
            if (uRLConnection == null) {
                try {
                    object = new File(string);
                    if (((File)object).exists()) {
                        uRL = Uri.valueOf((File)object).toURL();
                        uRLConnection = AssetURLContext.open(uRL);
                        n = uRLConnection != null ? 3 : -1;
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block15;
                    System.err.println("FAIL(3): " + throwable.getMessage());
                }
            }
        }
        if (DEBUG) {
            System.err.println("AssetURLContext.resolve: type " + n + ": url <" + uRL + ">, conn <" + uRLConnection + ">, connURL <" + (uRLConnection != null ? uRLConnection.getURL() : null) + ">");
        }
        if (uRLConnection == null) {
            throw new FileNotFoundException("Could not look-up: " + string + " as URL, w/ ClassLoader or as File");
        }
        return uRLConnection;
    }

    private static URLConnection open(URL object) {
        if (object == null) {
            return null;
        }
        try {
            object = ((URL)object).openConnection();
            ((URLConnection)object).connect();
            return object;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("FAIL(2): " + iOException.getMessage());
            }
            return null;
        }
    }
}

