/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jogamp.common.Debug;

public class Bitstream<T> {
    private static final boolean DEBUG = Debug.debug("Bitstream");
    public static final int EOS = -1;
    private ByteStream<T> bytes;
    private int bitBuffer;
    private int bitsDataMark;
    private int bitCount;
    private int bitsCountMark;
    private boolean outputMode;
    private boolean throwIOExceptionOnEOF;
    private static final boolean useFastPathStream = true;
    private static final boolean useFastPathTypes = true;
    private static final String strZeroPadding = "0000000000000000000000000000000000000000000000000000000000000000";

    public Bitstream(ByteStream<T> byteStream, boolean bl) {
        this.bytes = byteStream;
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
        this.throwIOExceptionOnEOF = false;
    }

    private final void resetLocal() {
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.bitsDataMark = 0;
        this.bitsCountMark = -1;
    }

    private final void validateMode() {
        if (!this.canInput() && !this.canOutput()) {
            throw new IllegalArgumentException("stream can neither input nor output: " + this);
        }
        if (this.outputMode && !this.canOutput()) {
            throw new IllegalArgumentException("stream cannot output as requested: " + this);
        }
        if (!this.outputMode && !this.canInput()) {
            throw new IllegalArgumentException("stream cannot input as requested: " + this);
        }
    }

    public final void setThrowIOExceptionOnEOF(boolean bl) {
        this.throwIOExceptionOnEOF = bl;
    }

    public final boolean getThrowIOExceptionOnEOF() {
        return this.throwIOExceptionOnEOF;
    }

    public final void setStream(T t, boolean bl) {
        if (this.bytes != null && this.outputMode) {
            this.flush();
        }
        this.bytes.setStream(t);
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
    }

    public final ByteStream<T> getStream() {
        return this.bytes;
    }

    public final T getSubStream() {
        return this.bytes.getStream();
    }

    public final void close() {
        if (this.bytes != null && this.outputMode) {
            this.flush();
        }
        this.bytes.close();
        this.bytes = null;
        this.resetLocal();
    }

    public final int flush() {
        if (!this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        this.bytes.flush();
        if (this.bitCount != 0) {
            int n = this.bytes.write((byte)this.bitBuffer);
            this.bitBuffer = 0;
            this.bitCount = 0;
            if (-1 == n) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
        }
        return 0;
    }

    public final boolean canInput() {
        if (this.bytes != null) {
            return this.bytes.canInput();
        }
        return false;
    }

    public final boolean canOutput() {
        if (this.bytes != null) {
            return this.bytes.canOutput();
        }
        return false;
    }

    public final void mark(int n) {
        if (this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        this.bytes.mark(n);
        this.bitsDataMark = this.bitBuffer;
        this.bitsCountMark = this.bitCount;
    }

    public final void reset() {
        if (this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (this.bitsCountMark < 0) {
            throw new IllegalStateException("markpos not set: " + this);
        }
        this.bytes.reset();
        this.bitBuffer = this.bitsDataMark;
        this.bitCount = this.bitsCountMark;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final int getLastBitPos() {
        return 7 - this.bitCount;
    }

    public final int getBitPosition() {
        if (this.bitCount == 0) {
            return 0;
        }
        return 8 - this.bitCount;
    }

    public final int getBitBuffer() {
        return this.bitBuffer;
    }

    public final long position() {
        if (this.bytes == null) {
            return -1L;
        }
        if (this.bitCount == 0) {
            return this.bytes.position() << 3;
        }
        long l = this.bytes.position() - (long)(this.outputMode ? 0 : 1);
        return (l << 3) + 8L - (long)this.bitCount;
    }

    public final long position(long l) {
        if (0L > l) {
            throw new IllegalArgumentException("new position not positive: " + l);
        }
        this.bytes.position(0L);
        this.resetLocal();
        if (l > this.skip(l)) {
            return -1L;
        }
        return l;
    }

    public final int readBit(boolean bl) {
        if (this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (this.bitCount > 0) {
            --this.bitCount;
            if (bl) {
                return this.bitBuffer >>> this.bitCount & 1;
            }
            return this.bitBuffer >>> 7 - this.bitCount & 1;
        }
        this.bitBuffer = this.bytes.read();
        if (-1 == this.bitBuffer) {
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        this.bitCount = 7;
        if (bl) {
            return this.bitBuffer >>> 7;
        }
        return this.bitBuffer & 1;
    }

    public final int writeBit(boolean n, int n2) {
        if (!this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (this.bitCount > 0) {
            --this.bitCount;
            this.bitBuffer = n != 0 ? (this.bitBuffer |= (1 & n2) << this.bitCount) : (this.bitBuffer |= (1 & n2) << 7 - this.bitCount);
            if (this.bitCount == 0) {
                n = this.bytes.write((byte)this.bitBuffer);
                if (this.throwIOExceptionOnEOF && -1 == n) {
                    throw new IOException("EOS " + this);
                }
                return n;
            }
        } else {
            this.bitCount = 7;
            this.bitBuffer = n != 0 ? (1 & n2) << 7 : 1 & n2;
        }
        return this.bitBuffer;
    }

    public long skip(long l) {
        if (this.bytes == null) {
            throw new IllegalStateException("closed: " + this);
        }
        if (DEBUG) {
            System.err.println("Bitstream.skip.0: " + l + " - " + this.toStringImpl());
        }
        if (l > 0L) {
            int n;
            long l2;
            long l3;
            long l4;
            long l5;
            if (l <= (long)this.bitCount) {
                this.bitCount -= (int)l;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_N1: " + l + " - " + this.toStringImpl());
                }
                return l;
            }
            if (this.outputMode) {
                if (this.bitCount > 0 && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    return 0L;
                }
                this.bitBuffer = 0;
            }
            if ((l5 = ((l4 = this.bytes.skip(l3 = (l2 = l - (long)this.bitCount) >>> 3)) << 3) + (long)(n = (int)(l2 - (l3 << 3))) + (long)this.bitCount) < l) {
                this.bitCount = 0;
                this.bitBuffer = 0;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_EOS: " + l + " - " + this.toStringImpl());
                }
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return l5;
            }
            this.bitCount = 8 - n & 7;
            n = 0;
            if (!this.outputMode && this.bitCount > 0) {
                this.bitBuffer = this.bytes.read();
                if (-1 == this.bitBuffer) {
                    n = this.bitCount;
                    this.bitCount = 0;
                }
            }
            if (DEBUG) {
                System.err.println("Bitstream.skip.F_N2: " + l + ", notReadBits " + n + " - " + this.toStringImpl());
            }
            return l5 - (long)n;
        }
        return 0L;
    }

    public int readBits31(int n) {
        int n2;
        int n3;
        if (31 < n) {
            throw new IllegalArgumentException("n > 31: " + n);
        }
        if (this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (n == 0) {
            return 0;
        }
        int n4 = n;
        int n5 = Math.min(n, this.bitCount);
        if (n5 > 0) {
            n3 = (1 << n5) - 1;
            n2 = 7 - this.bitCount + 1;
            this.bitCount -= n5;
            n4 = n - n5;
            n = n3 & this.bitBuffer >>> n2;
            if (n4 == 0) {
                return n;
            }
        } else {
            n = 0;
        }
        assert (this.bitCount == 0);
        n3 = n5;
        do {
            this.bitBuffer = this.bytes.read();
            if (-1 == this.bitBuffer) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            n2 = Math.min(n4, 8);
            n5 = (1 << n2) - 1;
            this.bitCount = 8 - n2;
            n |= (n5 & this.bitBuffer) << n3;
            n3 += n2;
        } while ((n4 -= n2) > 0);
        return n;
    }

    public int writeBits31(int n, int n2) {
        if (31 < n) {
            throw new IllegalArgumentException("n > 31: " + n);
        }
        if (!this.outputMode || this.bytes == null) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (n > 0) {
            int n3;
            int n4;
            int n5 = n;
            int n6 = Math.min(n, this.bitCount);
            if (n6 > 0) {
                n4 = (1 << n6) - 1;
                n3 = 7 - this.bitCount + 1;
                this.bitCount -= n6;
                n5 = n - n6;
                this.bitBuffer |= (n4 & n2) << n3;
                if (this.bitCount == 0 && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    if (this.throwIOExceptionOnEOF) {
                        throw new IOException("EOS " + this);
                    }
                    return -1;
                }
                if (n5 == 0) {
                    return n2;
                }
            }
            assert (this.bitCount == 0);
            n4 = n6;
            do {
                n3 = Math.min(n5, 8);
                n = (1 << n3) - 1;
                this.bitCount = 8 - n3;
                n5 -= n3;
                this.bitBuffer = n & n2 >>> n4;
                n4 += n3;
                if (this.bitCount != 0 || -1 != this.bytes.write((byte)this.bitBuffer)) continue;
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            } while (n5 > 0);
        }
        return n2;
    }

    public final int readUInt8() {
        if (this.bitCount == 0) {
            if (this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n = this.bytes.read();
            if (this.throwIOExceptionOnEOF && -1 == n) {
                throw new IOException("EOS " + this);
            }
            return n;
        }
        return this.readBits31(8);
    }

    public final int writeInt8(byte by) {
        if (this.bitCount == 0) {
            if (!this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            by = (byte)this.bytes.write(by);
            if (this.throwIOExceptionOnEOF && -1 == by) {
                throw new IOException("EOS " + this);
            }
            return by;
        }
        return this.writeBits31(8, by);
    }

    public final int readUInt16(boolean bl) {
        if (this.bitCount == 0) {
            int n4;
            if (this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n = this.bytes.read();
            int n2 = n4 = -1 != n ? this.bytes.read() : -1;
            if (-1 == n4) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            if (bl) {
                return n << 8 | n4;
            }
            return n4 << 8 | n;
        }
        int n = this.readBits31(16);
        if (-1 == n) {
            return -1;
        }
        if (bl) {
            int n3 = 0xFF & n >>> 8;
            int n4 = 0xFF & n;
            return n4 << 8 | n3;
        }
        return n;
    }

    public static final int readUInt16(boolean bl, byte[] byArray, int n) {
        Bitstream.checkBounds(byArray, n, 2);
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        if (bl) {
            return n2 << 8 | n3;
        }
        return n3 << 8 | n2;
    }

    /*
     * WARNING - void declaration
     */
    public final int writeInt16(boolean bl, short s) {
        void var2_5;
        if (this.bitCount == 0) {
            void var1_4;
            if (!this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by = (byte)(0xFF & var2_5 >>> 8);
            byte by2 = (byte)(0xFF & var2_5);
            if (bl) {
                byte by3 = by;
                by = by2;
            } else {
                byte by4 = by2;
            }
            if (-1 != this.bytes.write((byte)var1_4) && -1 != this.bytes.write(by)) {
                return (int)var2_5;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl) {
            int n = 0xFF & var2_5 >>> 8;
            int n2 = 0xFF & var2_5;
            return this.writeBits31(16, n2 << 8 | n);
        }
        return this.writeBits31(16, (int)var2_5);
    }

    public final long readUInt32(boolean bl) {
        int n;
        if (this.bitCount == 0) {
            int n10;
            if (this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n7 = this.bytes.read();
            int n2 = -1 != n7 ? this.bytes.read() : -1;
            int n9 = -1 != n2 ? this.bytes.read() : -1;
            int n3 = n10 = -1 != n9 ? this.bytes.read() : -1;
            if (-1 == n10) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1L;
            }
            if (bl) {
                return 0xFFFFFFFFL & (long)(n7 << 24 | n2 << 16 | n9 << 8 | n10);
            }
            return 0xFFFFFFFFL & (long)(n10 << 24 | n9 << 16 | n2 << 8 | n7);
        }
        int n4 = this.readBits31(16);
        int n5 = n = -1 != n4 ? this.readBits31(16) : -1;
        if (-1 == n) {
            return -1L;
        }
        if (bl) {
            int n6 = 0xFF & n >>> 8;
            int n7 = 0xFF & n;
            int n8 = 0xFF & n4 >>> 8;
            n4 = 0xFF & n4;
            return 0xFFFFFFFFL & (long)(n4 << 24 | n8 << 16 | n7 << 8 | n6);
        }
        return 0xFFFFFFFFL & (long)(n << 16 | n4);
    }

    public static final long readUInt32(boolean bl, byte[] byArray, int n) {
        Bitstream.checkBounds(byArray, n, 4);
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        byte by4 = byArray[n + 3];
        if (bl) {
            return 0xFFFFFFFFL & (long)(by << 24 | by2 << 16 | by3 << 8 | by4);
        }
        return 0xFFFFFFFFL & (long)(by4 << 24 | by3 << 16 | by2 << 8 | by);
    }

    /*
     * WARNING - void declaration
     */
    public final int writeInt32(boolean bl, int n) {
        void var2_5;
        if (this.bitCount == 0) {
            void var1_4;
            byte by;
            if (!this.outputMode || this.bytes == null) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by2 = (byte)(0xFF & var2_5 >>> 24);
            byte by3 = (byte)(0xFF & var2_5 >>> 16);
            byte by4 = (byte)(0xFF & var2_5 >>> 8);
            byte by5 = (byte)(0xFF & var2_5);
            if (bl) {
                byte by6 = by2;
                by = by3;
                by3 = by4;
                by2 = by5;
            } else {
                byte by7 = by5;
                by = by4;
            }
            if (-1 != this.bytes.write((byte)var1_4) && -1 != this.bytes.write(by) && -1 != this.bytes.write(by3) && -1 != this.bytes.write(by2)) {
                return (int)var2_5;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl) {
            int n2 = 0xFF & var2_5 >>> 24;
            int n3 = 0xFF & var2_5 >>> 16;
            int n4 = 0xFF & var2_5 >>> 8;
            int n5 = 0xFF & var2_5;
            if (-1 != this.writeBits31(16, n3 << 8 | n2) && -1 != this.writeBits31(16, n5 << 8 | n4)) {
                return (int)var2_5;
            }
            return -1;
        }
        int n6 = 0xFFFF & var2_5 >>> 16;
        int n7 = 0xFFFF & var2_5;
        if (-1 != this.writeBits31(16, n7) && -1 != this.writeBits31(16, n6)) {
            return (int)var2_5;
        }
        return -1;
    }

    public static final long toUInt32Long(int n) {
        return 0xFFFFFFFFL & (long)n;
    }

    public static final int toUInt32Int(int n) {
        return Bitstream.uint32LongToInt(Bitstream.toUInt32Long(n));
    }

    public static final int uint32LongToInt(long l) {
        if (Integer.MAX_VALUE >= l) {
            return (int)l;
        }
        return -1;
    }

    public String toString() {
        return String.format("Bitstream[%s]", this.toStringImpl());
    }

    protected String toStringImpl() {
        long l;
        String string;
        if (this.bytes == null) {
            string = "closed";
            l = -1L;
        } else {
            string = this.outputMode ? "output" : "input";
            l = this.bytes.position();
        }
        return String.format(null, "%s, pos %d [byteP %d, bitCnt %d], bitbuf %s", string, this.position(), l, this.bitCount, Bitstream.toHexBinString(true, this.bitBuffer, 8));
    }

    /*
     * WARNING - void declaration
     */
    public static String toBinString(boolean bl, int n, int n2) {
        void var1_3;
        int n3;
        if (n3 == 0) {
            return "";
        }
        if (bl) {
            int cArray = (int)((1L << n3) - 1L);
            String i = Integer.toBinaryString(cArray & var1_3);
            return strZeroPadding.substring(0, (int)(n3 - i.length())) + i;
        }
        char[] cArray = new char[32];
        for (int string = 0; string < n3; ++string) {
            cArray[string] = 0 != (var1_3 & 1 << string) ? 49 : 48;
        }
        String string = new String(cArray, 0, n3);
        return string + strZeroPadding.substring(0, (int)(n3 - string.length()));
    }

    public static String toHexBinString(boolean bl, int n, int n2) {
        int n3 = n2 == 0 ? 2 : (n2 + 3) / 4;
        return String.format(null, "[0x%0" + n3 + "X, msbFirst %b, %s]", n, bl, Bitstream.toBinString(bl, n, n2));
    }

    public static final String toHexBinString(boolean bl, byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < n2; ++i) {
            int n3 = 0xFF & byArray[n + i];
            stringBuilder.append(Bitstream.toHexBinString(bl, n3, 8)).append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toHexBinString(boolean bl, ByteBuffer byteBuffer, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < n2; ++i) {
            int n3 = 0xFF & byteBuffer.get(n + i);
            stringBuilder.append(Bitstream.toHexBinString(bl, n3, 8)).append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static void checkBounds(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Buffer of size " + byArray.length + " cannot hold offset " + n + " + remaining " + n2);
        }
    }

    public static interface ByteStream<T> {
        public void setStream(T var1);

        public T getStream();

        public void close();

        public void flush();

        public boolean canInput();

        public boolean canOutput();

        public long position();

        public long position(long var1);

        public long skip(long var1);

        public void mark(int var1);

        public void reset();

        public int read();

        public int write(byte var1);
    }

    public static class ByteOutputStream
    implements ByteStream<OutputStream> {
        private BufferedOutputStream media;
        private long pos = 0L;

        public ByteOutputStream(OutputStream outputStream) {
            this.setStream(outputStream);
        }

        @Override
        public void setStream(OutputStream outputStream) {
            this.media = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : (outputStream != null ? new BufferedOutputStream(outputStream) : null);
            this.pos = 0L;
        }

        @Override
        public void close() {
            if (this.media != null) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() {
            if (this.media != null) {
                this.media.flush();
            }
        }

        @Override
        public boolean canInput() {
            return false;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l) {
            throw new UnsupportedOperationException("N/a for " + this.getClass().getCanonicalName());
        }

        @Override
        public long skip(long l) {
            long l2;
            for (l2 = l; l2 > 0L; --l2) {
                this.media.write(0);
            }
            long l3 = l - l2;
            this.pos += l3;
            return l3;
        }

        @Override
        public OutputStream getStream() {
            return this.media;
        }

        @Override
        public void mark(int n) {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int write(byte by) {
            by = (byte)(0xFF & by);
            this.media.write(by);
            if (DEBUG) {
                System.err.println("u8[" + this.pos + "] <- " + Bitstream.toHexBinString(true, by, 8));
            }
            ++this.pos;
            return by;
        }
    }

    public static class ByteInputStream
    implements ByteStream<InputStream> {
        private BufferedInputStream media;
        private long pos;
        private long posMark;

        public ByteInputStream(InputStream inputStream) {
            this.setStream(inputStream);
        }

        @Override
        public void setStream(InputStream inputStream) {
            this.media = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : (inputStream != null ? new BufferedInputStream(inputStream) : null);
            this.pos = 0L;
            this.posMark = -1L;
        }

        @Override
        public InputStream getStream() {
            return this.media;
        }

        @Override
        public void close() {
            if (this.media != null) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return false;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l) {
            throw new UnsupportedOperationException("N/a for " + this.getClass().getCanonicalName());
        }

        @Override
        public long skip(long l) {
            long l2 = this.media.skip(l);
            this.pos += l2;
            return l2;
        }

        @Override
        public void mark(int n) {
            this.media.mark(n);
            this.posMark = this.pos;
        }

        @Override
        public void reset() {
            if (0L > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.reset();
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n = this.media.read();
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + this.pos + "] -> " + Bitstream.toHexBinString(true, n, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] -> EOS");
                }
            }
            if (-1 != n) {
                ++this.pos;
            }
            return n;
        }

        @Override
        public int write(byte by) {
            throw new UnsupportedOperationException("not allowed with input stream");
        }
    }

    public static class ByteBufferStream
    implements ByteStream<ByteBuffer> {
        private ByteBuffer media;
        private int pos;
        private int posMark;

        public ByteBufferStream(ByteBuffer byteBuffer) {
            this.setStream(byteBuffer);
        }

        @Override
        public void setStream(ByteBuffer byteBuffer) {
            this.media = byteBuffer;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public ByteBuffer getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l) {
            if (l >= (long)this.media.limit()) {
                return -1L;
            }
            this.media.position((int)l);
            this.pos = (int)l;
            if (this.posMark > this.pos) {
                this.posMark = -1;
            }
            return this.pos;
        }

        @Override
        public long skip(long l) {
            long l2;
            if (l >= 0L) {
                int n = this.media.limit() - this.pos;
                l2 = Math.min(n, (int)l);
            } else {
                int n = -((int)l);
                l2 = -1 * Math.min(this.pos, n);
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }

        @Override
        public void mark(int n) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() {
            if (this.posMark < 0) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.position(this.posMark);
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n = this.media.limit() > this.pos ? 0xFF & this.media.get(this.pos++) : -1;
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(true, n, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] -> EOS");
                }
            }
            return n;
        }

        @Override
        public int write(byte by) {
            if (this.media.limit() > this.pos) {
                this.media.put(this.pos++, by);
                by = (byte)(0xFF & by);
            } else {
                by = (byte)-1;
            }
            if (DEBUG) {
                if (-1 != by) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(true, by, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] <- EOS");
                }
            }
            return by;
        }
    }

    public static class ByteArrayStream
    implements ByteStream<byte[]> {
        private byte[] media;
        private int pos;
        private int posMark;

        public ByteArrayStream(byte[] byArray) {
            this.setStream(byArray);
        }

        @Override
        public void setStream(byte[] byArray) {
            this.media = byArray;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public byte[] getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l) {
            if (l >= (long)this.media.length) {
                return -1L;
            }
            this.pos = (int)l;
            if (this.posMark > this.pos) {
                this.posMark = -1;
            }
            return this.pos;
        }

        @Override
        public long skip(long l) {
            long l2;
            if (l >= 0L) {
                int n = this.media.length - this.pos;
                l2 = Math.min(n, (int)l);
            } else {
                int n = -((int)l);
                l2 = -1 * Math.min(this.pos, n);
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }

        @Override
        public void mark(int n) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() {
            if (this.posMark < 0) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n = this.media.length > this.pos ? 0xFF & this.media[this.pos++] : -1;
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(true, n, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] -> EOS");
                }
            }
            return n;
        }

        @Override
        public int write(byte by) {
            if (this.media.length > this.pos) {
                this.media[this.pos++] = by;
                by = (byte)(0xFF & by);
            } else {
                by = (byte)-1;
            }
            if (DEBUG) {
                if (-1 != by) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(true, by, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] <- EOS");
                }
            }
            return by;
        }
    }
}

