/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.PropertyAccess;
import java.io.PrintStream;
import jogamp.common.Debug;

public abstract class TaskBase
implements Runnable {
    private static final boolean TRACE_SOURCE;
    protected final Object syncObject;
    protected final boolean catchExceptions;
    protected final PrintStream exceptionOut;
    protected final Throwable sourceStack;
    protected Object attachment;
    protected Throwable runnableException;
    protected long tCreated;
    protected long tStarted;
    protected volatile long tExecuted;
    protected volatile boolean isExecuted;
    protected volatile boolean isFlushed;
    protected volatile Thread execThread;

    protected TaskBase(Object object, boolean bl, PrintStream printStream) {
        this.syncObject = object;
        this.catchExceptions = bl;
        this.exceptionOut = printStream;
        this.sourceStack = TRACE_SOURCE ? new Throwable("Creation @") : null;
        this.tCreated = System.currentTimeMillis();
        this.tStarted = 0L;
        this.tExecuted = 0L;
        this.isExecuted = false;
        this.isFlushed = false;
        this.execThread = null;
    }

    protected final String getExceptionOutIntro() {
        if (this.catchExceptions) {
            return "A caught";
        }
        return "An uncaught";
    }

    protected final void printSourceTrace() {
        if (this.sourceStack != null && this.exceptionOut != null) {
            this.sourceStack.printStackTrace(this.exceptionOut);
        }
    }

    public final Thread getExecutionThread() {
        return this.execThread;
    }

    public final Object getSyncObject() {
        return this.syncObject;
    }

    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public abstract void run();

    public final void flush(Throwable object) {
        if (!this.isExecuted() && this.hasWaiter()) {
            this.runnableException = object;
            object = this.syncObject;
            synchronized (object) {
                this.isFlushed = true;
                this.syncObject.notifyAll();
                return;
            }
        }
    }

    public final boolean isInQueue() {
        return !this.isExecuted && !this.isFlushed;
    }

    public final boolean isExecuted() {
        return this.isExecuted;
    }

    public final boolean isFlushed() {
        return this.isFlushed;
    }

    public final boolean hasWaiter() {
        return this.syncObject != null;
    }

    public final Throwable getThrowable() {
        return this.runnableException;
    }

    public final long getTimestampCreate() {
        return this.tCreated;
    }

    public final long getTimestampBeforeExec() {
        return this.tStarted;
    }

    public final long getTimestampAfterExec() {
        return this.tExecuted;
    }

    public final long getDurationInQueue() {
        return this.tStarted - this.tCreated;
    }

    public final long getDurationInExec() {
        if (0L < this.tExecuted) {
            return this.tExecuted - this.tStarted;
        }
        return 0L;
    }

    public final long getDurationTotal() {
        if (0L < this.tExecuted) {
            return this.tExecuted - this.tCreated;
        }
        return this.tStarted - this.tCreated;
    }

    public String toString() {
        String string;
        String string2;
        if (this.execThread != null) {
            string2 = this.execThread.getName();
            string = "0x" + Integer.toHexString(this.execThread.hashCode());
        } else {
            string2 = "n/a";
            string = "n/a";
        }
        return "RunnableTask[enqueued " + this.isInQueue() + "[executed " + this.isExecuted() + ", flushed " + this.isFlushed() + ", thread[" + string + ", " + string2 + "]], tTotal " + this.getDurationTotal() + " ms, tExec " + this.getDurationInExec() + " ms, tQueue " + this.getDurationInQueue() + " ms, attachment " + this.attachment + ", throwable " + this.getThrowable() + "]";
    }

    static {
        Debug.initSingleton();
        TRACE_SOURCE = PropertyAccess.isPropertyDefined("jogamp.debug.TaskBase.TraceSource", true);
    }
}

