/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import jogamp.common.os.PlatformPropsImpl;

public class MachineDataInfoRuntime {
    static volatile boolean initialized = false;
    static volatile MachineDataInfo runtimeMD = null;
    static volatile MachineDataInfo.StaticConfig staticMD = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (initialized) throw new InternalError("Already initialized");
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) throw new InternalError("Already initialized");
            MachineDataInfo.StaticConfig.validateUniqueMachineDataInfo();
            MachineDataInfo machineDataInfo = MachineDataInfoRuntime.getRuntimeImpl();
            MachineDataInfo.StaticConfig staticConfig = MachineDataInfo.StaticConfig.findCompatible(machineDataInfo);
            if (staticConfig == null) {
                throw new RuntimeException("No compatible MachineDataInfo.StaticConfig for runtime:" + PlatformPropsImpl.NEWLINE + machineDataInfo);
            }
            if (!staticConfig.md.compatible(machineDataInfo)) {
                throw new RuntimeException("Incompatible MachineDataInfo:" + PlatformPropsImpl.NEWLINE + " Static " + (Object)((Object)staticConfig) + PlatformPropsImpl.NEWLINE + " Runtime " + machineDataInfo);
            }
            runtimeMD = machineDataInfo;
            staticMD = staticConfig;
            initialized = true;
            if (!PlatformPropsImpl.DEBUG) return;
            System.err.println("MachineDataInfoRuntime.initialize():" + PlatformPropsImpl.NEWLINE + " Static " + (Object)((Object)staticConfig) + PlatformPropsImpl.NEWLINE + " Runtime " + machineDataInfo);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDataInfo.StaticConfig getStatic() {
        if (initialized) return staticMD;
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) return staticMD;
            throw new InternalError("Not set");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDataInfo getRuntime() {
        if (initialized) return runtimeMD;
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) return runtimeMD;
            throw new InternalError("Not set");
        }
    }

    public static MachineDataInfo.StaticConfig guessStaticMachineDataInfo(Platform.OSType oSType, Platform.CPUType cPUType) {
        if (cPUType.is32Bit) {
            if (Platform.CPUFamily.ARM == cPUType.family || Platform.CPUType.MIPS_32 == cPUType) {
                return MachineDataInfo.StaticConfig.ARM_MIPS_32;
            }
            if (Platform.OSType.WINDOWS == oSType) {
                return MachineDataInfo.StaticConfig.X86_32_WINDOWS;
            }
            if (Platform.OSType.MACOS == oSType) {
                return MachineDataInfo.StaticConfig.X86_32_MACOS;
            }
            if (Platform.OSType.SUNOS == oSType && Platform.CPUType.SPARC_32 == cPUType) {
                return MachineDataInfo.StaticConfig.SPARC_32_SUNOS;
            }
            if (Platform.CPUType.PPC == cPUType) {
                return MachineDataInfo.StaticConfig.PPC_32_UNIX;
            }
            return MachineDataInfo.StaticConfig.X86_32_UNIX;
        }
        if (Platform.OSType.WINDOWS == oSType) {
            return MachineDataInfo.StaticConfig.X86_64_WINDOWS;
        }
        if (Platform.OSType.IOS == oSType && Platform.CPUType.ARM64 == cPUType) {
            return MachineDataInfo.StaticConfig.ARM64_IOS;
        }
        return MachineDataInfo.StaticConfig.LP64_UNIX;
    }

    private static MachineDataInfo getRuntimeImpl() {
        try {
            Platform.initSingleton();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
        int n = MachineDataInfoRuntime.getPointerSizeInBytesImpl();
        switch (n) {
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported pointer size " + n + "bytes, please implement.");
            }
        }
        long l = MachineDataInfoRuntime.getPageSizeInBytesImpl();
        if (Integer.MAX_VALUE < l) {
            throw new InternalError("PageSize exceeds integer value: " + l);
        }
        return new MachineDataInfo(true, MachineDataInfoRuntime.getSizeOfIntImpl(), MachineDataInfoRuntime.getSizeOfLongImpl(), MachineDataInfoRuntime.getSizeOfFloatImpl(), MachineDataInfoRuntime.getSizeOfDoubleImpl(), MachineDataInfoRuntime.getSizeOfLongDoubleImpl(), n, (int)l, MachineDataInfoRuntime.getAlignmentInt8Impl(), MachineDataInfoRuntime.getAlignmentInt16Impl(), MachineDataInfoRuntime.getAlignmentInt32Impl(), MachineDataInfoRuntime.getAlignmentInt64Impl(), MachineDataInfoRuntime.getAlignmentIntImpl(), MachineDataInfoRuntime.getAlignmentLongImpl(), MachineDataInfoRuntime.getAlignmentFloatImpl(), MachineDataInfoRuntime.getAlignmentDoubleImpl(), MachineDataInfoRuntime.getAlignmentLongDoubleImpl(), MachineDataInfoRuntime.getAlignmentPointerImpl());
    }

    private static native int getPointerSizeInBytesImpl();

    private static native long getPageSizeInBytesImpl();

    private static native int getAlignmentInt8Impl();

    private static native int getAlignmentInt16Impl();

    private static native int getAlignmentInt32Impl();

    private static native int getAlignmentInt64Impl();

    private static native int getAlignmentIntImpl();

    private static native int getAlignmentLongImpl();

    private static native int getAlignmentPointerImpl();

    private static native int getAlignmentFloatImpl();

    private static native int getAlignmentDoubleImpl();

    private static native int getAlignmentLongDoubleImpl();

    private static native int getSizeOfIntImpl();

    private static native int getSizeOfLongImpl();

    private static native int getSizeOfPointerImpl();

    private static native int getSizeOfFloatImpl();

    private static native int getSizeOfDoubleImpl();

    private static native int getSizeOfLongDoubleImpl();
}

