/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.elf.ElfHeaderPart1;
import jogamp.common.os.elf.ElfHeaderPart2;

public abstract class PlatformPropsImpl {
    static final boolean DEBUG;
    public static final String OS;
    public static final String OS_lower;
    public static final String OS_VERSION;
    public static final VersionNumber OS_VERSION_NUMBER;
    public static final String ARCH;
    public static final String ARCH_lower;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final VersionNumber JAVA_VERSION_NUMBER;
    public static final int JAVA_VERSION_UPDATE;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_RUNTIME_NAME;
    public static final boolean JAVA_SE;
    public static final boolean JAVA_6;
    public static final boolean JAVA_9;
    public static final boolean JAVA_17;
    public static final boolean JAVA_21;
    public static final String NEWLINE;
    public static final boolean LITTLE_ENDIAN;
    public static final Platform.CPUType CPU_ARCH;
    public static final Platform.ABIType ABI_TYPE;
    public static final Platform.OSType OS_TYPE;
    public static final String os_and_arch;
    public static final boolean useDynamicLibraries;

    public static final boolean isCompatible(Platform.CPUType cPUType, Platform.ABIType aBIType, Platform.CPUType cPUType2, Platform.ABIType aBIType2) {
        return cPUType.isCompatible(cPUType2) && aBIType.isCompatible(aBIType2);
    }

    protected PlatformPropsImpl() {
    }

    private static final String getJavaRuntimeNameImpl() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static final boolean initIsJavaSE() {
        if (JAVA_RUNTIME_NAME != null && JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean queryIsLittleEndianImpl() {
        Buffer buffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = ((ByteBuffer)buffer).asIntBuffer();
        buffer = ((ByteBuffer)buffer).asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == ((ShortBuffer)buffer).get(0);
    }

    private static final boolean contains(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static final File queryElfFile(Platform.OSType oSType) {
        File file;
        block7: {
            file = null;
            try {
                if (Platform.OSType.ANDROID == oSType) {
                    file = new File(NativeLibrary.findLibrary("gluegen_rt", PlatformPropsImpl.class.getClassLoader()));
                } else {
                    if (Platform.OSType.LINUX == oSType && !PlatformPropsImpl.checkFileReadAccess(file = new File("/proc/self/exe"))) {
                        file = null;
                    }
                    if (file == null) {
                        file = PlatformPropsImpl.findSysLib("java");
                    }
                    if (file == null) {
                        file = PlatformPropsImpl.findSysLib("jvm");
                    }
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block7;
                throwable.printStackTrace();
            }
        }
        return file;
    }

    private static final ElfHeaderPart1 readElfHeaderPart1(Platform.OSType oSType, RandomAccessFile randomAccessFile) {
        ElfHeaderPart1 elfHeaderPart1;
        block2: {
            elfHeaderPart1 = null;
            try {
                elfHeaderPart1 = ElfHeaderPart1.read(oSType, randomAccessFile);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return elfHeaderPart1;
    }

    private static final ElfHeaderPart2 readElfHeaderPart2(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) {
        ElfHeaderPart2 elfHeaderPart2;
        block2: {
            elfHeaderPart2 = null;
            try {
                elfHeaderPart2 = ElfHeaderPart2.read(elfHeaderPart1, randomAccessFile);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return elfHeaderPart2;
    }

    private static boolean checkFileReadAccess(File file) {
        try {
            return file.isFile() && file.canRead();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static File findSysLib(String object) {
        ClassLoader classLoader = PlatformPropsImpl.class.getClassLoader();
        String string = object;
        object = NativeLibrary.enumerateLibraryPaths(string, string, (String)object, true, classLoader);
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (String)object.get(i);
            object2 = new File((String)object2);
            if (DEBUG) {
                System.err.println("findSysLib #" + i + ": test " + object2);
            }
            if (PlatformPropsImpl.checkFileReadAccess((File)object2)) {
                return object2;
            }
            if (!DEBUG) continue;
            System.err.println("findSysLib #" + i + ": " + object2 + " not readable");
        }
        return null;
    }

    private static final Platform.OSType getOSTypeImpl(String string, boolean bl) {
        if (bl) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("linux")) {
            return Platform.OSType.LINUX;
        }
        if (string.startsWith("freebsd")) {
            return Platform.OSType.FREEBSD;
        }
        if (string.startsWith("android")) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("mac os x") || string.startsWith("darwin")) {
            return Platform.OSType.MACOS;
        }
        if (string.startsWith("sunos")) {
            return Platform.OSType.SUNOS;
        }
        if (string.startsWith("hp-ux")) {
            return Platform.OSType.HPUX;
        }
        if (string.startsWith("windows")) {
            return Platform.OSType.WINDOWS;
        }
        if (string.startsWith("kd")) {
            return Platform.OSType.OPENKODE;
        }
        if (string.startsWith("ios")) {
            return Platform.OSType.IOS;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
    }

    public static void initSingleton() {
    }

    public static final String getOSAndArch(Platform.OSType object, Platform.CPUType object2, Platform.ABIType aBIType, boolean bl) {
        switch (object2) {
            case ARM: 
            case ARMv5: 
            case ARMv6: 
            case ARMv7: {
                if (Platform.ABIType.EABI_GNU_ARMHF == aBIType) {
                    object2 = "armv6hf";
                    break;
                }
                object2 = "armv6";
                break;
            }
            case X86_32: {
                object2 = "i586";
                break;
            }
            case PPC: {
                object2 = "ppc";
                break;
            }
            case MIPS_32: {
                object2 = bl ? "mipsel" : "mips";
                break;
            }
            case SuperH: {
                object2 = "superh";
                break;
            }
            case SPARC_32: {
                object2 = "sparc";
                break;
            }
            case ARM64: 
            case ARMv8_A: {
                object2 = "aarch64";
                break;
            }
            case X86_64: {
                object2 = "amd64";
                break;
            }
            case PPC64: {
                object2 = bl ? "ppc64le" : "ppc64";
                break;
            }
            case MIPS_64: {
                object2 = "mips64";
                break;
            }
            case IA64: {
                object2 = "ia64";
                break;
            }
            case SPARCV9_64: {
                object2 = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                object2 = "risc2.0";
                break;
            }
            default: {
                throw new InternalError("Unhandled CPUType: " + (Object)object2);
            }
        }
        switch (object) {
            case ANDROID: {
                object = "android";
                break;
            }
            case MACOS: {
                object = "macosx";
                object2 = "universal";
                break;
            }
            case IOS: {
                object = "ios";
                break;
            }
            case WINDOWS: {
                object = "windows";
                break;
            }
            case OPENKODE: {
                object = "openkode";
                break;
            }
            case LINUX: {
                object = "linux";
                break;
            }
            case FREEBSD: {
                object = "freebsd";
                break;
            }
            case SUNOS: {
                object = "solaris";
                break;
            }
            case HPUX: {
                object = "hpux";
                object2 = "hppa";
                break;
            }
            default: {
                throw new InternalError("Unhandled OSType: " + (Object)object);
            }
        }
        return (String)object + "-" + (String)object2;
    }

    static {
        int n;
        Platform.CPUType[] cPUTypeArray;
        Object object;
        int n2;
        DEBUG = Debug.debug("Platform");
        boolean bl = AndroidVersion.isAvailable;
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VERSION_NUMBER = new VersionNumber(JAVA_VERSION);
        int n3 = JAVA_VERSION.lastIndexOf("-u");
        if (n3 > 0) {
            n2 = 2;
        } else {
            n3 = JAVA_VERSION.lastIndexOf("_");
            n2 = 1;
        }
        if (n3 > 0) {
            object = JAVA_VERSION.substring(n3 + n2);
            cPUTypeArray = new VersionNumber((String)object);
            JAVA_VERSION_UPDATE = cPUTypeArray.getMajor();
        } else {
            JAVA_VERSION_UPDATE = 0;
        }
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_NAME = PlatformPropsImpl.getJavaRuntimeNameImpl();
        JAVA_SE = PlatformPropsImpl.initIsJavaSE();
        if (JAVA_SE) {
            if (JAVA_VERSION_NUMBER.compareTo(new VersionNumber(21, 0, 0)) >= 0) {
                JAVA_21 = true;
                JAVA_17 = true;
                JAVA_9 = true;
                JAVA_6 = true;
            } else if (JAVA_VERSION_NUMBER.compareTo(new VersionNumber(17, 0, 0)) >= 0) {
                JAVA_21 = false;
                JAVA_17 = true;
                JAVA_9 = true;
                JAVA_6 = true;
            } else if (JAVA_VERSION_NUMBER.compareTo(new VersionNumber(9, 0, 0)) >= 0) {
                JAVA_21 = false;
                JAVA_17 = false;
                JAVA_9 = true;
                JAVA_6 = true;
            } else if (bl || JAVA_VERSION_NUMBER.compareTo(new VersionNumber(1, 6, 0)) >= 0) {
                JAVA_21 = false;
                JAVA_17 = false;
                JAVA_9 = false;
                JAVA_6 = true;
            } else {
                JAVA_21 = false;
                JAVA_17 = false;
                JAVA_9 = false;
                JAVA_6 = false;
            }
        } else {
            JAVA_21 = false;
            JAVA_17 = false;
            JAVA_9 = false;
            JAVA_6 = false;
        }
        NEWLINE = System.getProperty("line.separator");
        OS = System.getProperty("os.name");
        OS_lower = OS.toLowerCase();
        OS_VERSION = System.getProperty("os.version");
        OS_VERSION_NUMBER = new VersionNumber(OS_VERSION);
        OS_TYPE = PlatformPropsImpl.getOSTypeImpl(OS_lower, bl);
        final String[] stringArray = new String[]{null};
        cPUTypeArray = new Platform.CPUType[]{null};
        final Object object2 = new Platform.ABIType[]{null};
        final Object object3 = new int[]{0};
        final Object object4 = new boolean[]{false};
        SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object run() {
                RandomAccessFile randomAccessFile;
                block17: {
                    randomAccessFile = null;
                    Object object = PlatformPropsImpl.queryElfFile(OS_TYPE);
                    if (DEBUG) {
                        System.err.println("ELF-1: Using " + object);
                    }
                    randomAccessFile = new RandomAccessFile((File)object, "r");
                    object = PlatformPropsImpl.readElfHeaderPart1(OS_TYPE, randomAccessFile);
                    if (DEBUG) {
                        System.err.println("ELF-1: Got " + object);
                    }
                    if (object == null) break block17;
                    ElfHeaderPart2 elfHeaderPart2 = PlatformPropsImpl.readElfHeaderPart2((ElfHeaderPart1)object, randomAccessFile);
                    if (DEBUG) {
                        System.err.println("ELF-2: Got " + elfHeaderPart2);
                    }
                    if (elfHeaderPart2 == null) break block17;
                    stringArray[0] = elfHeaderPart2.cpuName;
                    cPUTypeArray[0] = elfHeaderPart2.cpuType;
                    object2[0] = elfHeaderPart2.abiType;
                    if (((ElfHeaderPart1)object).isLittleEndian()) {
                        object3[0] = 1;
                    } else if (((ElfHeaderPart1)object).isBigEndian()) {
                        object3[0] = 2;
                    }
                    object4[0] = true;
                }
                try {
                    randomAccessFile.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
                catch (Throwable throwable) {
                    try {
                        if (DEBUG) {
                            throwable.printStackTrace();
                        }
                        if (randomAccessFile == null) return null;
                    }
                    catch (Throwable throwable2) {
                        if (randomAccessFile == null) throw throwable2;
                        try {
                            randomAccessFile.close();
                            throw throwable2;
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        randomAccessFile.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
            }
        });
        String string = stringArray[0];
        Platform.CPUType cPUType = cPUTypeArray[0];
        object = object2[0];
        int n4 = object3[0];
        boolean bl2 = object4[0];
        if (DEBUG) {
            System.err.println("Platform.Elf: valid " + bl2 + ", elfCpuName " + string + ", cpuType " + (Object)((Object)cPUType) + ", abiType " + object + ", elfLittleEndian " + n4);
        }
        boolean bl3 = PlatformPropsImpl.queryIsLittleEndianImpl();
        if (bl2) {
            switch (n4) {
                case 1: {
                    LITTLE_ENDIAN = true;
                    break;
                }
                case 2: {
                    LITTLE_ENDIAN = false;
                    break;
                }
                default: {
                    LITTLE_ENDIAN = bl3;
                    break;
                }
            }
        } else {
            LITTLE_ENDIAN = bl3;
        }
        if (DEBUG) {
            System.err.println("Platform.Endian: test-little " + bl3 + ", elf[valid " + bl2 + ", val " + n4 + "] -> LITTLE_ENDIAN " + LITTLE_ENDIAN);
        }
        String string2 = System.getProperty("os.arch");
        object2 = string2.toLowerCase();
        Platform.CPUType cPUType2 = Platform.CPUType.query((String)object2);
        object3 = (Object)cPUType2;
        object4 = (Object)Platform.ABIType.query(cPUType2, (String)object2);
        if (DEBUG) {
            System.err.println("Platform.Property: ARCH " + string2 + ", CpuType " + object3 + ", ABIType " + object4);
        }
        if (bl) {
            if (DEBUG) {
                System.err.println("Android: CPU_ABI1 str " + AndroidVersion.CPU_ABI + ", CPU_TYPE " + (Object)((Object)AndroidVersion.CPU_TYPE) + ", ABI_TYPE " + (Object)((Object)AndroidVersion.ABI_TYPE));
                System.err.println("Android: CPU_ABI2 str " + AndroidVersion.CPU_ABI2 + ", CPU_TYPE2 " + (Object)((Object)AndroidVersion.CPU_TYPE2) + ", ABI_TYPE2 " + (Object)((Object)AndroidVersion.ABI_TYPE2));
            }
            if (bl2) {
                if (AndroidVersion.CPU_TYPE != null && PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), AndroidVersion.CPU_TYPE, AndroidVersion.ABI_TYPE)) {
                    ARCH_lower = ARCH = AndroidVersion.CPU_ABI;
                    CPU_ARCH = AndroidVersion.CPU_TYPE;
                    n = 110;
                } else if (AndroidVersion.CPU_TYPE2 != null && PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), AndroidVersion.CPU_TYPE2, AndroidVersion.ABI_TYPE2)) {
                    ARCH_lower = ARCH = AndroidVersion.CPU_ABI2;
                    CPU_ARCH = AndroidVersion.CPU_TYPE2;
                    n = 111;
                } else {
                    ARCH = cPUType.toString();
                    ARCH_lower = ARCH.toLowerCase();
                    CPU_ARCH = cPUType;
                    n = 112;
                }
                ABI_TYPE = object;
            } else if (AndroidVersion.CPU_TYPE.family == Platform.CPUFamily.ARM || AndroidVersion.CPU_TYPE.family == Platform.CPUFamily.X86 || AndroidVersion.CPU_TYPE2 == null) {
                ARCH_lower = ARCH = AndroidVersion.CPU_ABI;
                CPU_ARCH = AndroidVersion.CPU_TYPE;
                ABI_TYPE = AndroidVersion.ABI_TYPE;
                n = 120;
            } else {
                ARCH_lower = ARCH = AndroidVersion.CPU_ABI2;
                CPU_ARCH = AndroidVersion.CPU_TYPE2;
                ABI_TYPE = AndroidVersion.ABI_TYPE2;
                n = 121;
            }
        } else if (bl2) {
            if (PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), (Platform.CPUType)((Object)object3), (Platform.ABIType)((Object)object4))) {
                ARCH = string2;
                ARCH_lower = object2;
                CPU_ARCH = (Platform.CPUType)((Object)object3);
                ABI_TYPE = (Platform.ABIType)((Object)object4);
                n = 210;
            } else {
                ARCH = string;
                ARCH_lower = string;
                CPU_ARCH = cPUType;
                ABI_TYPE = object;
                n = 211;
            }
        } else {
            ARCH = string2;
            ARCH_lower = object2;
            CPU_ARCH = (Platform.CPUType)((Object)object3);
            ABI_TYPE = (Platform.ABIType)((Object)object4);
            n = 220;
        }
        useDynamicLibraries = Platform.OSType.IOS != OS_TYPE;
        if (DEBUG) {
            System.err.println("Platform.Hard: ARCH " + ARCH + ", CPU_ARCH " + (Object)((Object)CPU_ARCH) + ", ABI_TYPE " + (Object)((Object)ABI_TYPE) + " - strategy " + n + "(isAndroid " + bl + ", elfValid " + bl2 + "), useDynLibs " + useDynamicLibraries);
        }
        os_and_arch = PlatformPropsImpl.getOSAndArch(OS_TYPE, CPU_ARCH, ABI_TYPE, LITTLE_ENDIAN);
    }
}

